/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io;

import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.genepattern.data.expr.ExpressionData;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.matrix.ClassVector;
import org.genepattern.data.matrix.IClassVector;
import org.genepattern.io.FeatureListReader;
import org.genepattern.io.IOdfHandler;
import org.genepattern.io.OdfParser;
import org.genepattern.io.expr.ExpressionDataCreator;
import org.genepattern.io.expr.IExpressionDataCreator;
import org.genepattern.io.expr.IExpressionDataParser;
import org.genepattern.io.expr.IExpressionDataWriter;
import org.genepattern.io.expr.ReaderUtil;
import org.genepattern.io.expr.cls.ClsReader;
import org.genepattern.io.expr.cls.ClsWriter;
import org.genepattern.io.expr.gct.GctParser;
import org.genepattern.io.expr.gct.GctWriter;
import org.genepattern.io.expr.odf.OdfDatasetWriter;
import org.genepattern.io.expr.odf.OdfParserAdapter;
import org.genepattern.io.expr.res.ResParser;
import org.genepattern.io.expr.res.ResWriter;
import org.genepattern.io.expr.snp.SnpParser;
import org.genepattern.io.expr.snp.SnpWriter;

public class IOUtil {
    static Map suffix2ExpressionReaders;
    static ClsReader clsReader;
    static Map formatNameToExpressionWriterMap;
    private static boolean debug;
    private static FeatureListReader featureListReader;

    private IOUtil() {
    }

    public static final ClassVector readCls(String string) {
        return clsReader.read(string);
    }

    public static final List readFeatureList(String string) {
        return featureListReader.read(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeFeatureList(String[] stringArray, String string) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(string));
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                printWriter.println(stringArray[i2]);
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public static final Object readExpressionData(String string, IExpressionDataCreator iExpressionDataCreator) {
        IExpressionDataParser iExpressionDataParser = IOUtil.getExpressionParser(string);
        return ReaderUtil.read(iExpressionDataParser, string, iExpressionDataCreator);
    }

    public static final ExpressionData readExpressionData(String string) {
        return (ExpressionData)IOUtil.readExpressionData(string, new ExpressionDataCreator());
    }

    public static final ExpressionData readExpressionData(String string, InputStream inputStream) {
        IExpressionDataParser iExpressionDataParser = IOUtil.getExpressionReader(string, false);
        if (iExpressionDataParser == null) {
            return null;
        }
        return (ExpressionData)ReaderUtil.read(iExpressionDataParser, inputStream, (IExpressionDataCreator)new ExpressionDataCreator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String writeCls(IClassVector iClassVector, String string, boolean bl) {
        FileOutputStream fileOutputStream = null;
        try {
            ClsWriter clsWriter = new ClsWriter();
            if (bl) {
                string = clsWriter.checkFileExtension(string);
            }
            fileOutputStream = new FileOutputStream(string);
            clsWriter.write(iClassVector, fileOutputStream);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String write(IExpressionData iExpressionData, String string, String string2, boolean bl) {
        IExpressionDataWriter iExpressionDataWriter = (IExpressionDataWriter)formatNameToExpressionWriterMap.get(string);
        if (iExpressionDataWriter == null) {
            throw new IOException("No writer to save the data in " + string + " format.");
        }
        if (bl) {
            string2 = iExpressionDataWriter.checkFileExtension(string2);
        }
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(string2));
            iExpressionDataWriter.write(iExpressionData, outputStream);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void readOdf(String string, IOdfHandler iOdfHandler) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            OdfParser odfParser = new OdfParser();
            odfParser.setHandler(iOdfHandler);
            odfParser.parse(fileInputStream);
            fileInputStream.close();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IExpressionDataParser tryAllReaders(Iterator iterator, String string) {
        while (iterator.hasNext()) {
            IExpressionDataParser iExpressionDataParser = (IExpressionDataParser)iterator.next();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                try {
                    if (!iExpressionDataParser.canDecode(fileInputStream)) continue;
                    IExpressionDataParser iExpressionDataParser2 = iExpressionDataParser;
                    return iExpressionDataParser2;
                }
                catch (Exception exception) {
                    if (!debug) continue;
                    exception.printStackTrace();
                }
            }
            finally {
                if (fileInputStream == null) continue;
                fileInputStream.close();
            }
        }
        return null;
    }

    private static Iterator lookupProviders(Class clazz, Iterator iterator) {
        try {
            Class<?> clazz2 = Class.forName("javax.imageio.spi.ServiceRegistry");
            Method method = clazz2.getMethod("lookupProviders", Class.class);
            return (Iterator)method.invoke(null, clazz);
        }
        catch (Exception exception) {
            return iterator;
        }
    }

    public static final IExpressionDataParser getExpressionParser(String string) {
        return IOUtil.getExpressionReader(string, true);
    }

    public static final IExpressionDataParser getExpressionReader(String string, boolean bl) {
        IExpressionDataParser iExpressionDataParser = null;
        int n = string.lastIndexOf(".");
        if (n != -1) {
            String string2 = string.substring(n + 1, string.length());
            iExpressionDataParser = (IExpressionDataParser)suffix2ExpressionReaders.get(string2);
        }
        if (iExpressionDataParser == null && bl) {
            try {
                iExpressionDataParser = IOUtil.tryAllReaders(suffix2ExpressionReaders.values().iterator(), string);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return iExpressionDataParser;
    }

    public static final IExpressionDataWriter getExpressionWriterByFormatName(String string) {
        return (IExpressionDataWriter)formatNameToExpressionWriterMap.get(string);
    }

    static {
        Object object;
        clsReader = new ClsReader();
        debug = false;
        featureListReader = new FeatureListReader();
        Object object2 = Arrays.asList(new ResWriter(), new GctWriter(), new OdfDatasetWriter(), new SnpWriter());
        Object object3 = object2.iterator();
        formatNameToExpressionWriterMap = new HashMap();
        while (object3.hasNext()) {
            object = object3.next();
            formatNameToExpressionWriterMap.put(object.getFormatName(), object);
        }
        object3 = object2 = Arrays.asList(new GctParser(), new ResParser(), new OdfParserAdapter(), new SnpParser()).iterator();
        suffix2ExpressionReaders = new HashMap();
        while (object3.hasNext()) {
            object = (IExpressionDataParser)object3.next();
            List list = object.getFileSuffixes();
            int n = list.size();
            for (int i2 = 0; i2 < n; ++i2) {
                String string = (String)list.get(i2);
                suffix2ExpressionReaders.put(string, object);
            }
        }
        object = System.getProperty("edu.mit.broad.gp.debug");
        if ("true".equals(object)) {
            debug = true;
        }
    }
}

