/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io.expr.odf;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.io.OdfWriter;
import org.genepattern.io.expr.IExpressionDataWriter;

public class OdfDatasetWriter
implements IExpressionDataWriter {
    static final String FORMAT_NAME = "odf";
    private boolean prependExecutionLog = false;

    @Override
    public final String checkFileExtension(String string) {
        if (!string.toLowerCase().endsWith(".odf")) {
            string = string + ".odf";
        }
        return string;
    }

    public final void setPrependExecutionLog(boolean bl) {
        this.prependExecutionLog = bl;
    }

    @Override
    public final void write(IExpressionData iExpressionData, OutputStream outputStream) {
        int n;
        PrintWriter printWriter = new PrintWriter(outputStream);
        if (this.prependExecutionLog) {
            OdfWriter.appendExecutionLog(printWriter);
        }
        int n2 = iExpressionData.getRowCount();
        int n3 = iExpressionData.getColumnCount();
        printWriter.println("ODF 1.0");
        int n4 = 7;
        printWriter.println("HeaderLines=" + n4);
        printWriter.println("Model=Dataset");
        printWriter.print("COLUMN_NAMES:Name\tDescription\t");
        for (n = 0; n < n3 - 1; ++n) {
            printWriter.print(iExpressionData.getColumnName(n));
            printWriter.print("\t");
        }
        printWriter.println(iExpressionData.getColumnName(n3 - 1));
        printWriter.print("COLUMN_TYPES:");
        printWriter.print("String\tString");
        for (n = 0; n < n3 - 1; ++n) {
            printWriter.print("\tfloat");
        }
        printWriter.println("\tfloat");
        printWriter.print("COLUMN_DESCRIPTIONS:Name for each row\tDescription for each row\t");
        for (n = 0; n < n3 - 1; ++n) {
            String string = iExpressionData.getColumnMetadata(n, "description");
            if (string == null) {
                string = "";
            }
            printWriter.print(string);
            printWriter.print("\t");
        }
        String string = iExpressionData.getColumnMetadata(n3 - 1, "description");
        if (string == null) {
            string = "";
        }
        printWriter.println(string);
        printWriter.println("RowNamesColumn=0");
        printWriter.println("RowDescriptionsColumn=1");
        printWriter.print("DataLines=" + n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            printWriter.println();
            printWriter.print(iExpressionData.getRowName(i2));
            printWriter.print("\t");
            String string2 = iExpressionData.getRowMetadata(i2, "description");
            if (string2 == null) {
                string2 = "";
            }
            printWriter.print(string2);
            for (int i3 = 0; i3 < n3; ++i3) {
                printWriter.print("\t");
                printWriter.print(iExpressionData.getValueAsString(i2, i3));
            }
        }
        printWriter.flush();
    }

    @Override
    public final String getFormatName() {
        return FORMAT_NAME;
    }
}

