/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io.expr.res;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.expr.Util;
import org.genepattern.io.expr.IExpressionDataWriter;

public class ResWriter
implements IExpressionDataWriter {
    static final String FORMAT_NAME = "res";

    @Override
    public final String checkFileExtension(String string) {
        if (!string.toLowerCase().endsWith(".res")) {
            string = string + ".res";
        }
        return string;
    }

    @Override
    public final void write(IExpressionData iExpressionData, OutputStream outputStream) {
        int n;
        if (!Util.containsData(iExpressionData, "calls")) {
            throw new IOException("Can't write in res format. Data does not have calls.");
        }
        PrintWriter printWriter = new PrintWriter(outputStream);
        int n2 = iExpressionData.getRowCount();
        int n3 = iExpressionData.getColumnCount();
        printWriter.print("Description");
        printWriter.print("\t");
        printWriter.print("Accession");
        printWriter.print("\t");
        printWriter.print(iExpressionData.getColumnName(0));
        for (int i2 = 1; i2 < n3; ++i2) {
            printWriter.print("\t\t");
            printWriter.print(iExpressionData.getColumnName(i2));
        }
        printWriter.print("\n");
        printWriter.print("\t");
        String string = iExpressionData.getColumnMetadata(0, "description");
        if (string == null) {
            string = "";
        }
        printWriter.print(string);
        for (n = 1; n < n3; ++n) {
            printWriter.print("\t\t");
            string = iExpressionData.getColumnMetadata(n, "description");
            if (string == null) {
                string = "";
            }
            printWriter.print(string);
        }
        printWriter.print("\n");
        printWriter.print(n2);
        for (n = 0; n < n2; ++n) {
            printWriter.print("\n");
            String string2 = iExpressionData.getRowMetadata(n, "description");
            if (string2 == null) {
                string2 = "";
            }
            printWriter.print(string2);
            printWriter.print("\t");
            printWriter.print(iExpressionData.getRowName(n));
            for (int i3 = 0; i3 < n3; ++i3) {
                printWriter.print("\t");
                printWriter.print(iExpressionData.getValueAsString(n, i3));
                printWriter.print("\t");
                printWriter.print(iExpressionData.getData(n, i3, "calls"));
            }
        }
        printWriter.flush();
    }

    @Override
    public final String getFormatName() {
        return FORMAT_NAME;
    }
}

