/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.dom4j;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Branch;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;
import org.dom4j.io.SAXReader;
import org.jaxen.DefaultNavigator;
import org.jaxen.FunctionCallException;
import org.jaxen.XPath;
import org.jaxen.dom4j.DocumentNavigator$Singleton;
import org.jaxen.dom4j.Dom4jXPath;
import org.jaxen.util.SingleObjectIterator;

public class DocumentNavigator
extends DefaultNavigator {
    private transient SAXReader reader;

    public final Iterator getAttributeAxisIterator(Object object) {
        if (!(object instanceof Element)) {
            return null;
        }
        Element element = (Element)object;
        return element.attributeIterator();
    }

    public final String getAttributeName(Object object) {
        Attribute attribute = (Attribute)object;
        return attribute.getName();
    }

    public final String getAttributeNamespaceUri(Object object) {
        Attribute attribute = (Attribute)object;
        String string = attribute.getNamespaceURI();
        if (string != null && string.length() == 0) {
            return null;
        }
        return string;
    }

    public final String getAttributeQName(Object object) {
        Attribute attribute = (Attribute)object;
        return attribute.getQualifiedName();
    }

    public final String getAttributeStringValue(Object object) {
        return this.getNodeStringValue((Node)object);
    }

    public final Iterator getChildAxisIterator(Object object) {
        if (object instanceof Branch) {
            Branch branch = (Branch)object;
            return branch.nodeIterator();
        }
        return null;
    }

    public final String getCommentStringValue(Object object) {
        Comment comment = (Comment)object;
        return comment.getText();
    }

    public final Object getDocument(String string) {
        try {
            return this.getSAXReader().read(string);
        }
        catch (DocumentException documentException) {
            throw new FunctionCallException("Failed to parse doucment for URI: " + string, documentException);
        }
    }

    public final Object getDocumentNode(Object object) {
        if (object instanceof Document) {
            return object;
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            return node.getDocument();
        }
        return null;
    }

    public final String getElementName(Object object) {
        Element element = (Element)object;
        return element.getName();
    }

    public final String getElementNamespaceUri(Object object) {
        Element element = (Element)object;
        String string = element.getNamespaceURI();
        if (string != null && string.length() == 0) {
            return null;
        }
        return string;
    }

    public final String getElementQName(Object object) {
        Element element = (Element)object;
        return element.getQualifiedName();
    }

    public final String getElementStringValue(Object object) {
        return this.getNodeStringValue((Node)object);
    }

    public static final DocumentNavigator getInstance() {
        return DocumentNavigator$Singleton.access$0();
    }

    public final Iterator getNamespaceAxisIterator(Object object) {
        if (!(object instanceof Element)) {
            return null;
        }
        Element element = (Element)object;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        HashSet<String> hashSet = new HashSet<String>();
        Element element2 = element;
        while (element2 != null) {
            List list = element2.declaredNamespaces();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Namespace namespace = (Namespace)iterator.next();
                String string = namespace.getPrefix();
                if (hashSet.contains(string)) continue;
                hashSet.add(string);
                arrayList.add(namespace.asXPathResult(element));
            }
            element2 = element2.getParent();
        }
        arrayList.add(Namespace.XML_NAMESPACE.asXPathResult(element));
        return arrayList.iterator();
    }

    public final String getNamespacePrefix(Object object) {
        Namespace namespace = (Namespace)object;
        return namespace.getPrefix();
    }

    public final String getNamespaceStringValue(Object object) {
        Namespace namespace = (Namespace)object;
        return namespace.getURI();
    }

    private String getNodeStringValue(Node node) {
        return node.getStringValue();
    }

    public final short getNodeType(Object object) {
        if (object instanceof Node) {
            return ((Node)object).getNodeType();
        }
        return 0;
    }

    public final Iterator getParentAxisIterator(Object object) {
        if (object instanceof Document) {
            return new SingleObjectIterator(object);
        }
        Node node = (Node)object;
        Branch branch = node.getParent();
        if (branch == null) {
            branch = node.getDocument();
        }
        return new SingleObjectIterator(branch);
    }

    public final Object getParentNode(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            Node node2 = node.getParent();
            if (node2 == null && (node2 = node.getDocument()) == null) {
                node2 = node;
            }
            return node2;
        }
        return null;
    }

    public final String getProcessingInstructionData(Object object) {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
        return processingInstruction.getText();
    }

    public final String getProcessingInstructionTarget(Object object) {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)object;
        return processingInstruction.getTarget();
    }

    public final SAXReader getSAXReader() {
        if (this.reader == null) {
            this.reader = new SAXReader();
        }
        return this.reader;
    }

    public final String getTextStringValue(Object object) {
        return this.getNodeStringValue((Node)object);
    }

    public final boolean isAttribute(Object object) {
        return object instanceof Attribute;
    }

    public final boolean isComment(Object object) {
        return object instanceof Comment;
    }

    public final boolean isDocument(Object object) {
        return object instanceof Document;
    }

    public final boolean isElement(Object object) {
        return object instanceof Element;
    }

    public final boolean isNamespace(Object object) {
        return object instanceof Namespace;
    }

    public final boolean isProcessingInstruction(Object object) {
        return object instanceof ProcessingInstruction;
    }

    public final boolean isText(Object object) {
        return object instanceof Text || object instanceof CDATA;
    }

    public final XPath parseXPath(String string) {
        return new Dom4jXPath(string);
    }

    public final void setSAXReader(SAXReader sAXReader) {
        this.reader = sAXReader;
    }

    public final String translateNamespacePrefixToUri(String string, Object object) {
        Node node;
        Element element = null;
        if (object instanceof Element) {
            element = (Element)object;
        } else if (object instanceof Node) {
            node = (Node)object;
            element = node.getParent();
        }
        if (element != null && (node = element.getNamespaceForPrefix(string)) != null) {
            return ((Namespace)node).getURI();
        }
        return null;
    }
}

