/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.pattern;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.JaxenException;
import org.jaxen.Navigator;
import org.jaxen.expr.FilterExpr;
import org.jaxen.pattern.AnyNodeTest;
import org.jaxen.pattern.NodeTest;
import org.jaxen.pattern.Pattern;

public class LocationPathPattern
extends Pattern {
    private NodeTest nodeTest = AnyNodeTest.getInstance();
    private Pattern parentPattern;
    private Pattern ancestorPattern;
    private List filters;
    private boolean absolute;

    public LocationPathPattern() {
    }

    public LocationPathPattern(NodeTest nodeTest) {
        this.nodeTest = nodeTest;
    }

    public final void addFilter(FilterExpr filterExpr) {
        if (this.filters == null) {
            this.filters = new ArrayList();
        }
        this.filters.add(filterExpr);
    }

    public final short getMatchType() {
        return this.nodeTest.getMatchType();
    }

    public final double getPriority() {
        if (this.filters != null) {
            return 0.5;
        }
        return this.nodeTest.getPriority();
    }

    public final String getText() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.absolute) {
            stringBuffer.append("/");
        }
        if (this.ancestorPattern != null && ((String)(object = this.ancestorPattern.getText())).length() > 0) {
            stringBuffer.append((String)object);
            stringBuffer.append("//");
        }
        if (this.parentPattern != null && ((String)(object = this.parentPattern.getText())).length() > 0) {
            stringBuffer.append((String)object);
            stringBuffer.append("/");
        }
        stringBuffer.append(this.nodeTest.getText());
        if (this.filters != null) {
            stringBuffer.append("[");
            object = this.filters.iterator();
            while (object.hasNext()) {
                FilterExpr filterExpr = (FilterExpr)object.next();
                stringBuffer.append(filterExpr.getText());
            }
            stringBuffer.append("]");
        }
        return stringBuffer.toString();
    }

    public final boolean hasAnyNodeTest() {
        return this.nodeTest instanceof AnyNodeTest;
    }

    public final boolean isAbsolute() {
        return this.absolute;
    }

    public final boolean matches(Object object, Context context) {
        ArrayList<Object> arrayList;
        Navigator navigator = context.getNavigator();
        if (!this.nodeTest.matches(object, context)) {
            return false;
        }
        if (this.parentPattern != null) {
            arrayList = navigator.getParentNode(object);
            if (arrayList == null) {
                return false;
            }
            if (!this.parentPattern.matches(arrayList, context)) {
                return false;
            }
        }
        if (this.ancestorPattern != null) {
            arrayList = navigator.getParentNode(object);
            while (!this.ancestorPattern.matches(arrayList, context)) {
                if (arrayList == null) {
                    return false;
                }
                if (navigator.isDocument(arrayList)) {
                    return false;
                }
                arrayList = navigator.getParentNode(arrayList);
            }
        }
        if (this.filters != null) {
            arrayList = new ArrayList<Object>(1);
            arrayList.add(object);
            context.setNodeSet(arrayList);
            boolean bl = true;
            Iterator iterator = this.filters.iterator();
            while (iterator.hasNext()) {
                FilterExpr filterExpr = (FilterExpr)iterator.next();
                if (filterExpr.asBoolean(context)) continue;
                bl = false;
                break;
            }
            context.setNodeSet(arrayList);
            return bl;
        }
        return true;
    }

    public final void setAbsolute(boolean bl) {
        this.absolute = bl;
    }

    public final void setAncestorPattern(Pattern pattern) {
        this.ancestorPattern = pattern;
    }

    public final void setNodeTest(NodeTest nodeTest) {
        if (!(this.nodeTest instanceof AnyNodeTest)) {
            throw new JaxenException("Attempt to overwrite nodeTest: " + this.nodeTest + " with: " + nodeTest);
        }
        this.nodeTest = nodeTest;
    }

    public final void setParentPattern(Pattern pattern) {
        this.parentPattern = pattern;
    }

    public final Pattern simplify() {
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.simplify();
        }
        if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.simplify();
        }
        if (this.filters == null) {
            if (this.parentPattern == null && this.ancestorPattern == null) {
                return this.nodeTest;
            }
            if (this.parentPattern != null && this.ancestorPattern == null && this.nodeTest instanceof AnyNodeTest) {
                return this.parentPattern;
            }
        }
        return this;
    }

    public final String toString() {
        return String.valueOf(super.toString()) + "[ absolute: " + this.absolute + " parent: " + this.parentPattern + " ancestor: " + this.ancestorPattern + " filters: " + this.filters + " nodeTest: " + this.nodeTest + " ]";
    }
}

