/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.pattern;

import org.jaxen.Context;
import org.jaxen.Navigator;
import org.jaxen.pattern.NodeTest;

public class NamespaceTest
extends NodeTest {
    private String prefix;
    private short nodeType;

    public NamespaceTest(String string, short s) {
        if (string == null) {
            string = "";
        }
        this.prefix = string;
        this.nodeType = s;
    }

    public final short getMatchType() {
        return this.nodeType;
    }

    public final double getPriority() {
        return -0.25;
    }

    public final String getText() {
        return String.valueOf(this.prefix) + ":";
    }

    protected final String getURI(Object object, Context context) {
        String string = context.getNavigator().translateNamespacePrefixToUri(this.prefix, object);
        if (string == null) {
            string = context.getContextSupport().translateNamespacePrefixToUri(this.prefix);
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    public final boolean matches(Object object, Context context) {
        Navigator navigator = context.getNavigator();
        String string = this.getURI(object, context);
        if (this.nodeType == 1) {
            return navigator.isElement(object) && string.equals(navigator.getElementNamespaceUri(object));
        }
        if (this.nodeType == 2) {
            return navigator.isAttribute(object) && string.equals(navigator.getAttributeNamespaceUri(object));
        }
        return false;
    }

    public final String toString() {
        return String.valueOf(super.toString()) + "[ prefix: " + this.prefix + " type: " + this.nodeType + " ]";
    }
}

