/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jaxen.Navigator;

public abstract class StackedIterator
implements Iterator {
    private Object contextNode;
    private LinkedList iteratorStack = new LinkedList();
    private Navigator navigator;
    private Set created = new HashSet();

    protected StackedIterator() {
    }

    public StackedIterator(Object object, Navigator navigator) {
        this.init(object, navigator);
    }

    protected abstract Iterator createIterator(Object var1);

    private Iterator currentIterator() {
        while (this.iteratorStack.size() > 0) {
            Iterator iterator = (Iterator)this.iteratorStack.getFirst();
            if (iterator.hasNext()) {
                return iterator;
            }
            this.iteratorStack.removeFirst();
        }
        return null;
    }

    protected final Navigator getNavigator() {
        return this.navigator;
    }

    public final boolean hasNext() {
        Iterator iterator = this.currentIterator();
        if (iterator == null) {
            return false;
        }
        return iterator.hasNext();
    }

    protected final void init(Object object, Navigator navigator) {
        this.contextNode = object;
        this.navigator = navigator;
        this.pushIterator(this.internalCreateIterator(object));
    }

    private Iterator internalCreateIterator(Object object) {
        if (this.created.contains(object)) {
            return null;
        }
        this.created.add(object);
        return this.createIterator(object);
    }

    public final Object next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Iterator iterator = this.currentIterator();
        Object e2 = iterator.next();
        this.pushIterator(this.internalCreateIterator(e2));
        return e2;
    }

    protected final void pushIterator(Iterator iterator) {
        if (iterator != null) {
            this.iteratorStack.addLast(iterator);
        }
    }

    public final void remove() {
        throw new UnsupportedOperationException();
    }
}

