/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.log;

import org.jfree.base.log.LogConfiguration;
import org.jfree.util.Log;
import org.jfree.util.LogTarget;
import org.jfree.util.PrintStreamLogTarget;

public class DefaultLog
extends Log {
    private static final PrintStreamLogTarget DEFAULT_LOG_TARGET = new PrintStreamLogTarget();
    private static final DefaultLog defaultLogInstance = new DefaultLog();

    static {
        defaultLogInstance.addTarget(DEFAULT_LOG_TARGET);
        try {
            String string = System.getProperty("org.jfree.DebugDefault", "false");
            if (Boolean.valueOf(string).booleanValue()) {
                defaultLogInstance.setDebuglevel(3);
            } else {
                defaultLogInstance.setDebuglevel(1);
            }
        }
        catch (SecurityException securityException) {
            defaultLogInstance.setDebuglevel(1);
        }
    }

    protected DefaultLog() {
    }

    public final synchronized void addTarget(LogTarget logTarget) {
        super.addTarget(logTarget);
        if (logTarget != DEFAULT_LOG_TARGET) {
            this.removeTarget(DEFAULT_LOG_TARGET);
        }
    }

    public static final DefaultLog getDefaultLog() {
        return defaultLogInstance;
    }

    public final void init() {
        this.removeTarget(DEFAULT_LOG_TARGET);
        String string = LogConfiguration.getLogLevel();
        if (string.equalsIgnoreCase("error")) {
            this.setDebuglevel(0);
        } else if (string.equalsIgnoreCase("warn")) {
            this.setDebuglevel(1);
        } else if (string.equalsIgnoreCase("info")) {
            this.setDebuglevel(2);
        } else if (string.equalsIgnoreCase("debug")) {
            this.setDebuglevel(3);
        }
    }

    public static final void installDefaultLog() {
        Log.defineLog(defaultLogInstance);
    }
}

