/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.CategoryMarker;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectList;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.SortOrder;

public class CategoryPlot
extends Plot
implements ValueAxisPlot,
Zoomable,
RendererChangeListener,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3537691700434728188L;
    public static final boolean DEFAULT_DOMAIN_GRIDLINES_VISIBLE = false;
    public static final boolean DEFAULT_RANGE_GRIDLINES_VISIBLE = true;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private PlotOrientation orientation;
    private RectangleInsets axisOffset;
    private ObjectList domainAxes;
    private ObjectList domainAxisLocations;
    private boolean drawSharedDomainAxis;
    private ObjectList rangeAxes;
    private ObjectList rangeAxisLocations;
    private ObjectList datasets;
    private ObjectList datasetToDomainAxisMap;
    private ObjectList datasetToRangeAxisMap;
    private ObjectList renderers;
    private DatasetRenderingOrder renderingOrder = DatasetRenderingOrder.REVERSE;
    private SortOrder columnRenderingOrder = SortOrder.ASCENDING;
    private SortOrder rowRenderingOrder = SortOrder.ASCENDING;
    private boolean domainGridlinesVisible;
    private CategoryAnchor domainGridlinePosition;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private double anchorValue;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private Map foregroundDomainMarkers;
    private Map backgroundDomainMarkers;
    private Map foregroundRangeMarkers;
    private Map backgroundRangeMarkers;
    private List annotations;
    private int weight;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private LegendItemCollection fixedLegendItems;

    public CategoryPlot() {
        this(null, null, null, null);
    }

    public CategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.domainAxes = new ObjectList();
        this.domainAxisLocations = new ObjectList();
        this.rangeAxes = new ObjectList();
        this.rangeAxisLocations = new ObjectList();
        this.datasetToDomainAxisMap = new ObjectList();
        this.datasetToRangeAxisMap = new ObjectList();
        this.renderers = new ObjectList();
        this.datasets = new ObjectList();
        this.datasets.set(0, categoryDataset);
        if (categoryDataset != null) {
            categoryDataset.addChangeListener(this);
        }
        this.axisOffset = RectangleInsets.ZERO_INSETS;
        this.setDomainAxisLocation(AxisLocation.BOTTOM_OR_LEFT, false);
        this.setRangeAxisLocation(AxisLocation.TOP_OR_LEFT, false);
        this.renderers.set(0, categoryItemRenderer);
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
            categoryItemRenderer.addChangeListener(this);
        }
        this.domainAxes.set(0, categoryAxis);
        this.mapDatasetToDomainAxis(0, 0);
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
            categoryAxis.addChangeListener(this);
        }
        this.drawSharedDomainAxis = false;
        this.rangeAxes.set(0, valueAxis);
        this.mapDatasetToRangeAxis(0, 0);
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        this.domainGridlinesVisible = false;
        this.domainGridlinePosition = CategoryAnchor.MIDDLE;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.foregroundDomainMarkers = new HashMap();
        this.backgroundDomainMarkers = new HashMap();
        this.foregroundRangeMarkers = new HashMap();
        this.backgroundRangeMarkers = new HashMap();
        ValueMarker valueMarker = new ValueMarker(0.0, new Color(0.8f, 0.8f, 0.8f, 0.5f), new BasicStroke(1.0f), new Color(0.85f, 0.85f, 0.95f, 0.5f), new BasicStroke(1.0f), 0.6f);
        this.addRangeMarker(valueMarker, Layer.BACKGROUND);
        this.anchorValue = 0.0;
        this.annotations = new ArrayList();
    }

    public String getPlotType() {
        return localizationResources.getString("Category_Plot");
    }

    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        this.orientation = plotOrientation;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets rectangleInsets) {
        if (rectangleInsets == null) {
            throw new IllegalArgumentException("Null 'offset' argument.");
        }
        this.axisOffset = rectangleInsets;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public CategoryAxis getDomainAxis() {
        return this.getDomainAxis(0);
    }

    public CategoryAxis getDomainAxis(int n) {
        Plot plot;
        CategoryAxis categoryAxis = null;
        if (n < this.domainAxes.size()) {
            categoryAxis = (CategoryAxis)this.domainAxes.get(n);
        }
        if (categoryAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            categoryAxis = categoryPlot.getDomainAxis(n);
        }
        return categoryAxis;
    }

    public void setDomainAxis(CategoryAxis categoryAxis) {
        this.setDomainAxis(0, categoryAxis);
    }

    public void setDomainAxis(int n, CategoryAxis categoryAxis) {
        this.setDomainAxis(n, categoryAxis, true);
    }

    public void setDomainAxis(int n, CategoryAxis categoryAxis, boolean bl) {
        CategoryAxis categoryAxis2 = (CategoryAxis)this.domainAxes.get(n);
        if (categoryAxis2 != null) {
            categoryAxis2.removeChangeListener(this);
        }
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
        }
        this.domainAxes.set(n, categoryAxis);
        if (categoryAxis != null) {
            categoryAxis.configure();
            categoryAxis.addChangeListener(this);
        }
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setDomainAxes(CategoryAxis[] categoryAxisArray) {
        for (int i2 = 0; i2 < categoryAxisArray.length; ++i2) {
            this.setDomainAxis(i2, categoryAxisArray[i2], false);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getDomainAxisLocation() {
        return this.getDomainAxisLocation(0);
    }

    public AxisLocation getDomainAxisLocation(int n) {
        AxisLocation axisLocation = null;
        if (n < this.domainAxisLocations.size()) {
            axisLocation = (AxisLocation)this.domainAxisLocations.get(n);
        }
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getDomainAxisLocation(0));
        }
        return axisLocation;
    }

    public void setDomainAxisLocation(AxisLocation axisLocation) {
        this.setDomainAxisLocation(axisLocation, true);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation, boolean bl) {
        if (axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        this.setDomainAxisLocation(0, axisLocation);
    }

    public void setDomainAxisLocation(int n, AxisLocation axisLocation) {
        this.domainAxisLocations.set(n, axisLocation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public RectangleEdge getDomainAxisEdge() {
        return this.getDomainAxisEdge(0);
    }

    public RectangleEdge getDomainAxisEdge(int n) {
        RectangleEdge rectangleEdge = null;
        AxisLocation axisLocation = this.getDomainAxisLocation(n);
        rectangleEdge = axisLocation != null ? Plot.resolveDomainAxisLocation(axisLocation, this.orientation) : RectangleEdge.opposite(this.getDomainAxisEdge(0));
        return rectangleEdge;
    }

    public int getDomainAxisCount() {
        return this.domainAxes.size();
    }

    public void clearDomainAxes() {
        for (int i2 = 0; i2 < this.domainAxes.size(); ++i2) {
            CategoryAxis categoryAxis = (CategoryAxis)this.domainAxes.get(i2);
            if (categoryAxis == null) continue;
            categoryAxis.removeChangeListener(this);
        }
        this.domainAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureDomainAxes() {
        for (int i2 = 0; i2 < this.domainAxes.size(); ++i2) {
            CategoryAxis categoryAxis = (CategoryAxis)this.domainAxes.get(i2);
            if (categoryAxis == null) continue;
            categoryAxis.configure();
        }
    }

    public ValueAxis getRangeAxis() {
        return this.getRangeAxis(0);
    }

    public ValueAxis getRangeAxis(int n) {
        Plot plot;
        ValueAxis valueAxis = null;
        if (n < this.rangeAxes.size()) {
            valueAxis = (ValueAxis)this.rangeAxes.get(n);
        }
        if (valueAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            valueAxis = categoryPlot.getRangeAxis(n);
        }
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        this.setRangeAxis(0, valueAxis);
    }

    public void setRangeAxis(int n, ValueAxis valueAxis) {
        this.setRangeAxis(n, valueAxis, true);
    }

    public void setRangeAxis(int n, ValueAxis valueAxis, boolean bl) {
        ValueAxis valueAxis2 = (ValueAxis)this.rangeAxes.get(n);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.rangeAxes.set(n, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setRangeAxes(ValueAxis[] valueAxisArray) {
        for (int i2 = 0; i2 < valueAxisArray.length; ++i2) {
            this.setRangeAxis(i2, valueAxisArray[i2], false);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public AxisLocation getRangeAxisLocation() {
        return this.getRangeAxisLocation(0);
    }

    public AxisLocation getRangeAxisLocation(int n) {
        AxisLocation axisLocation = null;
        if (n < this.rangeAxisLocations.size()) {
            axisLocation = (AxisLocation)this.rangeAxisLocations.get(n);
        }
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getRangeAxisLocation(0));
        }
        return axisLocation;
    }

    public void setRangeAxisLocation(AxisLocation axisLocation) {
        this.setRangeAxisLocation(axisLocation, true);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation, boolean bl) {
        this.setRangeAxisLocation(0, axisLocation, bl);
    }

    public void setRangeAxisLocation(int n, AxisLocation axisLocation) {
        this.setRangeAxisLocation(n, axisLocation, true);
    }

    public void setRangeAxisLocation(int n, AxisLocation axisLocation, boolean bl) {
        this.rangeAxisLocations.set(n, axisLocation);
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public RectangleEdge getRangeAxisEdge() {
        return this.getRangeAxisEdge(0);
    }

    public RectangleEdge getRangeAxisEdge(int n) {
        AxisLocation axisLocation = this.getRangeAxisLocation(n);
        RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(axisLocation, this.orientation);
        if (rectangleEdge == null) {
            rectangleEdge = RectangleEdge.opposite(this.getRangeAxisEdge(0));
        }
        return rectangleEdge;
    }

    public int getRangeAxisCount() {
        return this.rangeAxes.size();
    }

    public void clearRangeAxes() {
        for (int i2 = 0; i2 < this.rangeAxes.size(); ++i2) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i2);
            if (valueAxis == null) continue;
            valueAxis.removeChangeListener(this);
        }
        this.rangeAxes.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void configureRangeAxes() {
        for (int i2 = 0; i2 < this.rangeAxes.size(); ++i2) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i2);
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
    }

    public CategoryDataset getDataset() {
        return this.getDataset(0);
    }

    public CategoryDataset getDataset(int n) {
        CategoryDataset categoryDataset = null;
        if (this.datasets.size() > n) {
            categoryDataset = (CategoryDataset)this.datasets.get(n);
        }
        return categoryDataset;
    }

    public void setDataset(CategoryDataset categoryDataset) {
        this.setDataset(0, categoryDataset);
    }

    public void setDataset(int n, CategoryDataset categoryDataset) {
        CategoryDataset categoryDataset2 = (CategoryDataset)this.datasets.get(n);
        if (categoryDataset2 != null) {
            categoryDataset2.removeChangeListener(this);
        }
        this.datasets.set(n, categoryDataset);
        if (categoryDataset != null) {
            categoryDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, categoryDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public void mapDatasetToDomainAxis(int n, int n2) {
        this.datasetToDomainAxisMap.set(n, new Integer(n2));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n)));
    }

    public CategoryAxis getDomainAxisForDataset(int n) {
        CategoryAxis categoryAxis = this.getDomainAxis();
        Integer n2 = (Integer)this.datasetToDomainAxisMap.get(n);
        if (n2 != null) {
            categoryAxis = this.getDomainAxis(n2);
        }
        return categoryAxis;
    }

    public void mapDatasetToRangeAxis(int n, int n2) {
        this.datasetToRangeAxisMap.set(n, new Integer(n2));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n)));
    }

    public ValueAxis getRangeAxisForDataset(int n) {
        ValueAxis valueAxis = this.getRangeAxis();
        Integer n2 = (Integer)this.datasetToRangeAxisMap.get(n);
        if (n2 != null) {
            valueAxis = this.getRangeAxis(n2);
        }
        return valueAxis;
    }

    public CategoryItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public CategoryItemRenderer getRenderer(int n) {
        CategoryItemRenderer categoryItemRenderer = null;
        if (this.renderers.size() > n) {
            categoryItemRenderer = (CategoryItemRenderer)this.renderers.get(n);
        }
        return categoryItemRenderer;
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer) {
        this.setRenderer(0, categoryItemRenderer, true);
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer, boolean bl) {
        this.setRenderer(0, categoryItemRenderer, bl);
    }

    public void setRenderer(int n, CategoryItemRenderer categoryItemRenderer) {
        this.setRenderer(n, categoryItemRenderer, true);
    }

    public void setRenderer(int n, CategoryItemRenderer categoryItemRenderer, boolean bl) {
        CategoryItemRenderer categoryItemRenderer2 = (CategoryItemRenderer)this.renderers.get(n);
        if (categoryItemRenderer2 != null) {
            categoryItemRenderer2.removeChangeListener(this);
        }
        this.renderers.set(n, categoryItemRenderer);
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
            categoryItemRenderer.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setRenderers(CategoryItemRenderer[] categoryItemRendererArray) {
        for (int i2 = 0; i2 < categoryItemRendererArray.length; ++i2) {
            this.setRenderer(i2, categoryItemRendererArray[i2], false);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public CategoryItemRenderer getRendererForDataset(CategoryDataset categoryDataset) {
        CategoryItemRenderer categoryItemRenderer = null;
        for (int i2 = 0; i2 < this.datasets.size(); ++i2) {
            if (this.datasets.get(i2) != categoryDataset) continue;
            categoryItemRenderer = (CategoryItemRenderer)this.renderers.get(i2);
            break;
        }
        return categoryItemRenderer;
    }

    public int getIndexOf(CategoryItemRenderer categoryItemRenderer) {
        return this.renderers.indexOf(categoryItemRenderer);
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.renderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder datasetRenderingOrder) {
        if (datasetRenderingOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.renderingOrder = datasetRenderingOrder;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public SortOrder getColumnRenderingOrder() {
        return this.columnRenderingOrder;
    }

    public void setColumnRenderingOrder(SortOrder sortOrder) {
        this.columnRenderingOrder = sortOrder;
    }

    public SortOrder getRowRenderingOrder() {
        return this.rowRenderingOrder;
    }

    public void setRowRenderingOrder(SortOrder sortOrder) {
        if (sortOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument.");
        }
        this.rowRenderingOrder = sortOrder;
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl) {
        if (this.domainGridlinesVisible != bl) {
            this.domainGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public CategoryAnchor getDomainGridlinePosition() {
        return this.domainGridlinePosition;
    }

    public void setDomainGridlinePosition(CategoryAnchor categoryAnchor) {
        if (categoryAnchor == null) {
            throw new IllegalArgumentException("Null 'position' argument.");
        }
        this.domainGridlinePosition = categoryAnchor;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' not permitted.");
        }
        this.domainGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.domainGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl) {
        if (this.rangeGridlinesVisible != bl) {
            this.rangeGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.rangeGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection legendItemCollection) {
        this.fixedLegendItems = legendItemCollection;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = this.fixedLegendItems;
        if (legendItemCollection == null) {
            legendItemCollection = new LegendItemCollection();
            int n = this.datasets.size();
            for (int i2 = 0; i2 < n; ++i2) {
                CategoryItemRenderer categoryItemRenderer;
                CategoryDataset categoryDataset = this.getDataset(i2);
                if (categoryDataset == null || (categoryItemRenderer = this.getRenderer(i2)) == null) continue;
                int n2 = categoryDataset.getRowCount();
                for (int i3 = 0; i3 < n2; ++i3) {
                    LegendItem legendItem = categoryItemRenderer.getLegendItem(i2, i3);
                    if (legendItem == null) continue;
                    legendItemCollection.add(legendItem);
                }
            }
        }
        return legendItemCollection;
    }

    public void handleClick(int n, int n2, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n, n2)) {
            double d2 = 0.0;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                d2 = n;
            } else if (this.orientation == PlotOrientation.VERTICAL) {
                d2 = n2;
            }
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
            double d3 = this.getRangeAxis().java2DToValue(d2, plotRenderingInfo.getDataArea(), rectangleEdge);
            this.setAnchorValue(d3);
            this.setRangeCrosshairValue(d3);
        }
    }

    public void zoom(double d2) {
        if (d2 > 0.0) {
            double d3 = this.getRangeAxis().getRange().getLength();
            double d4 = d3 * d2;
            this.getRangeAxis().setRange(this.anchorValue - d4 / 2.0, this.anchorValue + d4 / 2.0);
        } else {
            this.getRangeAxis().setAutoRange(true);
        }
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        int n = this.rangeAxes.size();
        for (int i2 = 0; i2 < n; ++i2) {
            ValueAxis valueAxis = this.getRangeAxis(i2);
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            plotChangeEvent.setType(ChartChangeEventType.DATASET_UPDATED);
            this.notifyListeners(plotChangeEvent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rendererChanged(RendererChangeEvent rendererChangeEvent) {
        Plot plot = this.getParent();
        if (plot != null) {
            if (!(plot instanceof RendererChangeListener)) throw new RuntimeException("The renderer has changed and I don't know what to do!");
            RendererChangeListener rendererChangeListener = (RendererChangeListener)((Object)plot);
            rendererChangeListener.rendererChanged(rendererChangeEvent);
            return;
        } else {
            this.configureRangeAxes();
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public void addDomainMarker(CategoryMarker categoryMarker) {
        this.addDomainMarker(categoryMarker, Layer.FOREGROUND);
    }

    public void addDomainMarker(CategoryMarker categoryMarker, Layer layer) {
        this.addDomainMarker(0, categoryMarker, layer);
    }

    public void addDomainMarker(int n, CategoryMarker categoryMarker, Layer layer) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<CategoryMarker> arrayList = (ArrayList<CategoryMarker>)this.foregroundDomainMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<CategoryMarker>();
                this.foregroundDomainMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(categoryMarker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<CategoryMarker> arrayList = (ArrayList<CategoryMarker>)this.backgroundDomainMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<CategoryMarker>();
                this.backgroundDomainMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(categoryMarker);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearDomainMarkers() {
        if (this.backgroundDomainMarkers != null) {
            this.backgroundDomainMarkers.clear();
        }
        if (this.foregroundDomainMarkers != null) {
            this.foregroundDomainMarkers.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Collection getDomainMarkers(Layer layer) {
        return this.getDomainMarkers(0, layer);
    }

    public Collection getDomainMarkers(int n, Layer layer) {
        Collection collection = null;
        Integer n2 = new Integer(n);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundDomainMarkers.get(n2);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundDomainMarkers.get(n2);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public void clearDomainMarkers(int n) {
        Collection collection;
        Integer n2 = new Integer(n);
        if (this.backgroundDomainMarkers != null && (collection = (Collection)this.backgroundDomainMarkers.get(n2)) != null) {
            collection.clear();
        }
        if (this.foregroundDomainMarkers != null && (collection = (Collection)this.foregroundDomainMarkers.get(n2)) != null) {
            collection.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        this.addRangeMarker(0, marker, layer);
    }

    public void addRangeMarker(int n, Marker marker, Layer layer) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.foregroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.foregroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.backgroundRangeMarkers.get(new Integer(n));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.backgroundRangeMarkers.put(new Integer(n), arrayList);
            }
            arrayList.add(marker);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearRangeMarkers() {
        if (this.backgroundRangeMarkers != null) {
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            this.foregroundRangeMarkers.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Collection getRangeMarkers(Layer layer) {
        return this.getRangeMarkers(0, layer);
    }

    public Collection getRangeMarkers(int n, Layer layer) {
        Collection collection = null;
        Integer n2 = new Integer(n);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundRangeMarkers.get(n2);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundRangeMarkers.get(n2);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public void clearRangeMarkers(int n) {
        Collection collection;
        Integer n2 = new Integer(n);
        if (this.backgroundRangeMarkers != null && (collection = (Collection)this.backgroundRangeMarkers.get(n2)) != null) {
            collection.clear();
        }
        if (this.foregroundRangeMarkers != null && (collection = (Collection)this.foregroundRangeMarkers.get(n2)) != null) {
            collection.clear();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl) {
        if (this.rangeCrosshairVisible != bl) {
            this.rangeCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl) {
        if (this.rangeCrosshairLockedOnData != bl) {
            this.rangeCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d2) {
        this.setRangeCrosshairValue(d2, true);
    }

    public void setRangeCrosshairValue(double d2, boolean bl) {
        this.rangeCrosshairValue = d2;
        if (this.isRangeCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        this.rangeCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        this.rangeCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(CategoryAnnotation categoryAnnotation) {
        if (categoryAnnotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        this.annotations.add(categoryAnnotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean removeAnnotation(CategoryAnnotation categoryAnnotation) {
        if (categoryAnnotation == null) {
            throw new IllegalArgumentException("Null 'annotation' argument.");
        }
        boolean bl = this.annotations.remove(categoryAnnotation);
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
        return bl;
    }

    public void clearAnnotations() {
        this.annotations.clear();
        this.notifyListeners(new PlotChangeEvent(this));
    }

    protected AxisSpace calculateDomainAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block5: {
            block3: {
                block4: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block3;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block4;
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block5;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block5;
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block5;
            }
            RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
            if (this.drawSharedDomainAxis) {
                axisSpace = this.getDomainAxis().reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
            for (int i2 = 0; i2 < this.domainAxes.size(); ++i2) {
                Axis axis = (Axis)this.domainAxes.get(i2);
                if (axis == null) continue;
                RectangleEdge rectangleEdge2 = this.getDomainAxisEdge(i2);
                axisSpace = axis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge2, axisSpace);
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateRangeAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block4: {
            block2: {
                block3: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block2;
                    if (this.orientation != PlotOrientation.HORIZONTAL) break block3;
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block4;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block4;
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block4;
            }
            for (int i2 = 0; i2 < this.rangeAxes.size(); ++i2) {
                Axis axis = (Axis)this.rangeAxes.get(i2);
                if (axis == null) continue;
                RectangleEdge rectangleEdge = this.getRangeAxisEdge(i2);
                axisSpace = axis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.calculateRangeAxisSpace(graphics2D, rectangle2D, axisSpace);
        axisSpace = this.calculateDomainAxisSpace(graphics2D, rectangle2D, axisSpace);
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        int n;
        int n2;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (plotRenderingInfo == null) {
            plotRenderingInfo = new PlotRenderingInfo(null);
        }
        plotRenderingInfo.setPlotArea(rectangle2D);
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.axisOffset.trim(rectangle2D2);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        if (this.getRenderer() != null) {
            this.getRenderer().drawBackground(graphics2D, this, rectangle2D2);
        } else {
            this.drawBackground(graphics2D, rectangle2D2);
        }
        Map map = this.drawAxes(graphics2D, rectangle2D, rectangle2D2, plotRenderingInfo);
        this.drawDomainGridlines(graphics2D, rectangle2D2);
        AxisState axisState = (AxisState)map.get(this.getRangeAxis());
        if (axisState == null && plotState != null) {
            axisState = (AxisState)plotState.getSharedAxisStates().get(this.getRangeAxis());
        }
        if (axisState != null) {
            this.drawRangeGridlines(graphics2D, rectangle2D2, axisState.getTicks());
        }
        for (n2 = 0; n2 < this.renderers.size(); ++n2) {
            this.drawDomainMarkers(graphics2D, rectangle2D2, n2, Layer.BACKGROUND);
        }
        for (n2 = 0; n2 < this.renderers.size(); ++n2) {
            this.drawRangeMarkers(graphics2D, rectangle2D2, n2, Layer.BACKGROUND);
        }
        n2 = 0;
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D2);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        DatasetRenderingOrder datasetRenderingOrder = this.getDatasetRenderingOrder();
        if (datasetRenderingOrder == DatasetRenderingOrder.FORWARD) {
            for (n = 0; n < this.datasets.size(); ++n) {
                n2 = this.render(graphics2D, rectangle2D2, n, plotRenderingInfo) || n2 != 0 ? 1 : 0;
            }
        } else {
            for (n = this.datasets.size() - 1; n >= 0; --n) {
                n2 = this.render(graphics2D, rectangle2D2, n, plotRenderingInfo) || n2 != 0 ? 1 : 0;
            }
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        if (n2 == 0) {
            this.drawNoDataMessage(graphics2D, rectangle2D2);
        }
        if (this.isRangeCrosshairVisible()) {
            this.drawRangeLine(graphics2D, rectangle2D2, this.getRangeCrosshairValue(), this.getRangeCrosshairStroke(), this.getRangeCrosshairPaint());
        }
        for (n = 0; n < this.renderers.size(); ++n) {
            this.drawDomainMarkers(graphics2D, rectangle2D2, n, Layer.FOREGROUND);
        }
        for (n = 0; n < this.renderers.size(); ++n) {
            this.drawRangeMarkers(graphics2D, rectangle2D2, n, Layer.FOREGROUND);
        }
        this.drawAnnotations(graphics2D, rectangle2D2);
        if (this.getRenderer() != null) {
            this.getRenderer().drawOutline(graphics2D, this, rectangle2D2);
        } else {
            this.drawOutline(graphics2D, rectangle2D2);
        }
    }

    protected Map drawAxes(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState;
        Axis axis;
        Axis axis2;
        int n;
        AxisCollection axisCollection = new AxisCollection();
        for (n = 0; n < this.domainAxes.size(); ++n) {
            axis2 = (CategoryAxis)this.domainAxes.get(n);
            if (axis2 == null) continue;
            axisCollection.add(axis2, this.getDomainAxisEdge(n));
        }
        for (n = 0; n < this.rangeAxes.size(); ++n) {
            axis2 = (ValueAxis)this.rangeAxes.get(n);
            if (axis2 == null) continue;
            axisCollection.add(axis2, this.getRangeAxisEdge(n));
        }
        HashMap<Axis, AxisState> hashMap = new HashMap<Axis, AxisState>();
        double d2 = rectangle2D2.getMinY() - this.axisOffset.calculateTopOutset(rectangle2D2.getHeight());
        Iterator iterator = axisCollection.getAxesAtTop().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.TOP, plotRenderingInfo);
            d2 = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        d2 = rectangle2D2.getMaxY() + this.axisOffset.calculateBottomOutset(rectangle2D2.getHeight());
        iterator = axisCollection.getAxesAtBottom().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.BOTTOM, plotRenderingInfo);
            d2 = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        d2 = rectangle2D2.getMinX() - this.axisOffset.calculateLeftOutset(rectangle2D2.getWidth());
        iterator = axisCollection.getAxesAtLeft().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.LEFT, plotRenderingInfo);
            d2 = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        d2 = rectangle2D2.getMaxX() + this.axisOffset.calculateRightOutset(rectangle2D2.getWidth());
        iterator = axisCollection.getAxesAtRight().iterator();
        while (iterator.hasNext()) {
            axis = (Axis)iterator.next();
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.RIGHT, plotRenderingInfo);
            d2 = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        return hashMap;
    }

    public boolean render(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, PlotRenderingInfo plotRenderingInfo) {
        boolean bl;
        boolean bl2 = false;
        CategoryDataset categoryDataset = this.getDataset(n);
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n);
        CategoryAxis categoryAxis = this.getDomainAxisForDataset(n);
        ValueAxis valueAxis = this.getRangeAxisForDataset(n);
        boolean bl3 = bl = !DatasetUtilities.isEmptyOrNull(categoryDataset);
        if (bl && categoryItemRenderer != null) {
            bl2 = true;
            CategoryItemRendererState categoryItemRendererState = categoryItemRenderer.initialise(graphics2D, rectangle2D, this, n, plotRenderingInfo);
            int n2 = categoryDataset.getColumnCount();
            int n3 = categoryDataset.getRowCount();
            int n4 = categoryItemRenderer.getPassCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                int n5;
                int n6;
                if (this.columnRenderingOrder == SortOrder.ASCENDING) {
                    for (n6 = 0; n6 < n2; ++n6) {
                        if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                            for (n5 = 0; n5 < n3; ++n5) {
                                categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n5, n6, i2);
                            }
                            continue;
                        }
                        for (n5 = n3 - 1; n5 >= 0; --n5) {
                            categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n5, n6, i2);
                        }
                    }
                    continue;
                }
                for (n6 = n2 - 1; n6 >= 0; --n6) {
                    if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                        for (n5 = 0; n5 < n3; ++n5) {
                            categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n5, n6, i2);
                        }
                        continue;
                    }
                    for (n5 = n3 - 1; n5 >= 0; --n5) {
                        categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n5, n6, i2);
                    }
                }
            }
        }
        return bl2;
    }

    protected void drawDomainGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.isDomainGridlinesVisible()) {
            CategoryAxis categoryAxis;
            CategoryDataset categoryDataset;
            CategoryAnchor categoryAnchor = this.getDomainGridlinePosition();
            RectangleEdge rectangleEdge = this.getDomainAxisEdge();
            Stroke stroke = this.getDomainGridlineStroke();
            Paint paint = this.getDomainGridlinePaint();
            if (stroke != null && paint != null && (categoryDataset = this.getDataset()) != null && (categoryAxis = this.getDomainAxis()) != null) {
                int n = categoryDataset.getColumnCount();
                for (int i2 = 0; i2 < n; ++i2) {
                    double d2 = categoryAxis.getCategoryJava2DCoordinate(categoryAnchor, i2, n, rectangle2D, rectangleEdge);
                    CategoryItemRenderer categoryItemRenderer = this.getRenderer();
                    if (categoryItemRenderer == null) continue;
                    categoryItemRenderer.drawDomainGridline(graphics2D, this, rectangle2D, d2);
                }
            }
        }
    }

    protected void drawRangeGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (this.isRangeGridlinesVisible()) {
            ValueAxis valueAxis;
            Stroke stroke = this.getRangeGridlineStroke();
            Paint paint = this.getRangeGridlinePaint();
            if (stroke != null && paint != null && (valueAxis = this.getRangeAxis()) != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ValueTick valueTick = (ValueTick)iterator.next();
                    CategoryItemRenderer categoryItemRenderer = this.getRenderer();
                    if (categoryItemRenderer == null) continue;
                    categoryItemRenderer.drawRangeGridline(graphics2D, this, this.getRangeAxis(), rectangle2D, valueTick.getValue());
                }
            }
        }
    }

    protected void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.getAnnotations() != null) {
            Iterator iterator = this.getAnnotations().iterator();
            while (iterator.hasNext()) {
                CategoryAnnotation categoryAnnotation = (CategoryAnnotation)iterator.next();
                categoryAnnotation.draw(graphics2D, this, rectangle2D, this.getDomainAxis(), this.getRangeAxis());
            }
        }
    }

    protected void drawDomainMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, Layer layer) {
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n);
        if (categoryItemRenderer == null) {
            return;
        }
        Collection collection = this.getDomainMarkers(n, layer);
        CategoryAxis categoryAxis = this.getDomainAxisForDataset(n);
        if (collection != null && categoryAxis != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                CategoryMarker categoryMarker = (CategoryMarker)iterator.next();
                categoryItemRenderer.drawDomainMarker(graphics2D, this, categoryAxis, categoryMarker, rectangle2D);
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n, Layer layer) {
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n);
        if (categoryItemRenderer == null) {
            return;
        }
        Collection collection = this.getRangeMarkers(n, layer);
        ValueAxis valueAxis = this.getRangeAxisForDataset(n);
        if (collection != null && valueAxis != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Marker marker = (Marker)iterator.next();
                categoryItemRenderer.drawRangeMarker(graphics2D, this, valueAxis, marker, rectangle2D);
            }
        }
    }

    protected void drawRangeLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d2, Stroke stroke, Paint paint) {
        double d3 = this.getRangeAxis().valueToJava2D(d2, rectangle2D, this.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
        } else if (this.orientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        ArrayList arrayList = new ArrayList();
        int n = this.rangeAxes.indexOf(valueAxis);
        if (n >= 0) {
            arrayList.addAll(this.datasetsMappedToRangeAxis(n));
        } else if (valueAxis == this.getRangeAxis()) {
            arrayList.addAll(this.datasetsMappedToRangeAxis(0));
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            CategoryDataset categoryDataset = (CategoryDataset)iterator.next();
            CategoryItemRenderer categoryItemRenderer = this.getRendererForDataset(categoryDataset);
            if (categoryItemRenderer == null) continue;
            range = Range.combine(range, categoryItemRenderer.findRangeBounds(categoryDataset));
        }
        return range;
    }

    private List datasetsMappedToRangeAxis(int n) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < this.datasets.size(); ++i2) {
            Object object = this.datasets.get(i2);
            if (object == null) continue;
            Integer n2 = (Integer)this.datasetToRangeAxisMap.get(i2);
            if (n2 == null) {
                if (n != 0) continue;
                arrayList.add(object);
                continue;
            }
            if (n2 != n) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace) {
        this.fixedDomainAxisSpace = axisSpace;
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace) {
        this.fixedRangeAxisSpace = axisSpace;
    }

    public List getCategories() {
        List list = null;
        if (this.getDataset() != null) {
            list = Collections.unmodifiableList(this.getDataset().getColumnKeys());
        }
        return list;
    }

    public boolean getDrawSharedDomainAxis() {
        return this.drawSharedDomainAxis;
    }

    public void setDrawSharedDomainAxis(boolean bl) {
        this.drawSharedDomainAxis = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isDomainZoomable() {
        return false;
    }

    public boolean isRangeZoomable() {
        return true;
    }

    public void zoomDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    public void zoomDomainAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        for (int i2 = 0; i2 < this.rangeAxes.size(); ++i2) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i2);
            if (valueAxis == null) continue;
            valueAxis.resizeRange(d2);
        }
    }

    public void zoomRangeAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        for (int i2 = 0; i2 < this.rangeAxes.size(); ++i2) {
            ValueAxis valueAxis = (ValueAxis)this.rangeAxes.get(i2);
            if (valueAxis == null) continue;
            valueAxis.zoomRange(d2, d3);
        }
    }

    public double getAnchorValue() {
        return this.anchorValue;
    }

    public void setAnchorValue(double d2) {
        this.setAnchorValue(d2, true);
    }

    public void setAnchorValue(double d2, boolean bl) {
        this.anchorValue = d2;
        if (bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CategoryPlot)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CategoryPlot categoryPlot = (CategoryPlot)object;
        if (this.orientation != categoryPlot.orientation) {
            return false;
        }
        if (!ObjectUtilities.equal(this.axisOffset, categoryPlot.axisOffset)) {
            return false;
        }
        if (!this.domainAxes.equals(categoryPlot.domainAxes)) {
            return false;
        }
        if (!this.domainAxisLocations.equals(categoryPlot.domainAxisLocations)) {
            return false;
        }
        if (this.drawSharedDomainAxis != categoryPlot.drawSharedDomainAxis) {
            return false;
        }
        if (!this.rangeAxes.equals(categoryPlot.rangeAxes)) {
            return false;
        }
        if (!this.rangeAxisLocations.equals(categoryPlot.rangeAxisLocations)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.datasetToDomainAxisMap, categoryPlot.datasetToDomainAxisMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.datasetToRangeAxisMap, categoryPlot.datasetToRangeAxisMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.renderers, categoryPlot.renderers)) {
            return false;
        }
        if (this.renderingOrder != categoryPlot.renderingOrder) {
            return false;
        }
        if (this.columnRenderingOrder != categoryPlot.columnRenderingOrder) {
            return false;
        }
        if (this.rowRenderingOrder != categoryPlot.rowRenderingOrder) {
            return false;
        }
        if (this.domainGridlinesVisible != categoryPlot.domainGridlinesVisible) {
            return false;
        }
        if (this.domainGridlinePosition != categoryPlot.domainGridlinePosition) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainGridlineStroke, categoryPlot.domainGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainGridlinePaint, categoryPlot.domainGridlinePaint)) {
            return false;
        }
        if (this.rangeGridlinesVisible != categoryPlot.rangeGridlinesVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeGridlineStroke, categoryPlot.rangeGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeGridlinePaint, categoryPlot.rangeGridlinePaint)) {
            return false;
        }
        if (this.anchorValue != categoryPlot.anchorValue) {
            return false;
        }
        if (this.rangeCrosshairVisible != categoryPlot.rangeCrosshairVisible) {
            return false;
        }
        if (this.rangeCrosshairValue != categoryPlot.rangeCrosshairValue) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeCrosshairStroke, categoryPlot.rangeCrosshairStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeCrosshairPaint, categoryPlot.rangeCrosshairPaint)) {
            return false;
        }
        if (this.rangeCrosshairLockedOnData != categoryPlot.rangeCrosshairLockedOnData) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundRangeMarkers, categoryPlot.foregroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundRangeMarkers, categoryPlot.backgroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.annotations, categoryPlot.annotations)) {
            return false;
        }
        if (this.weight != categoryPlot.weight) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fixedDomainAxisSpace, categoryPlot.fixedDomainAxisSpace)) {
            return false;
        }
        return ObjectUtilities.equal(this.fixedRangeAxisSpace, categoryPlot.fixedRangeAxisSpace);
    }

    public Object clone() {
        Axis axis;
        Object object;
        int n;
        CategoryPlot categoryPlot = (CategoryPlot)super.clone();
        categoryPlot.domainAxes = new ObjectList();
        for (n = 0; n < this.domainAxes.size(); ++n) {
            object = (CategoryAxis)this.domainAxes.get(n);
            if (object == null) continue;
            axis = (CategoryAxis)((CategoryAxis)object).clone();
            categoryPlot.setDomainAxis(n, (CategoryAxis)axis);
        }
        categoryPlot.domainAxisLocations = (ObjectList)this.domainAxisLocations.clone();
        categoryPlot.rangeAxes = new ObjectList();
        for (n = 0; n < this.rangeAxes.size(); ++n) {
            object = (ValueAxis)this.rangeAxes.get(n);
            if (object == null) continue;
            axis = (ValueAxis)((ValueAxis)object).clone();
            categoryPlot.setRangeAxis(n, (ValueAxis)axis);
        }
        categoryPlot.rangeAxisLocations = (ObjectList)this.rangeAxisLocations.clone();
        categoryPlot.datasets = (ObjectList)this.datasets.clone();
        for (n = 0; n < categoryPlot.datasets.size(); ++n) {
            object = categoryPlot.getDataset(n);
            if (object == null) continue;
            object.addChangeListener(categoryPlot);
        }
        categoryPlot.datasetToDomainAxisMap = (ObjectList)this.datasetToDomainAxisMap.clone();
        categoryPlot.datasetToRangeAxisMap = (ObjectList)this.datasetToRangeAxisMap.clone();
        categoryPlot.renderers = (ObjectList)this.renderers.clone();
        if (this.fixedDomainAxisSpace != null) {
            categoryPlot.fixedDomainAxisSpace = (AxisSpace)ObjectUtilities.clone(this.fixedDomainAxisSpace);
        }
        if (this.fixedRangeAxisSpace != null) {
            categoryPlot.fixedRangeAxisSpace = (AxisSpace)ObjectUtilities.clone(this.fixedRangeAxisSpace);
        }
        return categoryPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.domainGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeCrosshairStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeCrosshairPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        int n;
        Axis axis;
        int n2;
        objectInputStream.defaultReadObject();
        this.domainGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeCrosshairStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeCrosshairPaint = SerialUtilities.readPaint(objectInputStream);
        for (n2 = 0; n2 < this.domainAxes.size(); ++n2) {
            axis = (CategoryAxis)this.domainAxes.get(n2);
            if (axis == null) continue;
            axis.setPlot(this);
            axis.addChangeListener(this);
        }
        for (n2 = 0; n2 < this.rangeAxes.size(); ++n2) {
            axis = (ValueAxis)this.rangeAxes.get(n2);
            if (axis == null) continue;
            axis.setPlot(this);
            axis.addChangeListener(this);
        }
        n2 = this.datasets.size();
        for (n = 0; n < n2; ++n) {
            Dataset dataset = (Dataset)this.datasets.get(n);
            if (dataset == null) continue;
            dataset.addChangeListener(this);
        }
        n = this.renderers.size();
        for (int i2 = 0; i2 < n; ++i2) {
            CategoryItemRenderer categoryItemRenderer = (CategoryItemRenderer)this.renderers.get(i2);
            if (categoryItemRenderer == null) continue;
            categoryItemRenderer.addChangeListener(this);
        }
    }
}

