/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import org.jfree.text.TextBox;

public class PieLabelRecord
implements Comparable {
    private Comparable key;
    private double angle;
    private double baseY;
    private double allocatedY;
    private TextBox label;
    private double labelHeight;
    private double gap;
    private double linkPercent;

    public PieLabelRecord(Comparable comparable, double d2, double d3, TextBox textBox, double d4, double d5, double d6) {
        this.key = comparable;
        this.angle = d2;
        this.baseY = d3;
        this.allocatedY = d3;
        this.label = textBox;
        this.labelHeight = d4;
        this.gap = d5;
        this.linkPercent = d6;
    }

    public final double getBaseY() {
        return this.baseY;
    }

    public final void setBaseY(double d2) {
        this.baseY = d2;
    }

    public final double getLowerY() {
        return this.allocatedY - this.labelHeight / 2.0;
    }

    public final double getUpperY() {
        return this.allocatedY + this.labelHeight / 2.0;
    }

    public final double getAngle() {
        return this.angle;
    }

    public final Comparable getKey() {
        return this.key;
    }

    public final TextBox getLabel() {
        return this.label;
    }

    public final double getLabelHeight() {
        return this.labelHeight;
    }

    public final double getAllocatedY() {
        return this.allocatedY;
    }

    public final void setAllocatedY(double d2) {
        this.allocatedY = d2;
    }

    public final double getGap() {
        return this.gap;
    }

    public final double getLinkPercent() {
        return this.linkPercent;
    }

    public final int compareTo(Object object) {
        int n = 0;
        if (object instanceof PieLabelRecord) {
            PieLabelRecord pieLabelRecord = (PieLabelRecord)object;
            if (this.baseY < pieLabelRecord.baseY) {
                n = -1;
            } else if (this.baseY > pieLabelRecord.baseY) {
                n = 1;
            }
        }
        return n;
    }

    public final String toString() {
        return this.baseY + ", " + this.key.toString();
    }
}

