/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.WaferMapPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.data.general.WaferMapDataset;

public class WaferMapRenderer
extends AbstractRenderer {
    private Map paintIndex = new HashMap();
    private WaferMapPlot plot;
    private int paintLimit;
    private static final int DEFAULT_PAINT_LIMIT = 35;
    public static final int POSITION_INDEX = 0;
    public static final int VALUE_INDEX = 1;
    private int paintIndexMethod;

    public WaferMapRenderer() {
        this(null, null);
    }

    public WaferMapRenderer(int n, int n2) {
        this(new Integer(n), new Integer(n2));
    }

    public WaferMapRenderer(Integer n, Integer n2) {
        this.paintLimit = n == null ? 35 : n;
        this.paintIndexMethod = 1;
        if (n2 != null && this.isMethodValid(n2)) {
            this.paintIndexMethod = n2;
        }
    }

    private boolean isMethodValid(int n) {
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public final DrawingSupplier getDrawingSupplier() {
        DrawingSupplier drawingSupplier = null;
        WaferMapPlot waferMapPlot = this.getPlot();
        if (waferMapPlot != null) {
            drawingSupplier = waferMapPlot.getDrawingSupplier();
        }
        return drawingSupplier;
    }

    public final WaferMapPlot getPlot() {
        return this.plot;
    }

    public final void setPlot(WaferMapPlot waferMapPlot) {
        this.plot = waferMapPlot;
        this.makePaintIndex();
    }

    public final Paint getChipColor(Number number) {
        return this.getSeriesPaint(this.getPaintIndex(number));
    }

    private int getPaintIndex(Number number) {
        return (Integer)this.paintIndex.get(number);
    }

    private void makePaintIndex() {
        if (this.plot == null) {
            return;
        }
        WaferMapDataset waferMapDataset = this.plot.getDataset();
        Number number = waferMapDataset.getMinValue();
        Number number2 = waferMapDataset.getMaxValue();
        Set set = waferMapDataset.getUniqueValues();
        if (set.size() <= this.paintLimit) {
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.paintIndex.put(iterator.next(), new Integer(n++));
            }
        } else {
            switch (this.paintIndexMethod) {
                case 0: {
                    this.makePositionIndex(set);
                    break;
                }
                case 1: {
                    this.makeValueIndex(number2, number, set);
                    break;
                }
            }
        }
    }

    private void makePositionIndex(Set set) {
        int n = (int)Math.ceil((double)set.size() / (double)this.paintLimit);
        int n2 = 0;
        int n3 = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            this.paintIndex.put(iterator.next(), new Integer(n3));
            if (++n2 % n == 0) {
                ++n3;
            }
            if (n3 <= this.paintLimit) continue;
            n3 = this.paintLimit;
        }
    }

    private void makeValueIndex(Number number, Number number2, Set set) {
        double d2 = number.doubleValue() - number2.doubleValue();
        double d3 = d2 / (double)this.paintLimit;
        int n = 0;
        double d4 = number2.doubleValue() + d3;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Number number3 = (Number)iterator.next();
            while (number3.doubleValue() > d4) {
                d4 += d3;
                if (++n <= this.paintLimit) continue;
                n = this.paintLimit;
            }
            this.paintIndex.put(number3, new Integer(n));
        }
    }

    public final LegendItemCollection getLegendCollection() {
        LegendItemCollection legendItemCollection;
        block4: {
            legendItemCollection = new LegendItemCollection();
            if (this.paintIndex == null || this.paintIndex.size() <= 0) break block4;
            if (this.paintIndex.size() <= this.paintLimit) {
                Iterator iterator = this.paintIndex.entrySet().iterator();
                while (iterator.hasNext()) {
                    String string;
                    Map.Entry entry = iterator.next();
                    String string2 = string = entry.getKey().toString();
                    Rectangle2D.Double double_ = new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0);
                    Paint paint = this.getSeriesPaint((Integer)entry.getValue());
                    Color color = Color.black;
                    Stroke stroke = DEFAULT_STROKE;
                    legendItemCollection.add(new LegendItem(string, string2, null, null, (Shape)double_, paint, stroke, (Paint)color));
                }
            } else {
                HashSet hashSet = new HashSet();
                Iterator iterator = this.paintIndex.entrySet().iterator();
                while (iterator.hasNext()) {
                    String string;
                    Map.Entry entry = iterator.next();
                    if (!hashSet.add(entry.getValue())) continue;
                    String string3 = string = this.getMinPaintValue((Integer)entry.getValue()).toString() + " - " + this.getMaxPaintValue((Integer)entry.getValue()).toString();
                    Rectangle2D.Double double_ = new Rectangle2D.Double(1.0, 1.0, 1.0, 1.0);
                    Paint paint = this.getSeriesPaint((Integer)entry.getValue());
                    Color color = Color.black;
                    Stroke stroke = DEFAULT_STROKE;
                    legendItemCollection.add(new LegendItem(string, string3, null, null, (Shape)double_, paint, stroke, (Paint)color));
                }
            }
        }
        return legendItemCollection;
    }

    private Number getMinPaintValue(Integer n) {
        double d2 = Double.POSITIVE_INFINITY;
        Iterator iterator = this.paintIndex.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((Integer)entry.getValue()).equals(n) || !(((Number)entry.getKey()).doubleValue() < d2)) continue;
            d2 = ((Number)entry.getKey()).doubleValue();
        }
        return new Double(d2);
    }

    private Number getMaxPaintValue(Integer n) {
        double d2 = Double.NEGATIVE_INFINITY;
        Iterator iterator = this.paintIndex.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((Integer)entry.getValue()).equals(n) || !(((Number)entry.getKey()).doubleValue() > d2)) continue;
            d2 = ((Number)entry.getKey()).doubleValue();
        }
        return new Double(d2);
    }
}

