/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer$State;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.BooleanList;
import org.jfree.util.BooleanUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;
import org.jfree.util.UnitType;

public class StandardXYItemRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -3271351259436865995L;
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int IMAGES = 4;
    public static final int DISCONTINUOUS = 8;
    public static final int DISCONTINUOUS_LINES = 10;
    private boolean baseShapesVisible;
    private boolean plotLines;
    private boolean plotImages;
    private boolean plotDiscontinuous;
    private UnitType gapThresholdType = UnitType.RELATIVE;
    private double gapThreshold = 1.0;
    private Boolean shapesFilled;
    private BooleanList seriesShapesFilled;
    private boolean baseShapesFilled;
    private boolean drawSeriesLineAsPath;
    private transient Shape legendLine;

    public StandardXYItemRenderer() {
        this(2, null);
    }

    public StandardXYItemRenderer(int n) {
        this(n, null);
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator) {
        this(n, xYToolTipGenerator, null);
    }

    public StandardXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        if ((n & 1) != 0) {
            this.baseShapesVisible = true;
        }
        if ((n & 2) != 0) {
            this.plotLines = true;
        }
        if ((n & 4) != 0) {
            this.plotImages = true;
        }
        if ((n & 8) != 0) {
            this.plotDiscontinuous = true;
        }
        this.shapesFilled = null;
        this.seriesShapesFilled = new BooleanList();
        this.baseShapesFilled = true;
        this.legendLine = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);
        this.drawSeriesLineAsPath = false;
    }

    public boolean getBaseShapesVisible() {
        return this.baseShapesVisible;
    }

    public void setBaseShapesVisible(boolean bl) {
        if (this.baseShapesVisible != bl) {
            this.baseShapesVisible = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean getItemShapeFilled(int n, int n2) {
        return this.getSeriesShapesFilled(n);
    }

    public boolean getSeriesShapesFilled(int n) {
        if (this.shapesFilled != null) {
            return this.shapesFilled;
        }
        Boolean bl = this.seriesShapesFilled.getBoolean(n);
        if (bl != null) {
            return bl;
        }
        return this.baseShapesFilled;
    }

    public void setShapesFilled(boolean bl) {
        this.setShapesFilled(BooleanUtilities.valueOf(bl));
    }

    public void setShapesFilled(Boolean bl) {
        this.shapesFilled = bl;
    }

    public void setSeriesShapesFilled(int n, Boolean bl) {
        this.seriesShapesFilled.setBoolean(n, bl);
    }

    public boolean getBaseShapesFilled() {
        return this.baseShapesFilled;
    }

    public void setBaseShapesFilled(boolean bl) {
        this.baseShapesFilled = bl;
    }

    public boolean getPlotLines() {
        return this.plotLines;
    }

    public void setPlotLines(boolean bl) {
        if (this.plotLines != bl) {
            this.plotLines = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public UnitType getGapThresholdType() {
        return this.gapThresholdType;
    }

    public void setGapThresholdType(UnitType unitType) {
        if (unitType == null) {
            throw new IllegalArgumentException("Null 'thresholdType' argument.");
        }
        this.gapThresholdType = unitType;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public double getGapThreshold() {
        return this.gapThreshold;
    }

    public void setGapThreshold(double d2) {
        this.gapThreshold = d2;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getPlotImages() {
        return this.plotImages;
    }

    public void setPlotImages(boolean bl) {
        if (this.plotImages != bl) {
            this.plotImages = bl;
            this.notifyListeners(new RendererChangeEvent(this));
        }
    }

    public boolean getPlotDiscontinuous() {
        return this.plotDiscontinuous;
    }

    public boolean getDrawSeriesLineAsPath() {
        return this.drawSeriesLineAsPath;
    }

    public void setDrawSeriesLineAsPath(boolean bl) {
        this.drawSeriesLineAsPath = bl;
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'line' argument.");
        }
        this.legendLine = shape;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYPlot xYPlot = this.getPlot();
        if (xYPlot == null) {
            return null;
        }
        LegendItem legendItem = null;
        XYDataset xYDataset = xYPlot.getDataset(n);
        if (xYDataset != null && this.getItemVisible(n2, 0)) {
            Paint paint;
            String string;
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Shape shape = this.getSeriesShape(n2);
            boolean bl = this.getSeriesShapesFilled(n2);
            Paint paint2 = paint = this.getSeriesPaint(n2);
            Stroke stroke = this.getSeriesStroke(n2);
            legendItem = new LegendItem(string, string2, string3, string4, this.baseShapesVisible, shape, bl, paint, !bl, paint, stroke, this.plotLines, this.legendLine, stroke, paint2);
        }
        return legendItem;
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        StandardXYItemRenderer$State standardXYItemRenderer$State = new StandardXYItemRenderer$State(plotRenderingInfo);
        standardXYItemRenderer$State.seriesPath = new GeneralPath();
        StandardXYItemRenderer$State.access$002(standardXYItemRenderer$State, -1);
        return standardXYItemRenderer$State;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Object object;
        boolean bl = this.getItemVisible(n, n2);
        Object object2 = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        double d2 = xYDataset.getXValue(n, n2);
        double d3 = xYDataset.getYValue(n, n2);
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            bl = false;
        }
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d5 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
        if (this.getPlotLines()) {
            if (this.drawSeriesLineAsPath) {
                object = (StandardXYItemRenderer$State)xYItemRendererState;
                if (((StandardXYItemRenderer$State)object).getSeriesIndex() != n) {
                    ((StandardXYItemRenderer$State)object).seriesPath.reset();
                    StandardXYItemRenderer$State.access$102((StandardXYItemRenderer$State)object, false);
                    ((StandardXYItemRenderer$State)object).setSeriesIndex(n);
                }
                if (bl && !Double.isNaN(d4) && !Double.isNaN(d5)) {
                    float f2 = (float)d4;
                    float f3 = (float)d5;
                    if (plotOrientation == PlotOrientation.HORIZONTAL) {
                        f2 = (float)d5;
                        f3 = (float)d4;
                    }
                    if (((StandardXYItemRenderer$State)object).isLastPointGood()) {
                        ((StandardXYItemRenderer$State)object).seriesPath.lineTo(f2, f3);
                    } else {
                        ((StandardXYItemRenderer$State)object).seriesPath.moveTo(f2, f3);
                    }
                    ((StandardXYItemRenderer$State)object).setLastPointGood(true);
                } else {
                    ((StandardXYItemRenderer$State)object).setLastPointGood(false);
                }
                if (n2 == xYDataset.getItemCount(n) - 1 && StandardXYItemRenderer$State.access$000((StandardXYItemRenderer$State)object) == n) {
                    graphics2D.setStroke(this.getSeriesStroke(n));
                    graphics2D.setPaint(this.getSeriesPaint(n));
                    graphics2D.draw(((StandardXYItemRenderer$State)object).seriesPath);
                }
            } else if (n2 != 0 && bl) {
                double d6 = xYDataset.getXValue(n, n2 - 1);
                double d7 = xYDataset.getYValue(n, n2 - 1);
                if (!Double.isNaN(d6) && !Double.isNaN(d7)) {
                    boolean bl2 = true;
                    if (this.getPlotDiscontinuous()) {
                        int n4 = xYDataset.getItemCount(n);
                        double d8 = xYDataset.getXValue(n, 0);
                        double d9 = xYDataset.getXValue(n, n4 - 1);
                        if (this.gapThresholdType == UnitType.ABSOLUTE) {
                            bl2 = Math.abs(d2 - d6) <= this.gapThreshold;
                        } else {
                            boolean bl3 = bl2 = Math.abs(d2 - d6) <= (d9 - d8) / (double)n4 * this.getGapThreshold();
                        }
                    }
                    if (bl2) {
                        double d10 = valueAxis.valueToJava2D(d6, rectangle2D, rectangleEdge);
                        double d11 = valueAxis2.valueToJava2D(d7, rectangle2D, rectangleEdge2);
                        if (Double.isNaN(d10) || Double.isNaN(d11) || Double.isNaN(d4) || Double.isNaN(d5)) {
                            return;
                        }
                        if (plotOrientation == PlotOrientation.HORIZONTAL) {
                            xYItemRendererState.workingLine.setLine(d11, d10, d5, d4);
                        } else if (plotOrientation == PlotOrientation.VERTICAL) {
                            xYItemRendererState.workingLine.setLine(d10, d11, d4, d5);
                        }
                        if (xYItemRendererState.workingLine.intersects(rectangle2D)) {
                            graphics2D.draw(xYItemRendererState.workingLine);
                        }
                    }
                }
            }
        }
        if (!bl) {
            return;
        }
        if (this.getBaseShapesVisible()) {
            object = this.getItemShape(n, n2);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                object = ShapeUtilities.createTranslatedShape((Shape)object, d5, d4);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                object = ShapeUtilities.createTranslatedShape((Shape)object, d4, d5);
            }
            if (object.intersects(rectangle2D)) {
                if (this.getItemShapeFilled(n, n2)) {
                    graphics2D.fill((Shape)object);
                } else {
                    graphics2D.draw((Shape)object);
                }
            }
            object2 = object;
        }
        if (this.getPlotImages() && (object = this.getImage(xYPlot, n, n2, d4, d5)) != null) {
            Point point = this.getImageHotspot(xYPlot, n, n2, d4, d5, (Image)object);
            graphics2D.drawImage((Image)object, (int)(d4 - point.getX()), (int)(d5 - point.getY()), null);
            object2 = new Rectangle2D.Double(d4 - point.getX(), d5 - point.getY(), ((Image)object).getWidth(null), ((Image)object).getHeight(null));
        }
        if (this.isItemLabelVisible(n, n2)) {
            double d12 = d4;
            double d13 = d5;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d12 = d5;
                d13 = d4;
            }
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, d12, d13, d3 < 0.0);
        }
        this.updateCrosshairValues(crosshairState, d2, d3, d4, d5, plotOrientation);
        if (entityCollection != null) {
            this.addEntity(entityCollection, (Shape)object2, xYDataset, n, n2, d4, d5);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardXYItemRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)object;
        if (this.baseShapesVisible != standardXYItemRenderer.baseShapesVisible) {
            return false;
        }
        if (this.plotLines != standardXYItemRenderer.plotLines) {
            return false;
        }
        if (this.plotImages != standardXYItemRenderer.plotImages) {
            return false;
        }
        if (this.plotDiscontinuous != standardXYItemRenderer.plotDiscontinuous) {
            return false;
        }
        if (this.gapThresholdType != standardXYItemRenderer.gapThresholdType) {
            return false;
        }
        if (this.gapThreshold != standardXYItemRenderer.gapThreshold) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shapesFilled, standardXYItemRenderer.shapesFilled)) {
            return false;
        }
        return ShapeUtilities.equal(this.legendLine, standardXYItemRenderer.legendLine);
    }

    public Object clone() {
        return super.clone();
    }

    protected Image getImage(Plot plot, int n, int n2, double d2, double d3) {
        return null;
    }

    protected Point getImageHotspot(Plot plot, int n, int n2, double d2, double d3, Image image) {
        int n3 = image.getHeight(null);
        int n4 = image.getWidth(null);
        return new Point(n4 / 2, n3 / 2);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.legendLine = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendLine, objectOutputStream);
    }
}

