/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;

public abstract class AbstractDataset
implements Dataset,
Cloneable,
Serializable,
ObjectInputValidation {
    private static final long serialVersionUID = 1918768939869230744L;
    private DatasetGroup group = new DatasetGroup();
    private transient EventListenerList listenerList = new EventListenerList();
    static Class class$org$jfree$data$general$DatasetChangeListener;

    protected AbstractDataset() {
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasetGroup datasetGroup) {
        if (datasetGroup == null) {
            throw new IllegalArgumentException("Null 'group' argument.");
        }
        this.group = datasetGroup;
    }

    public void addChangeListener(DatasetChangeListener datasetChangeListener) {
        this.listenerList.add(class$org$jfree$data$general$DatasetChangeListener == null ? (class$org$jfree$data$general$DatasetChangeListener = AbstractDataset.class$("org.jfree.data.general.DatasetChangeListener")) : class$org$jfree$data$general$DatasetChangeListener, datasetChangeListener);
    }

    public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
        this.listenerList.remove(class$org$jfree$data$general$DatasetChangeListener == null ? (class$org$jfree$data$general$DatasetChangeListener = AbstractDataset.class$("org.jfree.data.general.DatasetChangeListener")) : class$org$jfree$data$general$DatasetChangeListener, datasetChangeListener);
    }

    public boolean hasListener(EventListener eventListener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(eventListener);
    }

    protected void fireDatasetChanged() {
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    protected void notifyListeners(DatasetChangeEvent datasetChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$org$jfree$data$general$DatasetChangeListener == null ? AbstractDataset.class$("org.jfree.data.general.DatasetChangeListener") : class$org$jfree$data$general$DatasetChangeListener)) continue;
            ((DatasetChangeListener)objectArray[i2 + 1]).datasetChanged(datasetChangeEvent);
        }
    }

    public Object clone() {
        AbstractDataset abstractDataset = (AbstractDataset)super.clone();
        abstractDataset.listenerList = new EventListenerList();
        return abstractDataset;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
        objectInputStream.registerValidation(this, 10);
    }

    public void validateObject() {
        this.fireDatasetChanged();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

