/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.general.SeriesChangeListener;
import org.jfree.util.ObjectUtilities;

public abstract class Series
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6906561437538683581L;
    private Comparable key;
    private String description;
    private EventListenerList listeners;
    private PropertyChangeSupport propertyChangeSupport;
    private boolean notify;
    static Class class$org$jfree$data$general$SeriesChangeListener;

    protected Series(Comparable comparable) {
        this(comparable, null);
    }

    protected Series(Comparable comparable, String string) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        this.key = comparable;
        this.description = string;
        this.listeners = new EventListenerList();
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.notify = true;
    }

    public Comparable getKey() {
        return this.key;
    }

    public void setKey(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("Null 'key' argument.");
        }
        Comparable comparable2 = this.key;
        this.key = comparable;
        this.propertyChangeSupport.firePropertyChange("Key", comparable2, comparable);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        String string2 = this.description;
        this.description = string;
        this.propertyChangeSupport.firePropertyChange("Description", string2, string);
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean bl) {
        if (this.notify != bl) {
            this.notify = bl;
            this.fireSeriesChanged();
        }
    }

    public Object clone() {
        Series series = (Series)super.clone();
        series.listeners = new EventListenerList();
        series.propertyChangeSupport = new PropertyChangeSupport(series);
        return series;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Series)) {
            return false;
        }
        Series series = (Series)object;
        if (!this.getKey().equals(series.getKey())) {
            return false;
        }
        return ObjectUtilities.equal(this.getDescription(), series.getDescription());
    }

    public int hashCode() {
        int n = this.key.hashCode();
        n = 29 * n + (this.description != null ? this.description.hashCode() : 0);
        return n;
    }

    public void addChangeListener(SeriesChangeListener seriesChangeListener) {
        this.listeners.add(class$org$jfree$data$general$SeriesChangeListener == null ? (class$org$jfree$data$general$SeriesChangeListener = Series.class$("org.jfree.data.general.SeriesChangeListener")) : class$org$jfree$data$general$SeriesChangeListener, seriesChangeListener);
    }

    public void removeChangeListener(SeriesChangeListener seriesChangeListener) {
        this.listeners.remove(class$org$jfree$data$general$SeriesChangeListener == null ? (class$org$jfree$data$general$SeriesChangeListener = Series.class$("org.jfree.data.general.SeriesChangeListener")) : class$org$jfree$data$general$SeriesChangeListener, seriesChangeListener);
    }

    public void fireSeriesChanged() {
        if (this.notify) {
            this.notifyListeners(new SeriesChangeEvent(this));
        }
    }

    protected void notifyListeners(SeriesChangeEvent seriesChangeEvent) {
        Object[] objectArray = this.listeners.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$org$jfree$data$general$SeriesChangeListener == null ? Series.class$("org.jfree.data.general.SeriesChangeListener") : class$org$jfree$data$general$SeriesChangeListener)) continue;
            ((SeriesChangeListener)objectArray[i2 + 1]).seriesChanged(seriesChangeEvent);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

