/*
 * Decompiled with CFR 0.152.
 */
package xapps.api.vtools;

import com.jidesoft.swing.JideButton;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.utils.ClassUtils;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.DialogType;
import edu.mit.broad.xbench.core.api.VTool;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public abstract class AbstractVTool
extends AbstractAction
implements VTool {
    private DialogType fDialogType;
    protected static final transient Logger klog = XLogger.getLogger(AbstractVTool.class);
    protected static ToolReport kReport;
    private String fName;

    public AbstractVTool(String string, Icon icon, DialogType dialogType) {
        super(string, icon);
        this.fDialogType = dialogType;
        this.fName = string;
        if (kReport == null) {
            klog.debug("Making vtoolreport");
            File file = Application.getVdbManager().getDefaultOutputDir();
            kReport = new ToolReport(null, false, file, new ReportIndexState(false, false, false, null));
        }
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        Application.getWindowManager().runModalTool(this, this.fDialogType);
    }

    protected final void showSavedMessage(File file) {
        Application.getWindowManager().showMessage("Saved result to : " + file.getPath());
    }

    protected final void showSavedMessage() {
        Application.getWindowManager().showMessage("Saved result to : " + kReport.getReportDir());
    }

    protected final void showError(Throwable throwable) {
        Application.getWindowManager().showError(throwable);
    }

    protected final void showError(String string) {
        Application.getWindowManager().showError(string);
    }

    @Override
    public String getHelpURL() {
        return JarResources.getHelpURL(this.getClass().getName());
    }

    protected static final JButton createButton(VTool vTool) {
        JideButton jideButton = new JideButton(vTool);
        String string = ClassUtils.shorten(vTool.getClass());
        jideButton.setToolTipText(vTool.getTitle() + " [" + string + "]");
        jideButton.setButtonStyle(1);
        jideButton.setPreferredSize(new Dimension(100, 20));
        return jideButton;
    }
}

