/*
 * Decompiled with CFR 0.152.
 */
package xapps.browser;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.grid.QuickFilterPane;
import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideTabbedPane;
import com.jidesoft.swing.JideTitledBorder;
import com.jidesoft.swing.PartialEtchedBorder;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.models.MSigDBModel;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.viewers.AbstractViewer;
import edu.mit.broad.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.vdb.msigdb.MSigDB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;
import xapps.browser.MGUIUtils;
import xapps.browser.MSigDBViewer$1;
import xapps.browser.MSigDBViewer$2;
import xapps.browser.MSigDBViewer$3;
import xapps.browser.MSigDBViewer$4;
import xapps.browser.MSigDBViewer$MyPopup;
import xapps.browser.MSigDBViewer$MyViewerHook;
import xapps.browser.VToolsForMSigDBBrowser$SearchByGene;
import xapps.browser.VToolsForMSigDBBrowser$SearchByGeneSet;

public class MSigDBViewer
extends AbstractViewer {
    public static final String NAME = "MSigDBViewer";
    public static final Icon ICON = JarResources.getIcon("msigdb16.png");
    private MSigDBViewer fInstance = this;
    private JideTabbedPane fTabbedPane_opt;
    private MSigDB fMSigDB;
    private boolean showDeepSearchOptions;
    private JLabel fStatusLabel;
    private TableModel curr_displayed_table_model;
    private QuickTableFilterField quickFilterTable;
    private JTable sortableTable;
    private MSigDBModel msigDbTableModel;

    public MSigDBViewer(MSigDB mSigDB, boolean bl) {
        this(mSigDB, bl, null);
    }

    public MSigDBViewer(MSigDB mSigDB, boolean bl, JideTabbedPane jideTabbedPane) {
        super(NAME, ICON, "Gene sets browser [MSigDB]");
        this.fMSigDB = mSigDB;
        this.showDeepSearchOptions = bl;
        this.fTabbedPane_opt = jideTabbedPane;
        this.jbInit();
    }

    public final String[] getSelectedGeneSetNames() {
        JTable jTable = this.getDisplayedTable();
        int[] nArray = this.getDisplayedTable().getSelectedRows();
        String[] stringArray = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringArray[i2] = jTable.getModel().getValueAt(nArray[i2], 1).toString();
        }
        return stringArray;
    }

    public final String[] getDisplayedGeneSetNames() {
        JTable jTable = this.getDisplayedTable();
        String[] stringArray = new String[this.getDisplayedTable().getRowCount()];
        for (int i2 = 0; i2 < this.getDisplayedTable().getRowCount(); ++i2) {
            stringArray[i2] = jTable.getModel().getValueAt(i2, 1).toString();
        }
        return stringArray;
    }

    public final int getNumSelectedRows() {
        return this.getDisplayedTable().getSelectedRows().length;
    }

    public final GeneSetAnnotation getSelectedGeneSetAnnotation() {
        String[] stringArray = this.getSelectedGeneSetNames();
        if (stringArray.length > 0) {
            return this.fMSigDB.getGeneSetAnnotation(stringArray[0]);
        }
        return null;
    }

    private void jbInit() {
        this.setLayout(new BorderLayout(15, 15));
        this.add(this.createViewAndSearchComponent(), "Center");
        this.add((Component)MGUIUtils.createExportSetsControlPanel(new MSigDBViewer$MyViewerHook(this, true), new MSigDBViewer$MyViewerHook(this, false)), "South");
        this.revalidate();
    }

    private JPanel createDeepSearchPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.setBorder(BorderFactory.createTitledBorder("Deep search options"));
        JButton jButton = new JButton("Find sets that overlap with my set ...");
        buttonPanel.addButton(jButton);
        jButton.addActionListener(new VToolsForMSigDBBrowser$SearchByGeneSet(this.fMSigDB, this.fTabbedPane_opt));
        JButton jButton2 = new JButton("Find sets that contain this gene ...");
        buttonPanel.addButton(jButton2);
        jButton2.addActionListener(new VToolsForMSigDBBrowser$SearchByGene(this.fMSigDB, this.fTabbedPane_opt));
        return buttonPanel;
    }

    private JTable getOrigTable() {
        return this.sortableTable;
    }

    private JTable getDisplayedTable() {
        return this.quickFilterTable.getTable();
    }

    private Component createViewAndSearchComponent() {
        this.msigDbTableModel = new MSigDBModel(this.fMSigDB);
        QuickFilterPane quickFilterPane = new QuickFilterPane(new SortableTableModel(this.msigDbTableModel), new int[]{4, 5, 6, 7});
        this.quickFilterTable = new QuickTableFilterField(quickFilterPane.getDisplayTableModel(), new int[]{1, 4});
        JPanel jPanel = new JPanel(new FlowLayout(3));
        jPanel.add(this.quickFilterTable);
        jPanel.setBorder(new JideTitledBorder(new PartialEtchedBorder(1, 1), "", 4, 1));
        JideSplitPane jideSplitPane = new JideSplitPane(0);
        quickFilterPane.setBorder(BorderFactory.createCompoundBorder(new JideTitledBorder(new PartialEtchedBorder(1, 1), "QuickFilterPane", 4, 1), BorderFactory.createEmptyBorder(6, 0, 0, 0)));
        jideSplitPane.addPane(quickFilterPane);
        JPanel jPanel2 = new JPanel(new BorderLayout(2, 2));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(new JideTitledBorder(new PartialEtchedBorder(1, 1), "Filtered result List (right click for options)", 4, 1), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        this.fStatusLabel = new JLabel(this.quickFilterTable.getDisplayTableModel().getRowCount() + " out of " + this.msigDbTableModel.getRowCount() + " gene sets");
        this.fStatusLabel.setHorizontalAlignment(0);
        this.fStatusLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.fStatusLabel.setForeground(GuiHelper.COLOR_DARK_BROWN);
        this.sortableTable = new SortableTable(this.quickFilterTable.getDisplayTableModel());
        this.sortableTable.getTableHeader().setPreferredSize(new Dimension(100, 20));
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(2);
        this.sortableTable.getColumnModel().getColumn(3).setCellRenderer(defaultTableCellRenderer);
        MSigDBViewer$MyPopup mSigDBViewer$MyPopup = new MSigDBViewer$MyPopup(this);
        this.sortableTable.addMouseListener(new MSigDBViewer$1(this, mSigDBViewer$MyPopup));
        ListSelectionModel listSelectionModel = this.sortableTable.getSelectionModel();
        listSelectionModel.setSelectionMode(2);
        listSelectionModel.addListSelectionListener(new MSigDBViewer$2(this));
        this.quickFilterTable.setTable(this.sortableTable);
        JScrollPane jScrollPane = new JScrollPane(this.sortableTable, 22, 30);
        this.curr_displayed_table_model = this.msigDbTableModel;
        this.quickFilterTable.getDisplayTableModel().addTableModelListener(new MSigDBViewer$3(this));
        this.sortableTable.getSelectionModel().addListSelectionListener(new MSigDBViewer$4(this));
        jPanel2.add((Component)this.fStatusLabel, "First");
        jPanel2.add(jScrollPane);
        if (this.showDeepSearchOptions) {
            jideSplitPane.add(this.createDeepSearchPanel());
        }
        jideSplitPane.addPane(jPanel2);
        JPanel jPanel3 = new JPanel(new BorderLayout(3, 3));
        jPanel3.add((Component)jPanel, "First");
        jPanel3.add(jideSplitPane);
        return jPanel3;
    }

    @Override
    public final JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    static final /* synthetic */ TableModel access$002(MSigDBViewer mSigDBViewer, TableModel tableModel) {
        mSigDBViewer.curr_displayed_table_model = tableModel;
        return mSigDBViewer.curr_displayed_table_model;
    }

    static final /* synthetic */ TableModel access$000(MSigDBViewer mSigDBViewer) {
        return mSigDBViewer.curr_displayed_table_model;
    }

    static final /* synthetic */ MSigDBModel access$100(MSigDBViewer mSigDBViewer) {
        return mSigDBViewer.msigDbTableModel;
    }

    static final /* synthetic */ JLabel access$200(MSigDBViewer mSigDBViewer) {
        return mSigDBViewer.fStatusLabel;
    }

    static final /* synthetic */ JTable access$300(MSigDBViewer mSigDBViewer) {
        return mSigDBViewer.sortableTable;
    }

    static final /* synthetic */ JTable access$400(MSigDBViewer mSigDBViewer) {
        return mSigDBViewer.getOrigTable();
    }

    static final /* synthetic */ JTable access$500(MSigDBViewer mSigDBViewer) {
        return mSigDBViewer.getDisplayedTable();
    }

    static final /* synthetic */ Logger access$600(MSigDBViewer mSigDBViewer) {
        return mSigDBViewer.log;
    }

    static final /* synthetic */ Logger access$700(MSigDBViewer mSigDBViewer) {
        return mSigDBViewer.log;
    }

    static final /* synthetic */ MSigDBViewer access$800(MSigDBViewer mSigDBViewer) {
        return mSigDBViewer.fInstance;
    }

    static final /* synthetic */ MSigDB access$900(MSigDBViewer mSigDBViewer) {
        return mSigDBViewer.fMSigDB;
    }

    static final /* synthetic */ JideTabbedPane access$1000(MSigDBViewer mSigDBViewer) {
        return mSigDBViewer.fTabbedPane_opt;
    }
}

