/*
 * Decompiled with CFR 0.152.
 */
package xapps.browser;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.viewers.Viewer;
import edu.mit.broad.vdb.msigdb.GeneSetAnnotation;
import edu.mit.broad.vdb.msigdb.MSigDB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JTabbedPane;
import xapps.api.vtools.AbstractVToolWithParams;
import xapps.browser.VToolsForMSigDBBrowser;
import xapps.browser.VToolsForMSigDBBrowser$MyBaseHook;
import xapps.gsea.GeneSetAnnotationWithOverlaps;
import xapps.gsea.GeneSetAnnotationWithOverlaps$One;
import xtools.api.param.GeneSetMultiChooserParam;

public class VToolsForMSigDBBrowser$SearchByGeneSet
extends AbstractVToolWithParams {
    private JTabbedPane viewer_window_opt;
    private MSigDB msigdb;
    private GeneSetMultiChooserParam fGeneSetParam;

    public VToolsForMSigDBBrowser$SearchByGeneSet(MSigDB mSigDB, JTabbedPane jTabbedPane) {
        super("Search by gene set", new VToolsForMSigDBBrowser$MyBaseHook("geneset_", null));
        this.viewer_window_opt = jTabbedPane;
        this.msigdb = mSigDB;
    }

    public final int findInt(Collection collection, GeneSet geneSet) {
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            if (!geneSet.isMember(iterator.next().toString())) continue;
            ++n;
        }
        return n;
    }

    @Override
    public final Viewer execute() {
        Object object;
        GeneSet geneSet = this.fGeneSetParam.getGeneSetCombo();
        ArrayList<GeneSetAnnotationWithOverlaps$One> arrayList = new ArrayList<GeneSetAnnotationWithOverlaps$One>();
        for (int i2 = 0; i2 < this.msigdb.getNumGeneSets(); ++i2) {
            object = this.msigdb.getGeneSetAnnotation(i2);
            FSet fSet = (FSet)object.getGeneSet(false);
            int n = this.findInt(fSet.getMembers_quick(), geneSet);
            if (n > 0) {
                arrayList.add(new GeneSetAnnotationWithOverlaps$One((GeneSetAnnotation)object, n, fSet.getNumMembers()));
            }
            if (i2 % 250 != 0) continue;
            System.out.println("Done searching " + (i2 + 1) + " / " + this.msigdb.getNumGeneSets());
        }
        klog.debug("# of hits: " + arrayList.size());
        GeneSetAnnotationWithOverlaps$One[] geneSetAnnotationWithOverlaps$OneArray = arrayList.toArray(new GeneSetAnnotationWithOverlaps$One[arrayList.size()]);
        object = new GeneSetAnnotationWithOverlaps(geneSet, geneSetAnnotationWithOverlaps$OneArray);
        return VToolsForMSigDBBrowser.access$000("# of hits: " + arrayList.size(), "Gene set search: " + NamingConventions.removeExtension(geneSet.getName(true)) + "( " + geneSet.getNumMembers() + ")", ((GeneSetAnnotationWithOverlaps)object).createViewer(this.msigdb), this.viewer_window_opt);
    }

    @Override
    public final void declareParams() {
        this.fGeneSetParam = new GeneSetMultiChooserParam("gset", "Gene set (ids must be symbols)", "Gene set");
        this.fParamSet.addParam(this.fGeneSetParam);
    }

    @Override
    public final String getTitle() {
        return "Search for overlapping gene sets";
    }

    @Override
    public final String getHelpURL() {
        return JarResources.getHelpURL("xapps_mbrowser_SearchByGeneSet");
    }
}

