/*
 * Decompiled with CFR 0.152.
 */
package xapps.gsea;

import edu.mit.broad.genome.Constants;
import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.swing.ProgressMonitorInputStream2;
import edu.mit.broad.genome.viewers.DatasetViewerAction;
import edu.mit.broad.genome.viewers.GeneSetMatrixViewerAction;
import edu.mit.broad.genome.viewers.GeneSetViewerAction;
import edu.mit.broad.genome.viewers.PhenotypeViewerAction;
import edu.mit.broad.genome.viewers.RankedListViewerAction;
import edu.mit.broad.genome.viewers.ReportViewerAction;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.actions.ChipViewerAction;
import edu.mit.broad.xbench.actions.PobActions;
import edu.mit.broad.xbench.actions.XAction;
import edu.mit.broad.xbench.actions.ext.ExcelAction;
import edu.mit.broad.xbench.actions.ext.OsExplorerAction;
import edu.mit.broad.xbench.actions.ext.TextpadAction;
import edu.mit.broad.xbench.actions.misc_actions.GeneSetMatrix2GeneSetAction;
import edu.mit.broad.xbench.actions.misc_actions.GeneSetMatrix2GeneSetsAction;
import edu.mit.broad.xbench.actions.misc_actions.GeneSetRemoveDuplicatesAction;
import edu.mit.broad.xbench.actions.misc_actions.LoadAction;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import xapps.api.frameworks.AbstractActionLookup;

class GseaActionRegistry
extends AbstractActionLookup
implements Constants {
    static final Logger klog = XLogger.getLogger(GseaActionRegistry.class);
    private static PobActions COMMON_ACTIONS;
    private static PobActions GEX_ACTIONS;
    private static PobActions CHIP_ACTIONS;
    private static PobActions GRP_ACTIONS;
    public static PobActions CLS_ACTIONS;
    public static PobActions RNK_ACTIONS;
    private static PobActions GMX_ACTIONS;
    private static PobActions GMT_ACTIONS;
    private static PobActions RPT_ACTIONS;
    private static GseaActionRegistry kSingleton;

    protected static final GseaActionRegistry getInstance() {
        if (kSingleton == null) {
            kSingleton = new GseaActionRegistry();
        }
        return kSingleton;
    }

    private GseaActionRegistry() {
        this.fExtActionsMap.put("res", GEX_ACTIONS);
        this.fExtActionsMap.put("txt", GEX_ACTIONS);
        this.fExtActionsMap.put("pcl", GEX_ACTIONS);
        this.fExtActionsMap.put("gct", GEX_ACTIONS);
        this.fExtActionsMap.put("cls", CLS_ACTIONS);
        this.fExtActionsMap.put("grp", GRP_ACTIONS);
        this.fExtActionsMap.put("gmx", GMX_ACTIONS);
        this.fExtActionsMap.put("gmt", GMT_ACTIONS);
        this.fExtActionsMap.put("def", COMMON_ACTIONS);
        this.fExtActionsMap.put("rpt", RPT_ACTIONS);
        this.fExtActionsMap.put("chip", CHIP_ACTIONS);
        this.fExtActionsMap.put("rnk", RNK_ACTIONS);
    }

    private static PobActions _addCommon(XAction[] xActionArray) {
        ArrayList<XAction> arrayList = new ArrayList<XAction>();
        int n = 0;
        int n2 = 0;
        while (n2 < xActionArray.length) {
            arrayList.add(xActionArray[n2]);
            ++n2;
            ++n;
        }
        if (n != 0) {
            arrayList.add(null);
        }
        for (n2 = 0; n2 < GseaActionRegistry.COMMON_ACTIONS.allActions.length; ++n2) {
            arrayList.add(GseaActionRegistry.COMMON_ACTIONS.allActions[n2]);
        }
        return new PobActions(arrayList.toArray(new XAction[arrayList.size()]));
    }

    @Override
    protected final PobActions lookupActions(Object object) {
        String string = "";
        if (object instanceof Dataset || string.endsWith("res") || string.endsWith("gct") || string.endsWith("pcl") || string.endsWith("txt")) {
            return GEX_ACTIONS;
        }
        if (object instanceof GeneSet || string.endsWith(".grp")) {
            return GRP_ACTIONS;
        }
        if (object instanceof GeneSetMatrix || string.endsWith("gmx") || string.endsWith("gmt")) {
            return GMX_ACTIONS;
        }
        if (object instanceof Report || string.endsWith("rpt")) {
            return RPT_ACTIONS;
        }
        if (object instanceof Chip || string.endsWith("chip")) {
            return CHIP_ACTIONS;
        }
        if (object instanceof Template || string.endsWith("cls")) {
            return CLS_ACTIONS;
        }
        if (object instanceof RankedList) {
            return RNK_ACTIONS;
        }
        return new PobActions();
    }

    public final boolean runDefaultAction(Object object) {
        if (object instanceof File || object instanceof File[]) {
            File[] fileArray = object instanceof File ? new File[]{(File)object} : (File[])object;
            if (fileArray.length == 1 && fileArray[0].getName().endsWith("html")) {
                URI uRI = fileArray[0].toURI();
                try {
                    uRI = new URI(uRI.getScheme(), "", uRI.getPath(), null, null);
                    Desktop.getDesktop().browse(uRI);
                }
                catch (Exception exception) {
                    Application.getWindowManager().showError(exception.toString());
                }
                return true;
            }
            StringBuffer stringBuffer = new StringBuffer("Loading ... " + fileArray.length + " files\n\n");
            StringBuffer stringBuffer2 = new StringBuffer("Loading ... " + fileArray.length + " files<br>");
            int n = 0;
            int n2 = 0;
            Errors errors = new Errors();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (fileArray[i2].isDirectory()) {
                    errors.add("Only files can be choosen - a directory was specified: " + fileArray[i2].getPath());
                    ++n2;
                    continue;
                }
                try {
                    FileInputStream fileInputStream = new FileInputStream(fileArray[i2]);
                    ProgressMonitorInputStream2 progressMonitorInputStream2 = new ProgressMonitorInputStream2(fileInputStream);
                    ParserFactory.read(fileArray[i2].getPath(), progressMonitorInputStream2, true);
                    klog.info("Loaded file: " + fileArray[i2].getPath());
                    stringBuffer2.append(fileArray[i2].getName()).append("<br>");
                    stringBuffer.append(fileArray[i2].getName()).append("\n");
                    ++n;
                    continue;
                }
                catch (Throwable throwable) {
                    ++n2;
                    errors.add("Parsing trouble", throwable);
                }
            }
            stringBuffer2.append("<br>Files loaded successfully: ").append(n).append(" / ").append(fileArray.length);
            stringBuffer.append("\nFiles loaded successfully: ").append(n).append(" / ").append(fileArray.length).append('\n');
            stringBuffer2.append("<br><hr><br>");
            if (n2 == 0) {
                stringBuffer.append("There were NO errors");
                Application.getWindowManager().showMessage(stringBuffer.toString());
            } else {
                stringBuffer2.append("There were errors: ").append(n2);
                stringBuffer2.append("<br>").append(errors.getErrors(true)).append("<br>");
                Application.getWindowManager().showError(stringBuffer2.toString());
            }
            return true;
        }
        return false;
    }

    static {
        klog.debug("Initializing GseaActionRegistry");
        COMMON_ACTIONS = new PobActions(new XAction[]{new LoadAction(false), null, new ExcelAction(), new TextpadAction(), new OsExplorerAction()});
        GEX_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new DatasetViewerAction()});
        CHIP_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new ChipViewerAction()});
        GRP_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new GeneSetViewerAction(), null, new GeneSetRemoveDuplicatesAction()});
        CLS_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new PhenotypeViewerAction()});
        RNK_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new RankedListViewerAction()});
        GMT_ACTIONS = GMX_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new GeneSetMatrixViewerAction(), null, new GeneSetMatrix2GeneSetsAction(), new GeneSetMatrix2GeneSetAction()});
        RPT_ACTIONS = GseaActionRegistry._addCommon(new XAction[]{new ReportViewerAction()});
    }
}

