/*
 * Decompiled with CFR 0.152.
 */
package xtools.api;

import edu.mit.broad.genome.alg.GeneSetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.parsers.ParseUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Set;
import xtools.api.AbstractTool;
import xtools.api.param.FileParam;
import xtools.api.param.GeneSetMatrixMultiChooserParam;
import xtools.api.param.IntegerParam;
import xtools.api.param.StringMultiInputParam;

public class AbstractTool$Helper {
    public static final String[] getStringsArray(StringMultiInputParam stringMultiInputParam, FileParam fileParam) {
        Set set = AbstractTool$Helper.getStrings(stringMultiInputParam, fileParam);
        return set.toArray(new String[set.size()]);
    }

    public static final Set getStrings(StringMultiInputParam stringMultiInputParam, FileParam fileParam) {
        Set set;
        if (stringMultiInputParam.isSpecified()) {
            set = stringMultiInputParam.getStringsS();
        } else if (fileParam.isSpecified()) {
            File file = fileParam.getFile();
            set = ParseUtils.slurpIntoSet(file, true);
        } else {
            throw new IllegalArgumentException("Either 1 of pattern or file of patterns must be specified");
        }
        return set;
    }

    public static final GeneSet[] getGeneSets(Dataset dataset, GeneSetMatrixMultiChooserParam geneSetMatrixMultiChooserParam, IntegerParam integerParam, IntegerParam integerParam2) {
        GeneSet[] geneSetArray = geneSetMatrixMultiChooserParam.getGeneSetMatrixCombo(false).getGeneSets();
        return AbstractTool$Helper.getGeneSets((Object)dataset, geneSetArray, integerParam, integerParam2);
    }

    public static final GeneSet[] getGeneSets(RankedList rankedList, GeneSetMatrixMultiChooserParam geneSetMatrixMultiChooserParam, IntegerParam integerParam, IntegerParam integerParam2) {
        GeneSet[] geneSetArray = geneSetMatrixMultiChooserParam.getGeneSetMatrixCombo(false).getGeneSets();
        return AbstractTool$Helper.getGeneSets((Object)rankedList, geneSetArray, integerParam, integerParam2);
    }

    public static final GeneSet[] getGeneSets(Object object, GeneSet[] geneSetArray, IntegerParam integerParam, IntegerParam integerParam2) {
        if (integerParam2.getIValue() < integerParam.getIValue()) {
            throw new IllegalArgumentException("Max size cannot be less than min size");
        }
        AbstractTool.klog.info("Got gsets: " + geneSetArray.length + " now preprocessing them ... min: " + integerParam.getIValue() + " max: " + integerParam2.getIValue());
        if (integerParam.getIValue() != integerParam2.getIValue()) {
            boolean bl;
            if (integerParam.isSpecified()) {
                geneSetArray = GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, integerParam.getIValue(), object, true);
                bl = false;
            } else {
                bl = true;
            }
            AbstractTool.klog.info("Done preproc for smaller than: " + integerParam.getIValue());
            if (integerParam2.isSpecified()) {
                geneSetArray = GeneSetGenerators.removeGeneSetsLargerThan(geneSetArray, integerParam2.getIValue(), object, bl);
            }
        } else {
            AbstractTool.klog.info("Skipped gene set size filtering");
        }
        AbstractTool.klog.debug("Done geneset preproc starting analysis ...");
        return AbstractTool$Helper.removeAllZeroMemberSets(geneSetArray);
    }

    private static GeneSet[] removeAllZeroMemberSets(GeneSet[] geneSetArray) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            if (geneSetArray[i2].getNumMembers() <= 0) continue;
            arrayList.add(geneSetArray[i2]);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    public static final GeneSet[] getGeneSets(GeneSetMatrixMultiChooserParam geneSetMatrixMultiChooserParam, IntegerParam integerParam, IntegerParam integerParam2) {
        if (integerParam2.getIValue() < integerParam.getIValue()) {
            throw new IllegalArgumentException("Max size cannot be less than min size");
        }
        GeneSet[] geneSetArray = geneSetMatrixMultiChooserParam.getGeneSetMatrixCombo(false).getGeneSets();
        AbstractTool.klog.info("Got gsets: " + geneSetArray.length + " now preprocessing them ...");
        if (integerParam.getIValue() != integerParam2.getIValue()) {
            if (integerParam.isSpecified()) {
                geneSetArray = GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, integerParam.getIValue());
            }
            AbstractTool.klog.info("Done preproc for smaller than: " + integerParam.getIValue());
            if (integerParam2.isSpecified()) {
                geneSetArray = GeneSetGenerators.removeGeneSetsLargerThan(geneSetArray, integerParam2.getIValue());
            }
        } else {
            AbstractTool.klog.info("Skipped gene set size filtering");
        }
        AbstractTool.klog.debug("Done geneset preproc starting analysis ...");
        return AbstractTool$Helper.removeAllZeroMemberSets(geneSetArray);
    }
}

