/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.alg.DatasetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import java.awt.event.ActionListener;
import xtools.api.AbstractTool;
import xtools.api.param.ChipChooserMultiParam;
import xtools.api.param.ChipOptParam;
import xtools.api.param.GeneSetMatrixMultiChooserParam;
import xtools.api.param.GeneSetOptParam;
import xtools.api.param.GeneSetReqdParam;
import xtools.api.param.PobParam;
import xtools.api.param.SampleAnnotParam;
import xtools.api.param.TemplateMultiChooserParam;
import xtools.api.param.TemplateSingleChooserParam;

public class DatasetReqdParam
extends PobParam
implements ActionListener {
    public DatasetReqdParam() {
        this("res", "Expression dataset", "Expression dataset - with rows as genes and columns as samples (for instance: res, gct, pcl files)");
    }

    public DatasetReqdParam(String string, String string2) {
        super(string, Dataset.class, string2, (Object[])new Dataset[0], true);
    }

    public DatasetReqdParam(String string) {
        super(string, Dataset.class, "Expression dataset - with rows as genes and columns as samples (for instance: res, gct, pcl files)", (Object[])new Dataset[0], true);
    }

    public DatasetReqdParam(String string, String string2, String string3) {
        super(string, string2, Dataset.class, string3, (Object)new Dataset[0], true);
    }

    public final void setValue(Dataset dataset) {
        super.setValue(dataset);
    }

    public final Dataset getDataset() {
        return (Dataset)this.getPob();
    }

    public final Dataset getDataset(Chip chip) {
        Dataset dataset = this.getDataset();
        AbstractTool.setChip(dataset, chip);
        return dataset;
    }

    public final Dataset getDataset(SampleAnnot sampleAnnot) {
        Dataset dataset = this.getDataset();
        AbstractTool.setChip(dataset, sampleAnnot.getChip(dataset));
        AbstractTool.setSampleAnnot(dataset, sampleAnnot);
        this.log.debug("fullDs: " + dataset.getQuickInfo() + " " + sampleAnnot.getNumSamples());
        if (dataset.getNumCol() != sampleAnnot.getNumSamples()) {
            throw new IllegalStateException();
        }
        return dataset;
    }

    public final Dataset getDataset(SampleAnnot sampleAnnot, GeneSetOptParam geneSetOptParam) {
        Dataset dataset = this.getDataset(sampleAnnot);
        if (geneSetOptParam != null && geneSetOptParam.isSpecified()) {
            dataset = new DatasetGenerators().extractRows(dataset, geneSetOptParam.getGeneSet());
        }
        this.log.debug(dataset.getQuickInfo());
        return dataset;
    }

    public final Dataset getDataset(ChipOptParam chipOptParam, SampleAnnotParam sampleAnnotParam) {
        Dataset dataset = this.getDataset();
        AbstractTool.setChip(dataset, chipOptParam);
        AbstractTool.setSampleAnnot(dataset, sampleAnnotParam);
        return dataset;
    }

    public final Dataset getDataset(ChipChooserMultiParam chipChooserMultiParam, SampleAnnotParam sampleAnnotParam) {
        Dataset dataset = this.getDataset();
        AbstractTool.setChip(dataset, chipChooserMultiParam);
        AbstractTool.setSampleAnnot(dataset, sampleAnnotParam);
        return dataset;
    }

    public final Dataset getDataset(TemplateSingleChooserParam templateSingleChooserParam) {
        if (templateSingleChooserParam != null && templateSingleChooserParam.isSpecified()) {
            return new DatasetGenerators().extract(this.getDataset(), templateSingleChooserParam.getTemplate()).getDataset();
        }
        return this.getDataset();
    }

    public final Dataset[] getDatasets(TemplateMultiChooserParam templateMultiChooserParam) {
        if (!templateMultiChooserParam.isSpecified()) {
            return new Dataset[]{this.getDataset()};
        }
        DatasetGenerators datasetGenerators = new DatasetGenerators();
        Dataset dataset = this.getDataset();
        Template[] templateArray = templateMultiChooserParam.getTemplates(dataset);
        Dataset[] datasetArray = new Dataset[templateArray.length];
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            datasetArray[i2] = datasetGenerators.extract(dataset, templateArray[i2]).getDataset();
        }
        return datasetArray;
    }

    public final Dataset getDataset(GeneSet geneSet) {
        return new DatasetGenerators().extractRows(this.getDataset(), geneSet);
    }

    public final Dataset getDataset(GeneSet geneSet, SampleAnnotParam sampleAnnotParam) {
        Dataset dataset = this.getDataset(geneSet);
        AbstractTool.setSampleAnnot(dataset, sampleAnnotParam);
        return dataset;
    }

    public final Dataset getDataset(GeneSetOptParam geneSetOptParam) {
        if (geneSetOptParam != null && geneSetOptParam.isSpecified()) {
            return new DatasetGenerators().extractRows(this.getDataset(), geneSetOptParam.getGeneSet());
        }
        return this.getDataset();
    }

    public final Dataset getDataset(GeneSetReqdParam geneSetReqdParam) {
        if (geneSetReqdParam != null && geneSetReqdParam.isSpecified()) {
            return new DatasetGenerators().extractRows(this.getDataset(), geneSetReqdParam.getGeneSet());
        }
        return this.getDataset();
    }

    public final Dataset getDataset(GeneSetMatrixMultiChooserParam geneSetMatrixMultiChooserParam) {
        if (geneSetMatrixMultiChooserParam != null && geneSetMatrixMultiChooserParam.isSpecified()) {
            return this.getDataset(geneSetMatrixMultiChooserParam.getGeneSetCombo());
        }
        return this.getDataset();
    }

    public final Dataset getDataset(TemplateSingleChooserParam templateSingleChooserParam, GeneSetMatrixMultiChooserParam geneSetMatrixMultiChooserParam) {
        Dataset dataset = this.getDataset(templateSingleChooserParam);
        if (geneSetMatrixMultiChooserParam != null && geneSetMatrixMultiChooserParam.isSpecified()) {
            return new DatasetGenerators().extractRows(dataset.getName(), dataset, geneSetMatrixMultiChooserParam.getGeneSetCombo());
        }
        return dataset;
    }

    public final Dataset getDataset(TemplateSingleChooserParam templateSingleChooserParam, GeneSetOptParam geneSetOptParam) {
        Dataset dataset = this.getDataset(templateSingleChooserParam);
        if (geneSetOptParam != null && geneSetOptParam.isSpecified()) {
            return new DatasetGenerators().extractRows(dataset.getName(), dataset, geneSetOptParam.getGeneSet());
        }
        return dataset;
    }
}

