/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.alg.GeneSetGenerators;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.GenesOfInterest;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.RankedList;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.vdb.chip.Chip;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import xtools.api.param.AbstractPobChooserParam;
import xtools.api.param.DatasetOptParam;
import xtools.api.param.GeneSetChooserAbstractParam$MyPobActionListener;
import xtools.api.param.IntegerParam;
import xtools.api.param.ParamHelper;
import xtools.api.ui.GeneSetFieldPlusChooser;

class GeneSetChooserAbstractParam
extends AbstractPobChooserParam {
    private boolean fMultipleAllowed = true;
    private GeneSetChooserAbstractParam$MyPobActionListener fAl;
    protected GeneSetFieldPlusChooser fPlusChooser;

    GeneSetChooserAbstractParam(String string, String string2, String string3, boolean bl, boolean bl2) {
        super(string, string2, string3, GeneSet[].class, GeneSet.class, (Object[])new GeneSet[0], (Object[])new GeneSet[0], bl, bl2);
        this.fMultipleAllowed = bl2;
    }

    public void setValue(GeneSet geneSet) {
        super.setValue(new GeneSet[]{geneSet});
    }

    public void setValue(GeneSet[] geneSetArray) {
        super.setValue(geneSetArray);
    }

    public GeneSet[] getGeneSets(IntegerParam integerParam, IntegerParam integerParam2, DatasetOptParam datasetOptParam) {
        GeneSet[] geneSetArray = this._getGeneSets();
        boolean bl = true;
        if (datasetOptParam.isSpecified()) {
            if (integerParam.isSpecified()) {
                geneSetArray = GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, integerParam.getIValue(), datasetOptParam.getDataset(), true);
                bl = false;
            }
            if (integerParam2.isSpecified()) {
                geneSetArray = GeneSetGenerators.removeGeneSetsLargerThan(geneSetArray, integerParam2.getIValue(), datasetOptParam.getDataset(), bl);
            }
        } else {
            if (integerParam.isSpecified()) {
                geneSetArray = GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, integerParam.getIValue());
            }
            if (integerParam2.isSpecified()) {
                geneSetArray = GeneSetGenerators.removeGeneSetsLargerThan(geneSetArray, integerParam2.getIValue());
            }
        }
        return geneSetArray;
    }

    public GeneSet[] getGeneSets(IntegerParam integerParam, IntegerParam integerParam2, boolean bl) {
        GeneSet[] geneSetArray = this._getGeneSets();
        if (integerParam.isSpecified()) {
            geneSetArray = GeneSetGenerators.removeGeneSetsSmallerThan(geneSetArray, integerParam.getIValue());
        }
        if (integerParam2.isSpecified()) {
            geneSetArray = GeneSetGenerators.removeGeneSetsLargerThan(geneSetArray, integerParam2.getIValue());
        }
        return geneSetArray;
    }

    protected final Object[] _getObjects() {
        Object[] objectArray;
        Object object = this.getValue();
        if (object instanceof String) {
            String[] stringArray = GeneSetChooserAbstractParam._parse(object.toString());
            objectArray = new Object[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                objectArray[i2] = AuxUtils.isAux(stringArray[i2]) ? ParserFactory.readGeneSet(new File(stringArray[i2]), true) : ParserFactory.read(new File(stringArray[i2]), true);
            }
        } else {
            objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
        }
        return objectArray;
    }

    protected final GeneSet[] _getGeneSets() {
        Object[] objectArray = this._getObjects();
        if (this.isReqd() && objectArray.length == 0) {
            throw new IllegalArgumentException("Must specify GeneSetMatrix parameter: " + this.getName());
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] instanceof GeneSetMatrix) {
                arrayList.addAll(((GeneSetMatrix)objectArray[i2]).getGeneSetsL());
                continue;
            }
            if (objectArray[i2] instanceof GeneSet) {
                arrayList.add(objectArray[i2]);
                continue;
            }
            if (objectArray[i2] instanceof RankedList) {
                arrayList.add(new FSet(((RankedList)objectArray[i2]).getName(), ((RankedList)objectArray[i2]).getRankedNames(), false));
                continue;
            }
            if (objectArray[i2] instanceof Dataset) {
                arrayList.add(((Dataset)objectArray[i2]).getRowNamesGeneSet());
                continue;
            }
            if (objectArray[i2] instanceof Chip) {
                arrayList.add(((Chip)objectArray[i2]).getProbeNamesAsGeneSet());
                continue;
            }
            if (objectArray[i2] instanceof GenesOfInterest) {
                arrayList.add(((GenesOfInterest)objectArray[i2]).getAsOneGeneSet());
                continue;
            }
            throw new IllegalArgumentException("Unknown object: " + objectArray[i2]);
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    @Override
    public void setValue(String[] stringArray) {
        try {
            GeneSet[] geneSetArray = new GeneSet[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                geneSetArray[i2] = ParserFactory.readGeneSet(new File(stringArray[i2]), true);
            }
            super.setValue(geneSetArray);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static String[] _parse(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter s cannot be null");
        }
        Set set = ParseUtils.string2stringsSet(string, ",", false);
        System.out.println("to parse>" + string + "< got: " + set);
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            if (string2.length() <= 0) continue;
            hashSet.add(string2);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    public void setValue(String string) {
        this.setValue(GeneSetChooserAbstractParam._parse(string));
    }

    protected static final String format(Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            if (objectArray[i2] instanceof PersistentObject) {
                String string = ParserFactory.getCache().getSourcePath(objectArray[i2]);
                stringBuffer.append(string);
            } else {
                stringBuffer.append(objectArray[i2].toString().trim());
            }
            if (i2 == objectArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    @Override
    protected final ActionListener getActionListener() {
        if (this.fAl == null) {
            this.fAl = new GeneSetChooserAbstractParam$MyPobActionListener(this.fMultipleAllowed);
            this.fAl.setChooser(this.fPlusChooser);
        }
        return this.fAl;
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    @Override
    public String getValueStringRepresentation(boolean bl) {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return GeneSetChooserAbstractParam.format(objectArray);
        }
        return GeneSetChooserAbstractParam.format(new Object[]{object});
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fPlusChooser == null) {
            int n = this.fMultipleAllowed ? 2 : 0;
            this.fPlusChooser = new GeneSetFieldPlusChooser(false, n);
            this.fPlusChooser.setCustomActionListener(this.getActionListener());
            String string = this.getValueStringRepresentation(false);
            if (string == null) {
                string = GeneSetChooserAbstractParam.format((Object[])this.getDefault());
            }
            if (this.isFileBased()) {
                // empty if block
            }
            this.fPlusChooser.setText(string);
            ParamHelper.addDocumentListener(this.fPlusChooser.getTextField(), this);
        }
        return this.fPlusChooser;
    }
}

