/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.math.XMath;
import edu.mit.broad.genome.parsers.ParseUtils;
import gnu.trove.TIntArrayList;
import xtools.api.param.AbstractObjectChooserParam;

public class IntegersChooserParam
extends AbstractObjectChooserParam {
    public IntegersChooserParam(String string, String string2, Integer n, boolean bl) {
        this(string, string2, new Integer[]{n}, new Integer[]{n}, bl);
    }

    public IntegersChooserParam(String string, String string2, String string3, Integer n, boolean bl) {
        this(string, string2, string3, new Integer[]{n}, new Integer[]{n}, bl);
    }

    public IntegersChooserParam(String string, String string2, boolean bl) {
        this(string, string2, new Integer[0], new Integer[0], bl);
    }

    public IntegersChooserParam(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, new Integer[0], new Integer[0], bl);
    }

    public IntegersChooserParam(String string, String string2, Integer[] integerArray, Integer[] integerArray2, boolean bl) {
        super(string, Integer.class, string2, (Object[])integerArray, (Object[])integerArray2, bl);
    }

    public IntegersChooserParam(String string, String string2, String string3, Integer[] integerArray, Integer[] integerArray2, boolean bl) {
        super(string, string2, Integer.class, string3, (Object[])integerArray, (Object[])integerArray2, bl);
    }

    public IntegersChooserParam(String string, String string2, Integer[] integerArray, boolean bl) {
        this(string, string2, integerArray, integerArray, bl);
    }

    public IntegersChooserParam(String string, String string2, int[] nArray, boolean bl) {
        this(string, string2, IntegersChooserParam.toIntegers(nArray), bl);
    }

    private static Integer[] toIntegers(int[] nArray) {
        Integer[] integerArray = new Integer[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            integerArray[i2] = new Integer(nArray[i2]);
        }
        return integerArray;
    }

    @Override
    public final void setValue(Object object) {
        if (object == null) {
            super.setValue(object);
        } else if (object instanceof Integer[]) {
            super.setValue(object);
        } else if (object instanceof String) {
            super.setValue(this._parse((String)object));
        } else {
            throw new IllegalArgumentException("Invalid type, only Integer[] and comma-delimited parsable string accepted. Specified: " + object + " class: " + object.getClass());
        }
    }

    @Override
    public final boolean isFileBased() {
        return false;
    }

    private Integer[] _parse(String string) {
        return ParseUtils.string2Ints(string);
    }

    @Override
    public final void setValue(String string) {
        super.setValue(this._parse(string));
    }

    @Override
    public final void setValue(String[] stringArray) {
        super.setValue(stringArray);
    }

    public final Integer[] getInts() {
        Object object = super.getValue();
        if (object == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        return (Integer[])object;
    }

    public final int[] getInts2() {
        Integer[] integerArray = this.getInts();
        int[] nArray = new int[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            nArray[i2] = integerArray[i2];
        }
        return nArray;
    }

    public final boolean isSpecified(int n) {
        TIntArrayList tIntArrayList = new TIntArrayList(this.getInts2());
        return tIntArrayList.contains(n);
    }

    public final int getMax() {
        return XMath.max(this.getInts2());
    }

    public final int getMin() {
        return XMath.min(this.getInts2());
    }

    public final int getInt2(int n) {
        return this.getInt(n);
    }

    public final Integer getInt(int n) {
        Object object = super.getValue();
        if (object == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        return ((Integer[])object)[n];
    }

    @Override
    public final String getValueStringRepresentation(boolean bl) {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        Object[] objectArray = (Integer[])object;
        return IntegersChooserParam.format(objectArray);
    }
}

