/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.ui;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.core.api.DialogDescriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import xtools.api.ui.NamedModel;

public class GeneSetMatrixChooserWindow {
    private static final Logger klog = XLogger.getLogger(GeneSetMatrixChooserWindow.class);
    private JList[] jlGenes;
    private final JTextArea taGenes = new JTextArea();
    private NamedModel[] fModels;
    private int fSelectionMode = 0;
    private JTabbedPane tab;

    public final Object[] show() {
        int n;
        if (this.jlGenes == null) {
            return null;
        }
        for (n = 0; n < this.jlGenes.length; ++n) {
            this.jlGenes[n].setModel(this.fModels[n].model);
            this.jlGenes[n].setSelectionMode(this.fSelectionMode);
        }
        for (n = 0; n < this.jlGenes.length; ++n) {
        }
        return this._just_show();
    }

    public final Object[] showDirectlyWithModels(NamedModel[] namedModelArray, int n, DefaultListCellRenderer defaultListCellRenderer) {
        int n2;
        this.fModels = namedModelArray;
        if (this.jlGenes == null) {
            this.jlGenes = new JList[namedModelArray.length];
            for (n2 = 0; n2 < namedModelArray.length; ++n2) {
                this.jlGenes[n2] = new JList();
                this.jlGenes[n2].setCellRenderer(defaultListCellRenderer);
            }
        }
        this.fSelectionMode = n;
        for (n2 = 0; n2 < namedModelArray.length; ++n2) {
            this.jlGenes[n2].setModel(namedModelArray[n2].model);
            this.jlGenes[n2].setSelectionMode(n);
        }
        return this._just_show();
    }

    private Object[] _just_show() {
        Object[] objectArray;
        int n;
        String string = "Select a gene set";
        if (this.fSelectionMode == 2) {
            string = "Select one or more gene sets(s)";
        }
        this.taGenes.setText("");
        this.taGenes.setBorder(BorderFactory.createTitledBorder("Make an 'on-the-fly' gene set: Enter features below, one per line"));
        if (this.tab == null) {
            this.tab = new JTabbedPane();
            for (int i2 = 0; i2 < this.jlGenes.length; ++i2) {
                this.tab.addTab(this.fModels[i2].name, new JScrollPane(this.jlGenes[i2]));
            }
            this.tab.addTab("Text entry", new JScrollPane(this.taGenes));
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.tab, "Center");
        DialogDescriptor dialogDescriptor = Application.getWindowManager().createDialogDescriptor(string, jPanel, JarResources.createHelpAction("gmx"));
        for (n = 0; n < this.jlGenes.length; ++n) {
            dialogDescriptor.enableDoubleClickableJList(this.jlGenes[n]);
        }
        n = dialogDescriptor.show();
        if (n == 2) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i3 = 0; i3 < this.jlGenes.length; ++i3) {
            objectArray = this.jlGenes[i3].getSelectedValues();
            if (objectArray == null) continue;
            for (int i4 = 0; i4 < objectArray.length; ++i4) {
                if (objectArray[i4] == null) continue;
                arrayList.add(objectArray[i4]);
            }
        }
        String string2 = this.taGenes.getText();
        if (string2 != null && (objectArray = ParseUtils.string2strings(string2, "\t\n", false)).length != 0) {
            FSet fSet = new FSet("from_text_entry_", (String[])objectArray);
            try {
                ParserFactory.save(fSet, File.createTempFile(fSet.getName(), ".grp"));
            }
            catch (Throwable throwable) {
                klog.error(throwable);
            }
            arrayList.add(fSet);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    public final void setListSelectionMode(int n) {
        this.fSelectionMode = n;
        if (this.jlGenes == null) {
            return;
        }
        for (int i2 = 0; i2 < this.jlGenes.length; ++i2) {
            this.jlGenes[i2].setSelectionMode(this.fSelectionMode);
        }
    }
}

