/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;

public abstract class AbstractFTPInputStream
extends FileTransferInputStream {
    private static Logger log = Logger.getLogger("AbstractFTPInputStream");
    protected FTPClient client;
    protected BufferedInputStream in;

    public AbstractFTPInputStream(FTPClient fTPClient, String string) {
        this.client = fTPClient;
        this.remoteFile = string;
        this.monitorInterval = fTPClient.getMonitorInterval();
        this.monitor = fTPClient.getProgressMonitor();
    }

    protected void start() {
        this.start(true);
    }

    protected final void start(boolean bl) {
        try {
            if (this.pos > 0L) {
                this.client.resumeNextDownload(this.pos);
            }
            this.client.initGet(this.remoteFile);
            this.in = new BufferedInputStream(new DataInputStream(this.client.getInputStream()));
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
        catch (IOException iOException) {
            try {
                this.client.validateTransferOnError(iOException);
            }
            catch (FTPException fTPException) {
                throw new IOException(fTPException.getMessage());
            }
            throw iOException;
        }
        if (bl && this.monitorEx != null) {
            this.monitorEx.transferStarted(TransferDirection.DOWNLOAD, this.remoteFile);
        }
        this.started = true;
        this.closed = false;
        this.monitorCount = 0L;
    }

    public final void close() {
        if (!this.closed) {
            this.closed = true;
            this.client.forceResumeOff();
            this.client.closeDataSocket(this.in);
            if (this.monitor != null) {
                this.monitor.bytesTransferred(this.pos);
            }
            log.debug("Transferred " + this.pos + " bytes from remote host");
            try {
                this.client.readReply();
            }
            catch (FTPException fTPException) {
                throw new IOException(fTPException.getMessage());
            }
            if (this.monitorEx != null) {
                this.monitorEx.transferComplete(TransferDirection.DOWNLOAD, this.remoteFile);
            }
        }
    }
}

