/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import java.text.SimpleDateFormat;
import java.util.Date;

public class FTPFile {
    protected static final String cvsId = "@(#)$Id: FTPFile.java,v 1.20 2010-03-25 04:03:32 bruceb Exp $";
    public static final int UNKNOWN = -1;
    public static final int WINDOWS = 0;
    public static final int UNIX = 1;
    public static final int VMS = 2;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy HH:mm");
    private int type;
    protected boolean isLink = false;
    protected int linkCount = 1;
    protected String permissions;
    protected boolean isDir = false;
    protected long size = 0L;
    protected String name;
    protected String linkedname;
    protected String owner;
    protected String group;
    protected Date lastModified;
    protected Date created;
    protected String raw;
    protected String path;
    private FTPFile[] children;

    public FTPFile(int n, String string, String string2, long l2, boolean bl, Date date) {
        this(string);
        this.type = n;
        this.name = string2;
        this.size = l2;
        this.isDir = bl;
        this.lastModified = date;
    }

    public FTPFile(String string, String string2, long l2, boolean bl, Date date) {
        this(string);
        this.type = -1;
        this.name = string2;
        this.size = l2;
        this.isDir = bl;
        this.lastModified = date;
    }

    public FTPFile(String string) {
        this.raw = string;
    }

    public final FTPFile[] listFiles() {
        return this.children;
    }

    private final void setChildren(FTPFile[] fTPFileArray) {
        this.children = fTPFileArray;
    }

    public final int getType() {
        return this.type;
    }

    public final String getGroup() {
        return this.group;
    }

    public final boolean isDir() {
        return this.isDir;
    }

    public final boolean isFile() {
        return !this.isDir() && !this.isLink();
    }

    public final Date lastModified() {
        return this.lastModified;
    }

    public final void setLastModified(Date date) {
        this.lastModified = date;
    }

    public final Date created() {
        return this.created;
    }

    public final void setCreated(Date date) {
        this.created = date;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string;
    }

    public final String getOwner() {
        return this.owner;
    }

    public final String getRaw() {
        return this.raw;
    }

    public final long size() {
        return this.size;
    }

    public final void setSize(long l2) {
        this.size = l2;
    }

    public final String getPermissions() {
        return this.permissions;
    }

    public final boolean isLink() {
        return this.isLink;
    }

    public final int getLinkCount() {
        return this.linkCount;
    }

    public final String getLinkedname() {
        return this.linkedname;
    }

    public final String getLinkedName() {
        return this.linkedname;
    }

    public final void setGroup(String string) {
        this.group = string;
    }

    public final void setDir(boolean bl) {
        this.isDir = bl;
    }

    public final void setLink(boolean bl) {
        this.isLink = bl;
    }

    public final void setLinkedName(String string) {
        this.linkedname = string;
    }

    public final void setOwner(String string) {
        this.owner = string;
    }

    public final void setPermissions(String string) {
        this.permissions = string;
    }

    public final void setLinkCount(int n) {
        this.linkCount = n;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.raw).append("\n");
        stringBuffer.append("Name=").append(this.name).append(",").append("Size=").append(this.size).append(",").append("Permissions=").append(this.permissions).append(",").append("Owner=").append(this.owner).append(",").append("Group=").append(this.group).append(",").append("Is link=").append(this.isLink).append(",").append("Link count=").append(this.linkCount).append(".").append("Is dir=").append(this.isDir).append(",").append("Linked name=").append(this.linkedname).append(",").append("Last modified=").append(this.lastModified != null ? formatter.format(this.lastModified) : "null");
        if (this.created != null) {
            stringBuffer.append(",").append("Created=").append(formatter.format(this.created));
        }
        return stringBuffer.toString();
    }

    public final String getPath() {
        return this.path;
    }

    public final void setPath(String string) {
        this.path = string;
    }
}

