/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.AdvancedFTPSettings;
import com.enterprisedt.net.ftp.AdvancedGeneralSettings;
import com.enterprisedt.net.ftp.AutoCloseFileTransferInputStream;
import com.enterprisedt.net.ftp.AutoCloseFileTransferOutputStream;
import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.EventListener;
import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPInputStream;
import com.enterprisedt.net.ftp.FTPOutputStream;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileStatistics;
import com.enterprisedt.net.ftp.FileTransferClientInterface;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.WriteMode;
import com.enterprisedt.net.ftp.internal.ConnectionContext;
import com.enterprisedt.net.ftp.internal.EventAggregator;
import com.enterprisedt.util.debug.Logger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class FileTransferClient
implements FileTransferClientInterface {
    private static Logger log = Logger.getLogger("FileTransferClient");
    protected ConnectionContext masterContext = new ConnectionContext();
    protected EventAggregator eventAggregator = null;
    protected EventListener listener;
    private FTPClient ftpClient = new FTPClient();
    private AdvancedFTPSettings advancedFTPSettings = new AdvancedFTPSettings(this.masterContext);
    private AdvancedGeneralSettings advancedSettings = new AdvancedGeneralSettings(this.masterContext);
    private FileStatistics statistics = new FileStatistics();

    public FileTransferClient() {
        this.statistics.addClient(this.ftpClient);
    }

    protected final void checkConnection(boolean bl) {
        if (bl && !this.isConnected()) {
            throw new FTPException("The file transfer client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!bl && this.isConnected()) {
            throw new FTPException("The file transfer client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    public final synchronized boolean isConnected() {
        return this.ftpClient.connected();
    }

    public final synchronized String getRemoteHost() {
        return this.masterContext.getRemoteHost();
    }

    public final synchronized void setRemoteHost(String string) {
        this.checkConnection(false);
        this.masterContext.setRemoteHost(string);
    }

    public final synchronized int getTimeout() {
        return this.masterContext.getTimeout();
    }

    public final synchronized void setTimeout(int n) {
        this.checkConnection(false);
        this.masterContext.setTimeout(n);
    }

    public final synchronized int getNetworkBufferSize() {
        return this.masterContext.getNetworkBufferSize();
    }

    public final synchronized void setNetworkBufferSize(int n) {
        this.checkConnection(false);
        this.masterContext.setNetworkBufferSize(n);
    }

    public final synchronized int getRemotePort() {
        return this.masterContext.getRemotePort();
    }

    public final synchronized void setRemotePort(int n) {
        this.checkConnection(false);
        this.masterContext.setRemotePort(n);
    }

    public final synchronized void setContentType(FTPTransferType fTPTransferType) {
        this.masterContext.setContentType(fTPTransferType);
        if (this.ftpClient != null && this.ftpClient.connected()) {
            this.ftpClient.setType(fTPTransferType);
        }
    }

    public final synchronized FTPTransferType getContentType() {
        return this.masterContext.getContentType();
    }

    public final void setDetectContentType(boolean bl) {
        this.masterContext.setDetectContentType(bl);
        if (this.ftpClient != null) {
            this.ftpClient.setDetectTransferMode(bl);
        }
    }

    public final boolean isDetectContentType() {
        return this.masterContext.getDetectContentType();
    }

    public final synchronized void setUserName(String string) {
        this.checkConnection(false);
        this.masterContext.setUserName(string);
    }

    public final synchronized String getPassword() {
        return this.masterContext.getPassword();
    }

    public final synchronized void setPassword(String string) {
        this.checkConnection(false);
        this.masterContext.setPassword(string);
    }

    public final synchronized String getUserName() {
        return this.masterContext.getUserName();
    }

    public final synchronized AdvancedFTPSettings getAdvancedFTPSettings() {
        return this.advancedFTPSettings;
    }

    public final synchronized AdvancedGeneralSettings getAdvancedSettings() {
        return this.advancedSettings;
    }

    public final synchronized void setEventListener(EventListener eventListener) {
        this.listener = eventListener;
        this.eventAggregator = new EventAggregator(eventListener);
        if (this.ftpClient != null) {
            this.eventAggregator.setConnId(this.ftpClient.getId());
            this.ftpClient.setMessageListener(this.eventAggregator);
            this.ftpClient.setProgressMonitor(this.eventAggregator);
            this.ftpClient.setProgressMonitorEx(this.eventAggregator);
        }
    }

    public final synchronized void connect() {
        if (this.eventAggregator != null) {
            this.eventAggregator.setConnId(this.ftpClient.getId());
            this.ftpClient.setMessageListener(this.eventAggregator);
            this.ftpClient.setProgressMonitor(this.eventAggregator);
            this.ftpClient.setProgressMonitorEx(this.eventAggregator);
        }
        this.statistics.clear();
        this.configureClient();
        log.debug("Configured client");
        this.ftpClient.connect();
        log.debug("Client connected");
        if (this.masterContext.isAutoLogin()) {
            log.debug("Logging in");
            this.ftpClient.login(this.masterContext.getUserName(), this.masterContext.getPassword());
            log.debug("Logged in");
            this.configureTransferType(this.masterContext.getContentType());
        } else {
            log.debug("Manual login enabled");
        }
    }

    public final void manualLogin() {
        this.checkConnection(true);
        log.debug("Logging in");
        this.ftpClient.login(this.masterContext.getUserName(), this.masterContext.getPassword());
        log.debug("Logged in");
        this.configureTransferType(this.masterContext.getContentType());
    }

    private void configureClient() {
        this.ftpClient.setRemoteHost(this.masterContext.getRemoteHost());
        this.ftpClient.setRemotePort(this.masterContext.getRemotePort());
        this.ftpClient.setTimeout(this.masterContext.getTimeout());
        this.ftpClient.setNetworkBufferSize(this.masterContext.getNetworkBufferSize());
        this.ftpClient.setRetryCount(this.masterContext.getRetryCount());
        this.ftpClient.setRetryDelay(this.masterContext.getRetryDelay());
        this.ftpClient.setControlEncoding(this.masterContext.getControlEncoding());
        this.ftpClient.setStrictReturnCodes(this.masterContext.isStrictReturnCodes());
        this.ftpClient.setDetectTransferMode(this.masterContext.getDetectContentType());
        this.ftpClient.setFileLockingEnabled(this.masterContext.getFileLockingEnabled());
        this.ftpClient.setConnectMode(this.masterContext.getConnectMode());
        this.ftpClient.setParserLocales(this.masterContext.getParserLocales());
        this.ftpClient.setAutoPassiveIPSubstitution(this.masterContext.isAutoPassiveIPSubstitution());
        this.ftpClient.setDeleteOnFailure(this.masterContext.isDeleteOnFailure());
        this.ftpClient.setActiveIPAddress(this.masterContext.getActiveIPAddress());
        this.ftpClient.setMonitorInterval(this.masterContext.getTransferNotifyInterval());
        this.ftpClient.setTransferBufferSize(this.masterContext.getTransferBufferSize());
        this.ftpClient.setFileNotFoundMessages(this.masterContext.getFileNotFoundMessages());
        this.ftpClient.setDirectoryEmptyMessages(this.masterContext.getDirectoryEmptyMessages());
        this.ftpClient.setTransferCompleteMessages(this.masterContext.getTransferCompleteMessages());
        if (this.masterContext.getActiveHighPort() >= 0 && this.masterContext.getActiveLowPort() >= 0) {
            this.ftpClient.setActivePortRange(this.masterContext.getActiveLowPort(), this.masterContext.getActiveHighPort());
        }
    }

    private void configureTransferType(FTPTransferType fTPTransferType) {
        this.ftpClient.setDetectTransferMode(this.masterContext.getDetectContentType());
        this.ftpClient.setType(fTPTransferType);
    }

    private void checkTransferSettings() {
        if (this.ftpClient.getDetectTransferMode() != this.masterContext.getDetectContentType()) {
            this.ftpClient.setDetectTransferMode(this.masterContext.getDetectContentType());
        }
        if (this.ftpClient.isStrictReturnCodes() != this.masterContext.isStrictReturnCodes()) {
            this.ftpClient.setStrictReturnCodes(this.masterContext.isStrictReturnCodes());
        }
        if (!this.ftpClient.getConnectMode().equals(this.masterContext.getConnectMode())) {
            this.ftpClient.setConnectMode(this.masterContext.getConnectMode());
        }
        if (this.ftpClient.isAutoPassiveIPSubstitution() != this.masterContext.isAutoPassiveIPSubstitution()) {
            this.ftpClient.setAutoPassiveIPSubstitution(this.masterContext.isAutoPassiveIPSubstitution());
        }
        if (this.ftpClient.isDeleteOnFailure() != this.masterContext.isDeleteOnFailure()) {
            this.ftpClient.setDeleteOnFailure(this.masterContext.isDeleteOnFailure());
        }
        if (this.ftpClient.getActiveIPAddress() != this.masterContext.getActiveIPAddress()) {
            this.ftpClient.setActiveIPAddress(this.masterContext.getActiveIPAddress());
        }
        if (this.ftpClient.getTransferBufferSize() != this.masterContext.getTransferBufferSize()) {
            this.ftpClient.setTransferBufferSize(this.masterContext.getTransferBufferSize());
        }
        if (this.ftpClient.getMonitorInterval() != (long)this.masterContext.getTransferNotifyInterval()) {
            this.ftpClient.setMonitorInterval(this.masterContext.getTransferNotifyInterval());
        }
        if (this.masterContext.getActiveHighPort() != this.ftpClient.getActiveHighPort() || this.masterContext.getActiveLowPort() != this.ftpClient.getActiveLowPort()) {
            this.ftpClient.setActivePortRange(this.masterContext.getActiveLowPort(), this.masterContext.getActiveHighPort());
        }
    }

    private void checkListingSettings() {
        this.ftpClient.setParserLocales(this.masterContext.getParserLocales());
        this.checkTransferSettings();
    }

    protected static final void prepareURLTransfer(URL uRL, FileTransferClientInterface fileTransferClientInterface) {
        String string;
        String string2;
        int n;
        if (!uRL.getProtocol().equals("ftp")) {
            throw new MalformedURLException("Unsupported protocol: " + uRL.getProtocol());
        }
        fileTransferClientInterface.setRemoteHost(uRL.getHost());
        if (uRL.getPort() > 0) {
            fileTransferClientInterface.setRemotePort(uRL.getPort());
        }
        String string3 = uRL.getUserInfo();
        String string4 = "anonymous";
        String string5 = "";
        if (string3 != null) {
            int n2 = string3.indexOf(58);
            if (n2 >= 0) {
                string4 = string3.substring(0, n2);
                if (n2 + 1 < string3.length() - 1) {
                    string5 = string3.substring(n2 + 1);
                }
            } else {
                string4 = string3;
            }
        }
        fileTransferClientInterface.setUserName(string4);
        fileTransferClientInterface.setPassword(string5);
        fileTransferClientInterface.setDetectContentType(true);
        if (uRL.getQuery() != null && (n = (string2 = uRL.getQuery()).indexOf(string = "type=")) >= 0 && string2.length() > n + string.length()) {
            char c2 = string2.toUpperCase().charAt(n + string.length());
            if (c2 == FTPTransferType.BINARY_CHAR.charAt(0)) {
                fileTransferClientInterface.setContentType(FTPTransferType.BINARY);
                fileTransferClientInterface.setDetectContentType(true);
            } else if (c2 == FTPTransferType.ASCII_CHAR.charAt(0)) {
                fileTransferClientInterface.setContentType(FTPTransferType.ASCII);
                fileTransferClientInterface.setDetectContentType(true);
            } else {
                throw new MalformedURLException("Unknown type: " + string2.substring(n));
            }
        }
    }

    public final synchronized FileStatistics getStatistics() {
        return this.statistics;
    }

    public final synchronized String executeCommand(String string) {
        return this.ftpClient.quote(string);
    }

    public final void cancelAllTransfers() {
        log.debug("cancelAllTransfers() called");
        this.ftpClient.cancelTransfer();
    }

    public final FTPReply getLastReply() {
        return this.ftpClient.getLastReply();
    }

    public final synchronized String getSystemType() {
        return this.ftpClient.system();
    }

    public final synchronized String[] directoryNameList() {
        return this.directoryNameList("", false);
    }

    public final synchronized String[] directoryNameList(String string, boolean bl) {
        this.checkListingSettings();
        return this.ftpClient.dir(string, bl);
    }

    public final synchronized FTPFile[] directoryList() {
        return this.directoryList("");
    }

    public final synchronized FTPFile[] directoryList(String string) {
        this.checkListingSettings();
        return this.ftpClient.dirDetails(string);
    }

    public final synchronized void directoryList(String string, DirectoryListCallback directoryListCallback) {
        this.checkListingSettings();
        this.ftpClient.dirDetails(string, directoryListCallback);
    }

    public final synchronized byte[] downloadByteArray(String string) {
        this.checkTransferSettings();
        return this.ftpClient.get(string);
    }

    public final synchronized void downloadFile(String string, String string2) {
        this.downloadFile(string, string2, WriteMode.OVERWRITE);
    }

    public final synchronized void downloadFile(String string, String string2, WriteMode writeMode) {
        this.checkTransferSettings();
        if (writeMode.equals(WriteMode.RESUME)) {
            this.ftpClient.resume();
        } else if (writeMode.equals(WriteMode.APPEND)) {
            throw new FTPException("Append not permitted for downloads");
        }
        this.ftpClient.get(string, string2);
    }

    public static final FileTransferInputStream downloadURLStream(String string) {
        URL uRL = new URL(string);
        if (!uRL.getProtocol().equals("ftp")) {
            throw new MalformedURLException("Unsupported protocol: " + uRL.getProtocol());
        }
        FileTransferClient fileTransferClient = new FileTransferClient();
        FileTransferClient.prepareURLTransfer(uRL, fileTransferClient);
        fileTransferClient.connect();
        return new AutoCloseFileTransferInputStream(fileTransferClient.downloadStream(uRL.getPath()), fileTransferClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void downloadURLFile(String string, String string2) {
        URL uRL = new URL(string2);
        FileTransferClient fileTransferClient = new FileTransferClient();
        if (!uRL.getProtocol().equals("ftp")) {
            throw new MalformedURLException("Unsupported protocol: " + uRL.getProtocol());
        }
        FileTransferClient.prepareURLTransfer(uRL, fileTransferClient);
        fileTransferClient.connect();
        try {
            fileTransferClient.downloadFile(string, uRL.getPath());
            Object var5_4 = null;
            fileTransferClient.disconnect();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileTransferClient.disconnect();
            throw throwable;
        }
    }

    public final synchronized FileTransferInputStream downloadStream(String string) {
        this.checkTransferSettings();
        return new FTPInputStream(this.ftpClient, string);
    }

    public final synchronized String uploadFile(String string, String string2) {
        return this.uploadFile(string, string2, WriteMode.OVERWRITE);
    }

    public final synchronized String uploadFile(String string, String string2, WriteMode writeMode) {
        this.checkTransferSettings();
        boolean bl = false;
        if (writeMode.equals(WriteMode.RESUME)) {
            this.ftpClient.resume();
        } else if (writeMode.equals(WriteMode.APPEND)) {
            bl = true;
        }
        return this.ftpClient.put(string, string2, bl);
    }

    public final synchronized FileTransferOutputStream uploadStream(String string) {
        return this.uploadStream(string, WriteMode.OVERWRITE);
    }

    public final synchronized FileTransferOutputStream uploadStream(String string, WriteMode writeMode) {
        this.checkTransferSettings();
        if (WriteMode.RESUME.equals(writeMode)) {
            throw new FTPException("Resume not supported for stream uploads");
        }
        boolean bl = WriteMode.APPEND.equals(writeMode);
        return new FTPOutputStream(this.ftpClient, string, bl);
    }

    public static final FileTransferOutputStream uploadURLStream(String string) {
        URL uRL = new URL(string);
        FileTransferClient fileTransferClient = new FileTransferClient();
        if (!uRL.getProtocol().equals("ftp")) {
            throw new MalformedURLException("Unsupported protocol: " + uRL.getProtocol());
        }
        FileTransferClient.prepareURLTransfer(uRL, fileTransferClient);
        fileTransferClient.connect();
        return new AutoCloseFileTransferOutputStream(fileTransferClient.uploadStream(uRL.getPath()), fileTransferClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void uploadURLFile(String string, String string2) {
        URL uRL = new URL(string2);
        FileTransferClient fileTransferClient = new FileTransferClient();
        FileTransferClient.prepareURLTransfer(uRL, fileTransferClient);
        fileTransferClient.connect();
        try {
            fileTransferClient.uploadFile(string, uRL.getPath());
            Object var5_4 = null;
            fileTransferClient.disconnect();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            fileTransferClient.disconnect();
            throw throwable;
        }
    }

    public final synchronized long getSize(String string) {
        return this.ftpClient.size(string);
    }

    public final synchronized Date getModifiedTime(String string) {
        return this.ftpClient.modtime(string);
    }

    public final synchronized void setModifiedTime(String string, Date date) {
        this.ftpClient.setModTime(string, date);
    }

    public final synchronized boolean exists(String string) {
        return this.ftpClient.exists(string);
    }

    public final synchronized void deleteFile(String string) {
        this.ftpClient.delete(string);
    }

    public final synchronized void rename(String string, String string2) {
        this.ftpClient.rename(string, string2);
    }

    public final synchronized void changeDirectory(String string) {
        this.ftpClient.chdir(string);
    }

    public final synchronized void changeToParentDirectory() {
        this.ftpClient.cdup();
    }

    public final synchronized String getRemoteDirectory() {
        return this.ftpClient.pwd();
    }

    public final synchronized void createDirectory(String string) {
        this.ftpClient.mkdir(string);
    }

    public final synchronized void deleteDirectory(String string) {
        this.ftpClient.rmdir(string);
    }

    public final synchronized void disconnect() {
        this.ftpClient.quit();
    }

    public final synchronized void disconnect(boolean bl) {
        if (bl) {
            this.ftpClient.quitImmediately();
        } else {
            this.ftpClient.quit();
        }
    }
}

