/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class NetwareFileParser
extends FTPFileParser {
    public static final String cvsId = "@(#)$Id: NetwareFileParser.java,v 1.2 2010-03-31 00:54:48 bruceb Exp $";
    private static Logger log = Logger.getLogger("NetwareFileParser");
    private static final char FILE_CHAR = '-';
    private static final char DIRECTORY_CHAR = 'd';
    private static final String CURRENT_DIR_PREFIX = "./";
    private SimpleDateFormat dateFormatter;
    private static final int MIN_FIELD_COUNT = 8;

    public NetwareFileParser() {
        this.setLocale(Locale.getDefault());
    }

    public final void setLocale(Locale locale) {
        this.dateFormatter = new SimpleDateFormat("MMM-dd-yyyy-HH:mm", locale);
    }

    public final String toString() {
        return "NETWARE";
    }

    public final boolean isValidFormat(String[] stringArray) {
        int n = Math.min(stringArray.length, 10);
        for (int i2 = 0; i2 < n; ++i2) {
            if (stringArray[i2].trim().length() == 0 || !NetwareFileParser.isNetware(stringArray[i2])) continue;
            return true;
        }
        log.debug("Not in Netware format");
        return false;
    }

    public static final boolean isNetware(String string) {
        if ((string = string.trim()).length() < 3) {
            return false;
        }
        char c2 = string.charAt(0);
        char c3 = string.charAt(2);
        return (c2 == '-' || c2 == 'd') && c3 == '[';
    }

    public final FTPFile parse(String string) {
        Date date;
        Calendar calendar;
        long l2;
        String string2;
        String string3;
        boolean bl;
        block13: {
            if (!NetwareFileParser.isNetware(string)) {
                return null;
            }
            String[] stringArray = this.split(string);
            if (stringArray.length < 8) {
                StringBuffer stringBuffer = new StringBuffer("Unexpected number of fields in listing '");
                stringBuffer.append(string).append("' - expected minimum ").append(8).append(" fields but found ").append(stringArray.length).append(" fields");
                log.warn(stringBuffer.toString());
                return null;
            }
            int n = 0;
            bl = false;
            char c2 = string.charAt(0);
            if (c2 == 'd') {
                bl = true;
            }
            if ((string3 = stringArray[++n]).charAt(0) == '[' && string3.charAt(string3.length() - 1) == ']') {
                string3 = string3.substring(1);
                string3 = string3.substring(0, string3.length() - 1);
            }
            string2 = stringArray[++n];
            l2 = 0L;
            String string4 = stringArray[++n];
            try {
                l2 = Long.parseLong(string4);
            }
            catch (NumberFormatException numberFormatException) {
                log.warn("Failed to parse size: " + string4);
            }
            String string5 = stringArray[++n];
            String string6 = stringArray[++n];
            String string7 = stringArray[++n];
            String string8 = "00:00";
            calendar = Calendar.getInstance();
            if (string7.indexOf(58) > 0) {
                string8 = string7;
                string7 = Integer.toString(calendar.get(1));
            }
            StringBuffer stringBuffer = new StringBuffer(string5);
            stringBuffer.append('-');
            stringBuffer.append(string6);
            stringBuffer.append('-');
            stringBuffer.append(string7);
            stringBuffer.append('-');
            stringBuffer.append(string8);
            date = null;
            try {
                date = this.dateFormatter.parse(stringBuffer.toString());
            }
            catch (ParseException parseException) {
                if (this.ignoreDateParseErrors) break block13;
                throw new DateParseException(parseException.getMessage());
            }
        }
        calendar.add(5, 2);
        if (date != null && date.after(calendar.getTime())) {
            calendar.setTime(date);
            calendar.add(1, -1);
            date = calendar.getTime();
        }
        String string9 = string.trim();
        for (int i2 = 0; i2 < 7; ++i2) {
            int n = string9.indexOf(32);
            if (n <= 0) {
                string9 = null;
                log.debug("Failed to extract filename");
                break;
            }
            string9 = string9.substring(n).trim();
        }
        if (string9.startsWith(CURRENT_DIR_PREFIX)) {
            string9 = string9.substring(CURRENT_DIR_PREFIX.length());
        }
        FTPFile fTPFile = new FTPFile(string, string9, l2, bl, date);
        fTPFile.setOwner(string2);
        fTPFile.setPermissions(string3);
        return fTPFile;
    }
}

