/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.DateParseException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPFileParser;
import com.enterprisedt.util.debug.Logger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class OS400FileParser
extends FTPFileParser {
    private static final String DIR = "*DIR";
    private static final String DDIR = "*DDIR";
    private static final String MEM = "*MEM";
    private static final int MIN_EXPECTED_FIELD_COUNT = 6;
    private static final String DATE_FORMAT_1 = "dd'/'MM'/'yy' 'HH':'mm':'ss";
    private static final String DATE_FORMAT_2 = "dd'.'MM'.'yy' 'HH':'mm':'ss";
    private static final String DATE_FORMAT_11 = "MM'/'dd'/'yy' 'HH':'mm':'ss";
    private static final String DATE_FORMAT_12 = "MM'.'dd'.'yy' 'HH':'mm':'ss";
    private static final String DATE_FORMAT_21 = "yy'/'MM'/'dd' 'HH':'mm':'ss";
    private static final String DATE_FORMAT_22 = "yy'.'MM'.'dd' 'HH':'mm':'ss";
    private static String[] formats1 = new String[]{"dd'/'MM'/'yy' 'HH':'mm':'ss", "dd'.'MM'.'yy' 'HH':'mm':'ss"};
    private static String[] formats2 = new String[]{"MM'/'dd'/'yy' 'HH':'mm':'ss", "MM'.'dd'.'yy' 'HH':'mm':'ss"};
    private static String[] formats3 = new String[]{"yy'/'MM'/'dd' 'HH':'mm':'ss", "yy'.'MM'.'dd' 'HH':'mm':'ss"};
    private String[][] formats = new String[][]{formats1, formats2, formats3};
    private static Logger log = Logger.getLogger("OS400FileParser");
    private int formatIndex = 0;
    private Locale locale = Locale.getDefault();

    public final void setLocale(Locale locale) {
        this.locale = locale;
    }

    public final String toString() {
        return "OS400";
    }

    public final boolean isValidFormat(String[] stringArray) {
        int n = Math.min(stringArray.length, 10);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        for (int i2 = 0; i2 < n; ++i2) {
            if (stringArray[i2].indexOf(DIR) > 0) {
                bl = true;
                continue;
            }
            if (stringArray[i2].indexOf("*FILE") > 0) {
                bl6 = true;
                continue;
            }
            if (stringArray[i2].indexOf("*FLR") > 0) {
                bl5 = true;
                continue;
            }
            if (stringArray[i2].indexOf(DDIR) > 0) {
                bl2 = true;
                continue;
            }
            if (stringArray[i2].indexOf("*STMF") > 0) {
                bl4 = true;
                continue;
            }
            if (stringArray[i2].indexOf("*LIB") > 0) {
                bl3 = true;
                continue;
            }
            if (stringArray[i2].indexOf(MEM) <= 0) continue;
            bl7 = true;
        }
        if (bl || bl6 || bl2 || bl3 || bl4 || bl5 || bl7) {
            return true;
        }
        log.debug("Not in OS/400 format");
        return false;
    }

    public final FTPFile parse(String string) {
        String[] stringArray = this.split(string);
        if (stringArray.length <= 0) {
            return null;
        }
        if (stringArray.length >= 2 && stringArray[1].equals(MEM)) {
            String string2 = stringArray[0];
            String string3 = stringArray[2];
            FTPFile fTPFile = new FTPFile(string, string3, 0L, false, null);
            fTPFile.setOwner(string2);
            return fTPFile;
        }
        if (stringArray.length < 6) {
            return null;
        }
        String string4 = stringArray[0];
        long l2 = 0L;
        try {
            l2 = Long.parseLong(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            log.warn("Failed to parse size: " + stringArray[1]);
        }
        String string5 = stringArray[2] + " " + stringArray[3];
        Date date = this.getLastModified(string5);
        boolean bl = false;
        if (stringArray[4] == DIR || stringArray[4] == DDIR) {
            bl = true;
        }
        int n = string.indexOf(stringArray[4]);
        String string6 = this.trimStart(string.substring(n += stringArray[4].length()));
        if (string6.endsWith("/")) {
            bl = true;
            string6 = string6.substring(0, string6.length() - 1);
        }
        FTPFile fTPFile = new FTPFile(string, string6, l2, bl, date);
        fTPFile.setOwner(string4);
        return fTPFile;
    }

    private Date getLastModified(String string) {
        Date date = null;
        if (this.formatIndex >= this.formats.length) {
            log.warn("Exhausted formats - failed to parse date");
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, 2);
        int n = this.formatIndex;
        int n2 = this.formatIndex;
        while (n2 < this.formats.length) {
            for (int i2 = 0; i2 < this.formats[n2].length; ++i2) {
                try {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.formats[this.formatIndex][i2], this.locale);
                    date = simpleDateFormat.parse(string);
                    if (!date.after(calendar.getTime())) {
                        return date;
                    }
                    log.debug("Swapping to alternate date format (found date in future)");
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            ++n2;
            ++this.formatIndex;
        }
        if (this.formatIndex >= this.formats.length) {
            log.warn("Exhausted formats - failed to parse date");
            return null;
        }
        if (this.formatIndex > n) {
            throw new DateParseException(null);
        }
        return date;
    }
}

