/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.debug;

import com.enterprisedt.BaseIOException;
import com.enterprisedt.util.debug.Appender;
import com.enterprisedt.util.debug.FileAppender;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.StandardOutputAppender;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class Logger {
    public static String cvsId = "@(#)$Id: Logger.java,v 1.29 2011-06-09 07:37:09 bruceb Exp $";
    private static Level globalLevel;
    private static boolean logThreadNames;
    private SimpleDateFormat format = new SimpleDateFormat("d MMM yyyy HH:mm:ss.SSS");
    private static Hashtable loggers;
    private static Vector appenders;
    private boolean useLog4j = false;
    private boolean logThreadName = false;
    private Date ts = new Date();
    private String clazz;
    private Method[][] logMethods = null;
    private Method toLevelMethod = null;
    private Method isEnabledForMethod = null;
    private Object logger = null;
    private Object[] argsPlain = new Object[1];
    private Object[] argsThrowable = new Object[2];
    private static String prefix;
    private static String[] hex;
    static Class class$java$lang$String;
    static Class class$java$lang$Object;
    static Class class$java$lang$Throwable;

    private Logger(String string, boolean bl) {
        this.clazz = string;
        this.useLog4j = bl;
        if (bl) {
            this.setupLog4j();
        }
    }

    private synchronized void setupLog4j() {
        this.logMethods = new Method[5][2];
        try {
            Class<?> clazz = Class.forName("org.apache.log4j.Logger");
            Class<?> clazz2 = Class.forName("org.apache.log4j.Level");
            Class<?> clazz3 = Class.forName("org.apache.log4j.Priority");
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Logger.class$("java.lang.String")) : class$java$lang$String};
            Method method = clazz.getMethod("getLogger", classArray);
            Object[] objectArray = new Object[]{this.clazz};
            this.logger = method.invoke(null, objectArray);
            Class[] classArray2 = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Logger.class$("java.lang.Object")) : class$java$lang$Object};
            Class[] classArray3 = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = Logger.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$Throwable == null ? (class$java$lang$Throwable = Logger.class$("java.lang.Throwable")) : class$java$lang$Throwable};
            this.logMethods[0][0] = clazz.getMethod("fatal", classArray2);
            this.logMethods[0][1] = clazz.getMethod("fatal", classArray3);
            this.logMethods[1][0] = clazz.getMethod("error", classArray2);
            this.logMethods[1][1] = clazz.getMethod("error", classArray3);
            this.logMethods[2][0] = clazz.getMethod("warn", classArray2);
            this.logMethods[2][1] = clazz.getMethod("warn", classArray3);
            this.logMethods[3][0] = clazz.getMethod("info", classArray2);
            this.logMethods[3][1] = clazz.getMethod("info", classArray3);
            this.logMethods[4][0] = clazz.getMethod("debug", classArray2);
            this.logMethods[4][1] = clazz.getMethod("debug", classArray3);
            Class[] classArray4 = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Logger.class$("java.lang.String")) : class$java$lang$String};
            this.toLevelMethod = clazz2.getMethod("toLevel", classArray4);
            Class[] classArray5 = new Class[]{clazz3};
            this.isEnabledForMethod = clazz.getMethod("isEnabledFor", classArray5);
        }
        catch (Exception exception) {
            this.useLog4j = false;
            this.error("Failed to initialize log4j logging", exception);
        }
    }

    public static final synchronized Level getLevel() {
        return globalLevel;
    }

    public static final synchronized void setLevel(Level level) {
        globalLevel = level;
    }

    public static final Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static final synchronized Logger getLogger(String string) {
        string = prefix + string;
        Logger logger = (Logger)loggers.get(string);
        if (logger == null) {
            boolean bl = false;
            try {
                String string2 = System.getProperty("edtftp.log.log4j");
                if (string2 != null && string2.equalsIgnoreCase("true")) {
                    bl = true;
                }
            }
            catch (SecurityException securityException) {
                System.out.println("Could not read property 'edtftp.log.log4j' due to security permissions");
            }
            logger = new Logger(string, bl);
            loggers.put(string, logger);
        }
        return logger;
    }

    public static final synchronized void addAppender(Appender appender) {
        if (!appenders.contains(appender)) {
            appenders.addElement(appender);
        }
    }

    public static final synchronized void addFileAppender(String string) {
        Logger.addAppender(new FileAppender(string));
    }

    public static final synchronized void addStandardOutputAppender() {
        Logger.addAppender(new StandardOutputAppender());
    }

    public static final synchronized void removeAppender(Appender appender) {
        appender.close();
        appenders.removeElement(appender);
    }

    public static final synchronized void clearAppenders() {
        appenders.removeAllElements();
    }

    public static final synchronized void shutdown() {
        for (int i2 = 0; i2 < appenders.size(); ++i2) {
            Appender appender = (Appender)appenders.elementAt(i2);
            appender.close();
        }
    }

    public static final synchronized void logThreadNames(boolean bl) {
        logThreadNames = bl;
    }

    public final synchronized void logThreadName(boolean bl) {
        this.logThreadName = bl;
    }

    public final synchronized void log(Level level, String string, Throwable throwable) {
        if (this.isEnabledFor(level)) {
            if (this.useLog4j) {
                this.log4jLog(level, string, throwable);
            } else {
                this.ourLog(level, string, throwable);
            }
        }
    }

    private boolean log4jIsEnabledFor(Level level) {
        if (level.equals(Level.ALL)) {
            level = Level.DEBUG;
        }
        try {
            Object[] objectArray = new Object[]{level.toString()};
            Object object = this.toLevelMethod.invoke(null, objectArray);
            Object[] objectArray2 = new Object[]{object};
            Object object2 = this.isEnabledForMethod.invoke(this.logger, objectArray2);
            return (Boolean)object2;
        }
        catch (Exception exception) {
            this.ourLog(Level.ERROR, "Failed to invoke log4j toLevel/isEnabledFor method", exception);
            this.useLog4j = false;
            return false;
        }
    }

    private void log4jLog(Level level, String string, Throwable throwable) {
        if (level.equals(Level.ALL)) {
            level = Level.DEBUG;
        }
        Object[] objectArray = null;
        int n = -1;
        if (throwable == null) {
            objectArray = this.argsPlain;
            n = 0;
        } else {
            objectArray = this.argsThrowable;
            objectArray[1] = throwable;
            n = 1;
        }
        objectArray[0] = string;
        Method method = this.logMethods[level.getLevel()][n];
        try {
            method.invoke(this.logger, objectArray);
        }
        catch (Exception exception) {
            this.ourLog(Level.ERROR, "Failed to invoke log4j logging method", exception);
            this.ourLog(level, string, throwable);
            this.useLog4j = false;
        }
    }

    private void ourLog(Level level, String string, Throwable throwable) {
        Object object;
        this.ts.setTime(System.currentTimeMillis());
        String string2 = this.format.format(this.ts);
        StringBuffer stringBuffer = new StringBuffer(level.toString());
        stringBuffer.append(" [");
        if (logThreadNames || this.logThreadName) {
            stringBuffer.append(Thread.currentThread().getName()).append("_");
        }
        stringBuffer.append(this.clazz).append("] ").append(string2).append(" : ").append(string);
        if (throwable != null) {
            stringBuffer.append(" : ").append(throwable.getMessage());
            StringWriter stringWriter = new StringWriter();
            object = new PrintWriter(stringWriter);
            ((PrintWriter)object).println();
            throwable.printStackTrace((PrintWriter)object);
            ((PrintWriter)object).println();
            stringBuffer.append(stringWriter.toString());
        }
        if (appenders.size() == 0) {
            System.out.println(stringBuffer.toString());
            while (throwable != null) {
                throwable.printStackTrace(System.out);
                if (throwable instanceof BaseIOException) {
                    if ((throwable = ((BaseIOException)throwable).getInnerThrowable()) == null) continue;
                    System.out.println("CAUSED BY:");
                    continue;
                }
                throwable = null;
            }
        } else {
            for (int i2 = 0; i2 < appenders.size(); ++i2) {
                object = (Appender)appenders.elementAt(i2);
                object.log(stringBuffer.toString());
                while (throwable != null) {
                    object.log(throwable);
                    if (throwable instanceof BaseIOException) {
                        if ((throwable = ((BaseIOException)throwable).getInnerThrowable()) == null) continue;
                        object.log("CAUSED BY:");
                        continue;
                    }
                    throwable = null;
                }
            }
        }
    }

    public final void info(String string) {
        this.log(Level.INFO, string, null);
    }

    public final void info(String string, Throwable throwable) {
        this.log(Level.INFO, string, throwable);
    }

    public final void warn(String string) {
        this.log(Level.WARN, string, null);
    }

    public final void warn(String string, Throwable throwable) {
        this.log(Level.WARN, string, throwable);
    }

    public final void error(String string) {
        this.log(Level.ERROR, string, null);
    }

    public final void error(String string, Throwable throwable) {
        this.log(Level.ERROR, string, throwable);
    }

    public final void fatal(String string) {
        this.log(Level.FATAL, string, null);
    }

    public final void fatal(String string, Throwable throwable) {
        this.log(Level.FATAL, string, throwable);
    }

    public final void debug(String string) {
        this.log(Level.DEBUG, string, null);
    }

    public final void debug(String string, byte[] byArray) {
        this.log(Level.DEBUG, string, null);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byte by = byArray[i2];
            if (i2 > 0 && i2 % 12 == 0) {
                this.log(Level.DEBUG, stringBuffer.toString() + "  " + stringBuffer2.toString(), null);
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
            }
            stringBuffer.append(hex[by >> 4 & 0xF] + hex[by & 0xF] + " ");
            stringBuffer2.append(by >= 32 && by <= 126 ? (char)by : (char)'?');
        }
        this.log(Level.DEBUG, stringBuffer.toString() + "  " + stringBuffer2.toString(), null);
    }

    public final void debug(String string, Object object) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(string, object), null);
        }
    }

    public final void debug(String string, Object object, Object object2) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(string, object, object2), null);
        }
    }

    public final void debug(String string, Object object, Object object2, Object object3) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(string, object, object2, object3), null);
        }
    }

    public final void debug(String string, Object object, Object object2, Object object3, Object object4) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(string, object, object2, object3, object4), null);
        }
    }

    public final void debug(String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(string, object, object2, object3, object4, object5), null);
        }
    }

    public final void debug(String string, Throwable throwable) {
        this.log(Level.DEBUG, string, throwable);
    }

    public final synchronized boolean isEnabledFor(Level level) {
        if (this.useLog4j) {
            return this.log4jIsEnabledFor(level);
        }
        return globalLevel.isGreaterOrEqual(level);
    }

    public final boolean isDebugEnabled() {
        return this.isEnabledFor(Level.DEBUG);
    }

    public final boolean isInfoEnabled() {
        return this.isEnabledFor(Level.INFO);
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logThreadNames = false;
        loggers = new Hashtable(10);
        appenders = new Vector(2);
        String string = Level.OFF.toString();
        try {
            string = System.getProperty("edtftp.log.level", Level.OFF.toString());
        }
        catch (SecurityException securityException) {
            System.out.println("Could not read property 'edtftp.log.level' due to security permissions");
        }
        try {
            prefix = System.getProperty("edtftp.log.prefix");
            if (prefix == null) {
                prefix = "";
            }
        }
        catch (Throwable throwable) {
            System.out.println("Could not read property 'edtftp.log.prefix' due to security permissions");
            prefix = "";
        }
        globalLevel = Level.getLevel(string);
        if (globalLevel == null) {
            globalLevel = Level.OFF;
        }
        hex = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    }
}

