/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.BoundedSize;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout$Measure;
import com.jgoodies.forms.layout.FormSpec$DefaultAlignment;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.forms.layout.Sizes$ComponentSize;
import java.awt.Container;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public abstract class FormSpec
implements Serializable {
    static final FormSpec$DefaultAlignment LEFT_ALIGN = new FormSpec$DefaultAlignment("left", null);
    static final FormSpec$DefaultAlignment RIGHT_ALIGN = new FormSpec$DefaultAlignment("right", null);
    static final FormSpec$DefaultAlignment TOP_ALIGN = new FormSpec$DefaultAlignment("top", null);
    static final FormSpec$DefaultAlignment BOTTOM_ALIGN = new FormSpec$DefaultAlignment("bottom", null);
    static final FormSpec$DefaultAlignment CENTER_ALIGN = new FormSpec$DefaultAlignment("center", null);
    static final FormSpec$DefaultAlignment FILL_ALIGN = new FormSpec$DefaultAlignment("fill", null);
    private static final FormSpec$DefaultAlignment[] VALUES = new FormSpec$DefaultAlignment[]{LEFT_ALIGN, RIGHT_ALIGN, TOP_ALIGN, BOTTOM_ALIGN, CENTER_ALIGN, FILL_ALIGN};
    public static final double NO_GROW = 0.0;
    public static final double DEFAULT_GROW = 1.0;
    private FormSpec$DefaultAlignment defaultAlignment;
    private Size size;
    private double resizeWeight;

    protected FormSpec(FormSpec$DefaultAlignment formSpec$DefaultAlignment, Size size, double d2) {
        this.defaultAlignment = formSpec$DefaultAlignment;
        this.size = size;
        this.resizeWeight = d2;
        if (d2 < 0.0) {
            throw new IllegalArgumentException("The resize weight must be non-negative.");
        }
    }

    protected FormSpec(FormSpec$DefaultAlignment formSpec$DefaultAlignment, String string) {
        this(formSpec$DefaultAlignment, Sizes.DEFAULT, 0.0);
        this.parseAndInitValues(string.toLowerCase(Locale.ENGLISH));
    }

    public final FormSpec$DefaultAlignment getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public final Size getSize() {
        return this.size;
    }

    public final double getResizeWeight() {
        return this.resizeWeight;
    }

    final boolean canGrow() {
        return this.getResizeWeight() != 0.0;
    }

    private void parseAndInitValues(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("The form spec must not be empty.");
        }
        String string2 = stringTokenizer.nextToken();
        FormSpec$DefaultAlignment formSpec$DefaultAlignment = FormSpec$DefaultAlignment.access$100(string2, this.isHorizontal());
        if (formSpec$DefaultAlignment != null) {
            this.defaultAlignment = formSpec$DefaultAlignment;
            if (!stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException("The form spec must provide a size.");
            }
            string2 = stringTokenizer.nextToken();
        }
        this.parseAndInitSize(string2);
        if (stringTokenizer.hasMoreTokens()) {
            this.resizeWeight = this.decodeResize(stringTokenizer.nextToken());
        }
    }

    private void parseAndInitSize(String string) {
        if (string.startsWith("max(") && string.endsWith(")")) {
            this.size = this.parseAndInitBoundedSize(string, false);
            return;
        }
        if (string.startsWith("min(") && string.endsWith(")")) {
            this.size = this.parseAndInitBoundedSize(string, true);
            return;
        }
        this.size = this.decodeAtomicSize(string);
    }

    private Size parseAndInitBoundedSize(String string, boolean bl) {
        int n = string.indexOf(59);
        String string2 = string.substring(4, n);
        String string3 = string.substring(n + 1, string.length() - 1);
        Size size = this.decodeAtomicSize(string2);
        Size size2 = this.decodeAtomicSize(string3);
        if (size instanceof ConstantSize) {
            if (size2 instanceof Sizes$ComponentSize) {
                return new BoundedSize(size2, bl ? null : size, bl ? size : null);
            }
            throw new IllegalArgumentException("Bounded sizes must not be both constants.");
        }
        if (size2 instanceof ConstantSize) {
            return new BoundedSize(size, bl ? null : size2, bl ? size2 : null);
        }
        throw new IllegalArgumentException("Bounded sizes must not be both logical.");
    }

    private Size decodeAtomicSize(String string) {
        Sizes$ComponentSize sizes$ComponentSize = Sizes$ComponentSize.valueOf(string);
        if (sizes$ComponentSize != null) {
            return sizes$ComponentSize;
        }
        return ConstantSize.valueOf(string, this.isHorizontal());
    }

    private double decodeResize(String string) {
        if (string.equals("g") || string.equals("grow")) {
            return 1.0;
        }
        if (string.equals("n") || string.equals("nogrow") || string.equals("none")) {
            return 0.0;
        }
        if ((string.startsWith("grow(") || string.startsWith("g(")) && string.endsWith(")")) {
            int n = string.indexOf(40);
            int n2 = string.indexOf(41);
            String string2 = string.substring(n + 1, n2);
            return Double.parseDouble(string2);
        }
        throw new IllegalArgumentException("The resize argument '" + string + "' is invalid. " + " Must be one of: grow, g, none, n, grow(<double>), g(<double>)");
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.defaultAlignment);
        stringBuffer.append(":");
        stringBuffer.append(this.size.toString());
        stringBuffer.append(':');
        if (this.resizeWeight == 0.0) {
            stringBuffer.append("noGrow");
        } else if (this.resizeWeight == 1.0) {
            stringBuffer.append("grow");
        } else {
            stringBuffer.append("grow(");
            stringBuffer.append(this.resizeWeight);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    public final String toShortString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.defaultAlignment.abbreviation());
        stringBuffer.append(":");
        stringBuffer.append(this.size.toString());
        stringBuffer.append(':');
        if (this.resizeWeight == 0.0) {
            stringBuffer.append("n");
        } else if (this.resizeWeight == 1.0) {
            stringBuffer.append("g");
        } else {
            stringBuffer.append("g(");
            stringBuffer.append(this.resizeWeight);
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    abstract boolean isHorizontal();

    final int maximumSize(Container container, List list, FormLayout$Measure formLayout$Measure, FormLayout$Measure formLayout$Measure2, FormLayout$Measure formLayout$Measure3) {
        return this.size.maximumSize(container, list, formLayout$Measure, formLayout$Measure2, formLayout$Measure3);
    }

    static FormSpec$DefaultAlignment[] access$200() {
        return VALUES;
    }
}

