/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;

final class BumpBuffer {
    static final int IMAGE_SIZE = 64;
    static Dimension imageSize = new Dimension(64, 64);
    transient Image image;
    Color topColor;
    Color shadowColor;
    Color backColor;
    private GraphicsConfiguration gc;

    public BumpBuffer(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        this.gc = graphicsConfiguration;
        this.topColor = color;
        this.shadowColor = color2;
        this.backColor = color3;
        this.createImage();
        this.fillBumpBuffer();
    }

    public final boolean hasSameConfiguration(GraphicsConfiguration graphicsConfiguration, Color color, Color color2, Color color3) {
        if (this.gc != null ? !this.gc.equals(graphicsConfiguration) : graphicsConfiguration != null) {
            return false;
        }
        return this.topColor.equals(color) && this.shadowColor.equals(color2) && this.backColor.equals(color3);
    }

    public final Image getImage() {
        return this.image;
    }

    public final Dimension getImageSize() {
        return imageSize;
    }

    private void fillBumpBuffer() {
        int n;
        int n2;
        Graphics graphics = this.image.getGraphics();
        graphics.setColor(this.backColor);
        graphics.fillRect(0, 0, 64, 64);
        graphics.setColor(this.topColor);
        for (n2 = 0; n2 < 64; n2 += 4) {
            for (n = 0; n < 64; n += 4) {
                graphics.drawLine(n2, n, n2, n);
                graphics.drawLine(n2 + 2, n + 2, n2 + 2, n + 2);
            }
        }
        graphics.setColor(this.shadowColor);
        for (n2 = 0; n2 < 64; n2 += 4) {
            for (n = 0; n < 64; n += 4) {
                graphics.drawLine(n2 + 1, n + 1, n2 + 1, n + 1);
                graphics.drawLine(n2 + 3, n + 3, n2 + 3, n + 3);
            }
        }
        graphics.dispose();
    }

    private void createImage() {
        if (this.gc != null) {
            this.image = this.gc.createCompatibleImage(64, 64);
        } else {
            int[] nArray = new int[]{this.backColor.getRGB(), this.topColor.getRGB(), this.shadowColor.getRGB()};
            IndexColorModel indexColorModel = new IndexColorModel(8, 3, nArray, 0, false, -1, 0);
            this.image = new BufferedImage(64, 64, 13, indexColorModel);
        }
    }
}

