/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticTabbedPaneUI;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$ArrowButton;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$ScrollableTabPanel;
import com.jgoodies.looks.plastic.PlasticTabbedPaneUI$ScrollableTabViewport;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PlasticTabbedPaneUI$ScrollableTabSupport
implements ActionListener,
ChangeListener {
    public PlasticTabbedPaneUI$ScrollableTabViewport viewport;
    public PlasticTabbedPaneUI$ScrollableTabPanel tabPanel;
    public JButton scrollForwardButton;
    public JButton scrollBackwardButton;
    public int leadingTabIndex;
    private Point tabViewPosition;
    private final PlasticTabbedPaneUI this$0;

    PlasticTabbedPaneUI$ScrollableTabSupport(PlasticTabbedPaneUI plasticTabbedPaneUI, int n) {
        this.this$0 = plasticTabbedPaneUI;
        this.tabViewPosition = new Point(0, 0);
        this.viewport = new PlasticTabbedPaneUI$ScrollableTabViewport(plasticTabbedPaneUI);
        this.tabPanel = new PlasticTabbedPaneUI$ScrollableTabPanel(plasticTabbedPaneUI);
        this.viewport.setView(this.tabPanel);
        this.viewport.addChangeListener(this);
        this.createButtons();
    }

    final void createButtons() {
        if (this.scrollForwardButton != null) {
            PlasticTabbedPaneUI.access$15400(this.this$0).remove(this.scrollForwardButton);
            this.scrollForwardButton.removeActionListener(this);
            PlasticTabbedPaneUI.access$15500(this.this$0).remove(this.scrollBackwardButton);
            this.scrollBackwardButton.removeActionListener(this);
        }
        int n = PlasticTabbedPaneUI.access$15600(this.this$0).getTabPlacement();
        int n2 = UIManager.getInt("ScrollBar.width");
        if (n == 1 || n == 3) {
            this.scrollForwardButton = new PlasticTabbedPaneUI$ArrowButton(3, n2);
            this.scrollBackwardButton = new PlasticTabbedPaneUI$ArrowButton(7, n2);
        } else {
            this.scrollForwardButton = new PlasticTabbedPaneUI$ArrowButton(5, n2);
            this.scrollBackwardButton = new PlasticTabbedPaneUI$ArrowButton(1, n2);
        }
        this.scrollForwardButton.addActionListener(this);
        this.scrollBackwardButton.addActionListener(this);
        PlasticTabbedPaneUI.access$15700(this.this$0).add(this.scrollForwardButton);
        PlasticTabbedPaneUI.access$15800(this.this$0).add(this.scrollBackwardButton);
    }

    public final void scrollForward(int n) {
        Dimension dimension = this.viewport.getViewSize();
        Rectangle rectangle = this.viewport.getViewRect();
        if (n == 1 || n == 3 ? rectangle.width >= dimension.width - rectangle.x : rectangle.height >= dimension.height - rectangle.y) {
            return;
        }
        this.setLeadingTabIndex(n, this.leadingTabIndex + 1);
    }

    public final void scrollBackward(int n) {
        if (this.leadingTabIndex == 0) {
            return;
        }
        this.setLeadingTabIndex(n, this.leadingTabIndex - 1);
    }

    public final void setLeadingTabIndex(int n, int n2) {
        this.leadingTabIndex = n2;
        Dimension dimension = this.viewport.getViewSize();
        Rectangle rectangle = this.viewport.getViewRect();
        switch (n) {
            case 1: 
            case 3: {
                int n3 = this.tabViewPosition.x = this.leadingTabIndex == 0 ? 0 : PlasticTabbedPaneUI.access$15900((PlasticTabbedPaneUI)this.this$0)[this.leadingTabIndex].x - PlasticTabbedPaneUI.access$1100(this.this$0).getTabsOverlay();
                if (dimension.width - this.tabViewPosition.x >= rectangle.width) break;
                Dimension dimension2 = new Dimension(dimension.width - this.tabViewPosition.x, rectangle.height);
                this.viewport.setExtentSize(dimension2);
                break;
            }
            case 2: 
            case 4: {
                int n4 = this.tabViewPosition.y = this.leadingTabIndex == 0 ? 0 : PlasticTabbedPaneUI.access$16000((PlasticTabbedPaneUI)this.this$0)[this.leadingTabIndex].y;
                if (dimension.height - this.tabViewPosition.y >= rectangle.height) break;
                Dimension dimension3 = new Dimension(rectangle.width, dimension.height - this.tabViewPosition.y);
                this.viewport.setExtentSize(dimension3);
            }
        }
        this.viewport.setViewPosition(this.tabViewPosition);
    }

    public final void stateChanged(ChangeEvent changeEvent) {
        JViewport jViewport = (JViewport)changeEvent.getSource();
        int n = PlasticTabbedPaneUI.access$16100(this.this$0).getTabPlacement();
        int n2 = PlasticTabbedPaneUI.access$16200(this.this$0).getTabCount();
        Rectangle rectangle = jViewport.getBounds();
        Dimension dimension = jViewport.getViewSize();
        Rectangle rectangle2 = jViewport.getViewRect();
        this.leadingTabIndex = PlasticTabbedPaneUI.access$16300(this.this$0, rectangle2.x, rectangle2.y);
        if (this.leadingTabIndex + 1 < n2) {
            switch (n) {
                case 1: 
                case 3: {
                    if (PlasticTabbedPaneUI.access$16400((PlasticTabbedPaneUI)this.this$0)[this.leadingTabIndex].x >= rectangle2.x) break;
                    ++this.leadingTabIndex;
                    break;
                }
                case 2: 
                case 4: {
                    if (PlasticTabbedPaneUI.access$16500((PlasticTabbedPaneUI)this.this$0)[this.leadingTabIndex].y >= rectangle2.y) break;
                    ++this.leadingTabIndex;
                }
            }
        }
        Insets insets = this.this$0.getContentBorderInsets(n);
        switch (n) {
            case 2: {
                PlasticTabbedPaneUI.access$16600(this.this$0).repaint(rectangle.x + rectangle.width, rectangle.y, insets.left, rectangle.height);
                this.scrollBackwardButton.setEnabled(rectangle2.y > 0 && this.leadingTabIndex > 0);
                this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                break;
            }
            case 4: {
                PlasticTabbedPaneUI.access$16700(this.this$0).repaint(rectangle.x - insets.right, rectangle.y, insets.right, rectangle.height);
                this.scrollBackwardButton.setEnabled(rectangle2.y > 0 && this.leadingTabIndex > 0);
                this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.height - rectangle2.y > rectangle2.height);
                break;
            }
            case 3: {
                PlasticTabbedPaneUI.access$16800(this.this$0).repaint(rectangle.x, rectangle.y - insets.bottom, rectangle.width, insets.bottom);
                this.scrollBackwardButton.setEnabled(rectangle2.x > 0 && this.leadingTabIndex > 0);
                this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
                break;
            }
            default: {
                PlasticTabbedPaneUI.access$16900(this.this$0).repaint(rectangle.x, rectangle.y + rectangle.height, rectangle.width, insets.top);
                this.scrollBackwardButton.setEnabled(rectangle2.x > 0 && this.leadingTabIndex > 0);
                this.scrollForwardButton.setEnabled(this.leadingTabIndex < n2 - 1 && dimension.width - rectangle2.x > rectangle2.width);
            }
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        String string;
        Action action;
        ActionMap actionMap = PlasticTabbedPaneUI.access$17000(this.this$0).getActionMap();
        if (actionMap != null && (action = actionMap.get(string = actionEvent.getSource() == this.scrollForwardButton ? "scrollTabsForwardAction" : "scrollTabsBackwardAction")) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(PlasticTabbedPaneUI.access$17100(this.this$0), 1001, null, actionEvent.getWhen(), actionEvent.getModifiers()));
        }
    }
}

