/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticXPIconFactory$1;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.Serializable;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

class PlasticXPIconFactory$CheckBoxIcon
implements Icon,
UIResource,
Serializable {
    private static final int SIZE = LookUtils.IS_LOW_RESOLUTION ? 13 : 15;

    private PlasticXPIconFactory$CheckBoxIcon() {
    }

    public int getIconWidth() {
        return SIZE;
    }

    public int getIconHeight() {
        return SIZE;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        JCheckBox jCheckBox = (JCheckBox)component;
        ButtonModel buttonModel = jCheckBox.getModel();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.drawBorder(graphics2D, buttonModel.isEnabled(), n, n2, SIZE - 1, SIZE - 1);
        this.drawFill(graphics2D, buttonModel.isPressed(), n + 1, n2 + 1, SIZE - 2, SIZE - 2);
        if (buttonModel.isEnabled() && buttonModel.isArmed() && !buttonModel.isPressed()) {
            this.drawFocus(graphics2D, n + 1, n2 + 1, SIZE - 3, SIZE - 3);
        }
        if (buttonModel.isSelected()) {
            this.drawCheck(graphics2D, buttonModel.isEnabled(), n + 3, n2 + 3, SIZE - 7, SIZE - 7);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
    }

    private void drawBorder(Graphics2D graphics2D, boolean bl, int n, int n2, int n3, int n4) {
        graphics2D.setColor(bl ? PlasticLookAndFeel.getControlDarkShadow() : MetalLookAndFeel.getControlDisabled());
        graphics2D.drawRect(n, n2, n3, n4);
    }

    private void drawCheck(Graphics2D graphics2D, boolean bl, int n, int n2, int n3, int n4) {
        graphics2D.setColor(bl ? UIManager.getColor("CheckBox.check") : MetalLookAndFeel.getControlDisabled());
        int n5 = n + n3;
        int n6 = n2 + n4;
        int n7 = n2 + n4 / 3;
        int n8 = n + n3 / 2 - 2;
        graphics2D.drawLine(n, n7, n8, n6 - 3);
        graphics2D.drawLine(n, n7 + 1, n8, n6 - 2);
        graphics2D.drawLine(n, n7 + 2, n8, n6 - 1);
        graphics2D.drawLine(n8 + 1, n6 - 2, n5, n2);
        graphics2D.drawLine(n8 + 1, n6 - 1, n5, n2 + 1);
        graphics2D.drawLine(n8 + 1, n6, n5, n2 + 2);
    }

    private void drawFill(Graphics2D graphics2D, boolean bl, int n, int n2, int n3, int n4) {
        Color color;
        ColorUIResource colorUIResource;
        if (bl) {
            colorUIResource = MetalLookAndFeel.getControlShadow();
            color = PlasticLookAndFeel.getControlHighlight();
        } else {
            colorUIResource = PlasticLookAndFeel.getControl();
            color = PlasticLookAndFeel.getControlHighlight().brighter();
        }
        graphics2D.setPaint(new GradientPaint(n, n2, colorUIResource, n + n3, n2 + n4, color));
        graphics2D.fillRect(n, n2, n3, n4);
    }

    private void drawFocus(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setPaint(new GradientPaint(n, n2, PlasticLookAndFeel.getFocusColor().brighter(), n3, n4, PlasticLookAndFeel.getFocusColor()));
        graphics2D.drawRect(n, n2, n3, n4);
        graphics2D.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
    }

    PlasticXPIconFactory$CheckBoxIcon(PlasticXPIconFactory$1 plasticXPIconFactory$1) {
        this();
    }
}

