/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.windows.WindowsArrowButton;
import com.jgoodies.looks.windows.WindowsComboBoxEditor$UIResource;
import com.jgoodies.looks.windows.WindowsComboBoxUI$TableCellEditorPropertyChangeHandler;
import com.jgoodies.looks.windows.WindowsComboBoxUI$WindowsComboBoxLayoutManager;
import com.jgoodies.looks.windows.WindowsComboBoxUI$WindowsComboPopup;
import com.sun.java.swing.plaf.windows.WindowsTextFieldUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsComboBoxUI
extends com.sun.java.swing.plaf.windows.WindowsComboBoxUI {
    private static final String CELL_EDITOR_KEY = "JComboBox.isTableCellEditor";
    private static final JTextField PHANTOM = new JTextField("Phantom");
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Border EMPTY_BORDER = new EmptyBorder(EMPTY_INSETS);
    private boolean tableCellEditor;
    private PropertyChangeListener propertyChangeListener;

    public static final ComponentUI createUI(JComponent jComponent) {
        WindowsComboBoxUI.ensurePhantomHasWindowsUI();
        return new WindowsComboBoxUI();
    }

    private static void ensurePhantomHasWindowsUI() {
        if (!(PHANTOM.getUI() instanceof WindowsTextFieldUI)) {
            PHANTOM.updateUI();
        }
    }

    public final void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.tableCellEditor = this.isTableCellEditor();
    }

    protected final void installListeners() {
        super.installListeners();
        this.propertyChangeListener = new WindowsComboBoxUI$TableCellEditorPropertyChangeHandler(this, null);
        this.comboBox.addPropertyChangeListener(CELL_EDITOR_KEY, this.propertyChangeListener);
    }

    protected final void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removePropertyChangeListener(CELL_EDITOR_KEY, this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected final JButton createArrowButton() {
        return LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? super.createArrowButton() : new WindowsArrowButton(5);
    }

    protected final ComboBoxEditor createEditor() {
        return new WindowsComboBoxEditor$UIResource(this.tableCellEditor);
    }

    protected final LayoutManager createLayoutManager() {
        return new WindowsComboBoxUI$WindowsComboBoxLayoutManager(this, null);
    }

    protected final ComboPopup createPopup() {
        return new WindowsComboBoxUI$WindowsComboPopup(this.comboBox, null);
    }

    protected final ListCellRenderer createRenderer() {
        if (this.tableCellEditor) {
            return super.createRenderer();
        }
        BasicComboBoxRenderer.UIResource uIResource = new BasicComboBoxRenderer.UIResource();
        uIResource.setBorder(UIManager.getBorder("ComboBox.rendererBorder"));
        return uIResource;
    }

    public final Dimension getMinimumSize(JComponent jComponent) {
        Serializable serializable;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = this.getDisplaySize();
        Insets insets = this.getInsets();
        dimension.height += insets.top + insets.bottom;
        int n = this.getEditableButtonWidth();
        dimension.width += insets.left + insets.right + n;
        ++dimension.width;
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (listCellRenderer instanceof JComponent) {
            serializable = (JComponent)((Object)listCellRenderer);
            Insets insets2 = ((JComponent)serializable).getInsets();
            Insets insets3 = UIManager.getInsets("ComboBox.editorInsets");
            int n2 = Math.max(0, insets3.left - insets2.left);
            int n3 = Math.max(0, insets3.right - insets2.right);
            dimension.width += n2 + n3;
        }
        serializable = PHANTOM.getMinimumSize();
        dimension.height = LookUtils.IS_OS_WINDOWS_VISTA && !LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? ((Dimension)serializable).height : Math.max(((Dimension)serializable).height, dimension.height);
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(dimension);
    }

    public final Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public final void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl) {
        Component component;
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setBackground(UIManager.getColor("ComboBox.background"));
        }
        Border border = null;
        if (component instanceof JComponent && !this.tableCellEditor) {
            JComponent jComponent = (JComponent)component;
            if (this.isRendererBorderRemovable(jComponent)) {
                border = jComponent.getBorder();
                jComponent.setBorder(EMPTY_BORDER);
            }
            Insets insets = jComponent.getInsets();
            Insets insets2 = UIManager.getInsets("ComboBox.editorInsets");
            int n = Math.max(0, insets2.left - insets.left);
            int n2 = Math.max(0, insets2.right - insets.right);
            int n3 = Math.max(0, insets2.top - insets.top);
            int n4 = Math.max(0, insets2.bottom - insets.bottom);
            rectangle.x += n;
            rectangle.y += n3;
            rectangle.width -= n + n2 - 1;
            rectangle.height -= n3 + n4;
        }
        component.setFont(this.comboBox.getFont());
        if (bl && !this.isPopupVisible(this.comboBox)) {
            component.setForeground(this.listBox.getSelectionForeground());
            component.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
            component.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
        boolean bl2 = component instanceof JPanel;
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2);
        if (border != null) {
            ((JComponent)component).setBorder(border);
        }
    }

    private boolean isRendererBorderRemovable(JComponent jComponent) {
        if (jComponent instanceof BasicComboBoxRenderer.UIResource) {
            return true;
        }
        Object object = jComponent.getClientProperty("isBorderRemovable");
        if (object != null) {
            return Boolean.TRUE.equals(object);
        }
        Border border = jComponent.getBorder();
        return border instanceof EmptyBorder;
    }

    protected final Rectangle rectangleForCurrentValue() {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n3 = this.getEditableButtonWidth();
        if (this.arrowButton != null) {
            n3 = this.arrowButton.getWidth();
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + n3, insets.top, n - (insets.left + insets.right + n3), n2 - (insets.top + insets.bottom));
    }

    private int getEditableButtonWidth() {
        return UIManager.getInt("ScrollBar.width");
    }

    private boolean isTableCellEditor() {
        return Boolean.TRUE.equals(this.comboBox.getClientProperty(CELL_EDITOR_KEY));
    }

    static final Insets access$300(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.getInsets();
    }

    static final int access$400(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.getEditableButtonWidth();
    }

    static final JButton access$500(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.arrowButton;
    }

    static final JButton access$600(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.arrowButton;
    }

    static final JButton access$700(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.arrowButton;
    }

    static final Component access$800(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.editor;
    }

    static final Component access$900(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.editor;
    }

    static final boolean access$1002(WindowsComboBoxUI windowsComboBoxUI, boolean bl) {
        windowsComboBoxUI.tableCellEditor = bl;
        return windowsComboBoxUI.tableCellEditor;
    }

    static final boolean access$1100(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.isTableCellEditor();
    }

    static final JComboBox access$1200(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.comboBox;
    }

    static final JComboBox access$1300(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.comboBox;
    }

    static final JComboBox access$1400(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.comboBox;
    }

    static final JComboBox access$1500(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.comboBox;
    }

    static final JComboBox access$1600(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.comboBox;
    }

    static final JComboBox access$1700(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.comboBox;
    }
}

