/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.dialog;

import com.jidesoft.dialog.BannerPanel$1;
import com.jidesoft.dialog.BannerPanel$2;
import com.jidesoft.dialog.BannerPanel$3;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.SecurityUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BannerPanel
extends JPanel {
    private static final long serialVersionUID = -7191474275030489327L;
    protected String _title;
    protected String _subtitle;
    protected ImageIcon _titleIcon;
    public static final String TITLE_PROPERTY = "title";
    public static final String SUBTITLE_PROPERTY = "subTitle";
    public static final String ICON_PROPERTY = "icon";
    public static final String ICON_COMPONENT_PROPERTY = "iconComponent";
    public static final String PROPERTY_TITLE_FONT = "titleFont";
    public static final String PROPERTY_SUBTITLE_FONT = "subTitleFont";
    public static final String PROPERTY_TITLE_ICON_LOCATION = "titleIconLocation";
    private JComponent _iconComponent;
    protected int _subTitleIndent = 20;
    protected Font _titleFont;
    protected Color _titleColor;
    protected Font _subTitleFont;
    protected Color _subTitleColor;
    protected Paint _backgroundPaint;
    protected PropertyChangeListener _propertyListener;
    private JLabel _titleLabel;
    private JComponent _subtitleLabel;
    protected Color _startColor;
    protected Color _endColor;
    protected boolean _isVertical;
    private int _titleIconLocation = 11;
    public JPanel _textPanel;

    public BannerPanel() {
        this.lazyInitialize();
    }

    public BannerPanel(String string) {
        this.setTitle(string);
        this.lazyInitialize();
    }

    public BannerPanel(String string, String string2) {
        this.setTitle(string);
        this.setSubtitle(string2);
        this.lazyInitialize();
    }

    public BannerPanel(String string, String string2, ImageIcon imageIcon) {
        this.setTitle(string);
        this.setSubtitle(string2);
        this.setTitleIcon(imageIcon);
        this.lazyInitialize();
    }

    public BannerPanel(String string, String string2, JComponent jComponent) {
        this.setTitle(string);
        this.setSubtitle(string2);
        this._iconComponent = jComponent;
        this.lazyInitialize();
    }

    public final void lazyInitialize() {
        this.removeAll();
        this._textPanel = new JPanel(new BorderLayout(5, 5));
        this._textPanel.setOpaque(false);
        this._textPanel.setBorder(BorderFactory.createEmptyBorder(3, 10, 2, 10));
        if (this.getSubTitleFont() == null) {
            this.setSubTitleFont(this.getFont());
        }
        this._subtitleLabel = this.createSubtitleLabel();
        this._subtitleLabel.setFont(this.getSubTitleFont());
        if (this.getSubTitleColor() == null) {
            this.setSubTitleColor(this.getForeground());
        }
        this._subtitleLabel.setForeground(this.getSubTitleColor());
        this._subtitleLabel.setBorder(BorderFactory.createEmptyBorder(0, this.getSubTitleIndent(), 0, 0));
        this._textPanel.add((Component)this._subtitleLabel, "Center");
        this._titleLabel = new BannerPanel$1(this, this.getTitle());
        if (this.getTitleFont() == null) {
            this.setTitleFont(SecurityUtils.createFont(this.getFont().getFontName(), 1, this.getFont().getSize() + 2));
        }
        this._titleLabel.setFont(this.getTitleFont());
        if (this.getTitleColor() == null) {
            this.setTitleColor(this.getForeground());
        }
        this._titleLabel.setForeground(this.getTitleColor());
        if (this.getSubtitle() != null && this.getSubtitle().length() != 0) {
            this._textPanel.add((Component)this._titleLabel, "First");
        } else {
            this._textPanel.add((Component)this._titleLabel, "Center");
        }
        if (this.getTitleIcon() == null && this._iconComponent == null) {
            this._iconComponent = new JLabel("");
        } else if (this.getTitleIcon() != null || this._iconComponent == null) {
            this._iconComponent = new JLabel(this.getTitleIcon());
        }
        this._iconComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 0));
        this.add((Component)this._textPanel, "Center");
        this.addIconComponent(this._iconComponent);
        this._propertyListener = new BannerPanel$2(this);
        this.addPropertyChangeListener(this._propertyListener);
    }

    protected final JComponent createSubtitleLabel() {
        return new BannerPanel$3(this, this.getSubtitle());
    }

    private void addIconComponent(JComponent jComponent) {
        if (jComponent != null) {
            switch (this.getTitleIconLocation()) {
                case 3: {
                    this.add((Component)jComponent, "East");
                    break;
                }
                case 7: {
                    this.add((Component)jComponent, "West");
                    break;
                }
                case 10: {
                    this.add((Component)jComponent, "Before");
                    break;
                }
                case 11: {
                    this.add((Component)jComponent, "After");
                }
            }
        }
    }

    protected final ImageIcon prepareTitleIcon(ImageIcon imageIcon) {
        return imageIcon;
    }

    public final Paint getBackgroundPaint() {
        return this._backgroundPaint;
    }

    public final void setBackgroundPaint(Paint paint) {
        this._backgroundPaint = paint;
    }

    public final void setGradientPaint(Color color, Color color2, boolean bl) {
        this.setStartColor(color);
        this.setEndColor(color2);
        this.setVertical(bl);
    }

    protected final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.getStartColor() != null && this.getEndColor() != null) {
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(0, 0, this.getWidth(), this.getHeight()), this.getStartColor(), this.getEndColor(), this.isVertical());
        } else if (this.getBackgroundPaint() != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setPaint(this.getBackgroundPaint());
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public final String getTitle() {
        return this._title;
    }

    public final void setTitle(String string) {
        String string2 = this._title;
        this._title = string;
        this.firePropertyChange(TITLE_PROPERTY, string2, this._title);
    }

    public final String getSubtitle() {
        return this._subtitle;
    }

    public final void setSubtitle(String string) {
        String string2 = this._subtitle;
        this._subtitle = string;
        this.firePropertyChange(SUBTITLE_PROPERTY, string2, this._subtitle);
    }

    public final ImageIcon getTitleIcon() {
        return this._titleIcon;
    }

    public final void setTitleIcon(ImageIcon imageIcon) {
        ImageIcon imageIcon2 = this._titleIcon;
        this._titleIcon = this.prepareTitleIcon(imageIcon);
        this.firePropertyChange(ICON_PROPERTY, imageIcon2, this._titleIcon);
    }

    public final JComponent getIconComponent() {
        return this._iconComponent;
    }

    public final void setIconComponent(JComponent jComponent) {
        JComponent jComponent2 = this._iconComponent;
        this._iconComponent = jComponent;
        this.firePropertyChange(ICON_COMPONENT_PROPERTY, jComponent2, this._iconComponent);
    }

    public final Font getSubTitleFont() {
        return this._subTitleFont;
    }

    public final void setSubTitleFont(Font font) {
        Font font2 = this._subTitleFont;
        this._subTitleFont = font;
        this.firePropertyChange(PROPERTY_SUBTITLE_FONT, font2, this._subTitleFont);
    }

    public final Font getTitleFont() {
        return this._titleFont;
    }

    public final void setTitleFont(Font font) {
        Font font2 = this._titleFont;
        this._titleFont = font;
        this.firePropertyChange(PROPERTY_TITLE_FONT, font2, this._titleFont);
    }

    public final int getSubTitleIndent() {
        return this._subTitleIndent;
    }

    public final void setSubTitleIndent(int n) {
        this._subTitleIndent = n;
    }

    public final Color getTitleColor() {
        return this._titleColor;
    }

    public final void setTitleColor(Color color) {
        this._titleColor = color;
        if (this._titleLabel != null) {
            this._titleLabel.setForeground(color);
        }
    }

    public final Color getSubTitleColor() {
        return this._subTitleColor;
    }

    public final void setSubTitleColor(Color color) {
        this._subTitleColor = color;
        if (this._subtitleLabel != null) {
            this._subtitleLabel.setForeground(color);
        }
    }

    public final void setBackground(Color color) {
        super.setBackground(color);
        if (this._titleLabel != null) {
            this._titleLabel.setBackground(color);
        }
        if (this._subtitleLabel != null) {
            this._subtitleLabel.setBackground(color);
        }
        if (this._iconComponent != null) {
            this._iconComponent.setBackground(color);
        }
    }

    public final void setForeground(Color color) {
        super.setForeground(color);
        this.setTitleColor(color);
        this.setSubTitleColor(color);
        if (this._iconComponent != null) {
            this._iconComponent.setForeground(color);
        }
    }

    public final Color getStartColor() {
        return this._startColor;
    }

    public final void setStartColor(Color color) {
        this._startColor = color;
    }

    public final Color getEndColor() {
        return this._endColor;
    }

    public final void setEndColor(Color color) {
        this._endColor = color;
    }

    public final boolean isVertical() {
        return this._isVertical;
    }

    public final void setVertical(boolean bl) {
        this._isVertical = bl;
    }

    public final int getTitleIconLocation() {
        return this._titleIconLocation;
    }

    public final void setTitleIconLocation(int n) {
        int n2 = this._titleIconLocation;
        if (n2 != n) {
            this._titleIconLocation = n;
            this.firePropertyChange(PROPERTY_TITLE_ICON_LOCATION, n2, this._titleIconLocation);
        }
    }

    public final JComponent getTitleLabel() {
        return this._titleLabel;
    }

    public final JComponent getSubtitleLabel() {
        return this._subtitleLabel;
    }

    static final /* synthetic */ JLabel access$000(BannerPanel bannerPanel) {
        return bannerPanel._titleLabel;
    }

    static final /* synthetic */ JComponent access$100(BannerPanel bannerPanel) {
        return bannerPanel._subtitleLabel;
    }

    static final /* synthetic */ JComponent access$200(BannerPanel bannerPanel) {
        return bannerPanel._iconComponent;
    }

    static final /* synthetic */ void access$300(BannerPanel bannerPanel, JComponent jComponent) {
        bannerPanel.addIconComponent(jComponent);
    }
}

