/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.basic.BasicFileSystemTreeModel;
import com.jidesoft.plaf.basic.BasicFileSystemTreeNode;
import com.jidesoft.plaf.basic.BasicFolderChooserUI;
import com.jidesoft.plaf.basic.BasicFolderChooserUI$3$1;
import com.jidesoft.plaf.basic.FolderChooserResource;
import com.jidesoft.plaf.basic.FolderToolBarListener;
import com.jidesoft.plaf.basic.LazyMutableTreeNode;
import java.awt.Cursor;
import java.awt.Window;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

class BasicFolderChooserUI$3
implements FolderToolBarListener {
    private Cursor m_oldCursor;
    final /* synthetic */ BasicFolderChooserUI this$0;

    BasicFolderChooserUI$3(BasicFolderChooserUI basicFolderChooserUI) {
        this.this$0 = basicFolderChooserUI;
    }

    public final void deleteFolderButtonClicked() {
        TreePath treePath = this.this$0._fileSystemTree.getSelectionPaths()[0];
        List list = this.getSelectedFolders(new TreePath[]{treePath});
        ResourceBundle resourceBundle = FolderChooserResource.getResourceBundle(Locale.getDefault());
        String string = list.size() > 1 ? MessageFormat.format(resourceBundle.getString("FolderChooser.delete.message2"), list.size()) : resourceBundle.getString("FolderChooser.delete.message1");
        String string2 = resourceBundle.getString("FolderChooser.delete.title");
        int n = JOptionPane.showConfirmDialog(BasicFolderChooserUI.access$000(this.this$0), string, string2, 2, 2);
        if (n == 0) {
            TreePath treePath2 = treePath.getParentPath();
            Object object = treePath2.getLastPathComponent();
            Object object2 = treePath.getLastPathComponent();
            int n2 = this.this$0._fileSystemTree.getModel().getIndexOfChild(object, object2);
            for (Object e2 : list) {
                File file = (File)e2;
                this.recursiveDelete(file);
            }
            ((BasicFileSystemTreeModel)this.this$0._fileSystemTree.getModel()).removePath(treePath, n2, object2);
            Object object3 = treePath2;
            if (n2 >= ((MutableTreeNode)object).getChildCount()) {
                n2 = ((MutableTreeNode)object).getChildCount() - 1;
            }
            if (n2 > 0) {
                object3 = treePath2.pathByAddingChild(((MutableTreeNode)object).getChildAt(n2));
            }
            this.this$0._fileSystemTree.setSelectionPath((TreePath)object3);
            this.this$0._fileSystemTree.scrollPathToVisible((TreePath)object3);
        }
    }

    public final boolean recursiveDelete(File file) {
        if (BasicFolderChooserUI.isFileSystem(file)) {
            if (file.isDirectory()) {
                File[] fileArray;
                for (File file2 : fileArray = FileSystemView.getFileSystemView().getFiles(file, false)) {
                    if (this.recursiveDelete(file2)) continue;
                    return false;
                }
                return file.delete();
            }
            return file.delete();
        }
        return false;
    }

    public final void newFolderButtonClicked() {
        TreePath[] treePathArray = this.this$0._fileSystemTree.getSelectionPaths();
        List list = this.getSelectedFolders(treePathArray);
        if (list.size() > 1 || list.size() == 0) {
            return;
        }
        File file = (File)list.get(0);
        ResourceBundle resourceBundle = FolderChooserResource.getResourceBundle(Locale.getDefault());
        String string = JOptionPane.showInputDialog(BasicFolderChooserUI.access$000(this.this$0), resourceBundle.getString("FolderChooser.new.folderName"), resourceBundle.getString("FolderChooser.new.title"), 3);
        if (string != null) {
            string = this.eraseBlankInTheEnd(string);
            File file2 = new File(file, string);
            boolean bl = file2.mkdir();
            TreePath treePath = treePathArray[0];
            boolean bl2 = this.this$0._fileSystemTree.isExpanded(treePath);
            if (!bl2) {
                this.this$0._fileSystemTree.expandPath(treePath);
            }
            LazyMutableTreeNode lazyMutableTreeNode = (LazyMutableTreeNode)treePath.getLastPathComponent();
            BasicFileSystemTreeNode basicFileSystemTreeNode = BasicFileSystemTreeNode.createFileSystemTreeNode(file2, BasicFolderChooserUI.access$000(this.this$0));
            if (bl) {
                lazyMutableTreeNode.clear();
                int n = this.this$0._fileSystemTree.getModel().getIndexOfChild(lazyMutableTreeNode, basicFileSystemTreeNode);
                if (n != -1) {
                    ((BasicFileSystemTreeModel)this.this$0._fileSystemTree.getModel()).nodeStructureChanged(lazyMutableTreeNode);
                }
            }
            TreePath treePath2 = treePath.pathByAddingChild(basicFileSystemTreeNode);
            this.this$0._fileSystemTree.setSelectionPath(treePath2);
            this.this$0._fileSystemTree.scrollPathToVisible(treePath2);
        }
    }

    private String eraseBlankInTheEnd(String string) {
        char c2;
        int n;
        for (n = string.length() - 1; n >= 0 && ((c2 = string.charAt(n)) == ' ' || c2 == '\t'); --n) {
        }
        if (n < 0) {
            return null;
        }
        return string.substring(0, n + 1);
    }

    public final void myDocumentsButtonClicked() {
        File file = FileSystemView.getFileSystemView().getDefaultDirectory();
        BasicFolderChooserUI.access$100(this.this$0, file, true);
    }

    public final void desktopButtonClicked() {
        File file = FileSystemView.getFileSystemView().getHomeDirectory();
        BasicFolderChooserUI.access$100(this.this$0, file, true);
    }

    public final void refreshButtonClicked() {
        File file = BasicFolderChooserUI.access$000(this.this$0).getSelectedFolder();
        BasicFolderChooserUI.access$000(this.this$0).updateUI();
        while (file != null) {
            if (file.exists()) {
                BasicFolderChooserUI.access$000(this.this$0).getUI().ensureFileIsVisible(BasicFolderChooserUI.access$000(this.this$0), file);
                break;
            }
            if ((file = file.getParentFile()) != null) continue;
            break;
        }
    }

    public final void recentFolderSelected(File file) {
        new Thread(new BasicFolderChooserUI$3$1(this, file)).start();
    }

    private void setWaitCursor(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(BasicFolderChooserUI.access$000(this.this$0));
        if (bl) {
            Cursor cursor = new Cursor(3);
            this.m_oldCursor = window.getCursor();
            window.setCursor(cursor);
        } else if (this.m_oldCursor != null) {
            window.setCursor(this.m_oldCursor);
            this.m_oldCursor = null;
        }
    }

    public final List getSelectedFolders() {
        TreePath[] treePathArray = this.this$0._fileSystemTree.getSelectionPaths();
        return this.getSelectedFolders(treePathArray);
    }

    public final List getSelectedFolders(TreePath[] treePathArray) {
        if (treePathArray == null || treePathArray.length == 0) {
            return new ArrayList();
        }
        ArrayList<File> arrayList = new ArrayList<File>(treePathArray.length);
        for (TreePath treePath : treePathArray) {
            BasicFileSystemTreeNode basicFileSystemTreeNode = (BasicFileSystemTreeNode)treePath.getLastPathComponent();
            arrayList.add(basicFileSystemTreeNode.getFile());
        }
        return arrayList;
    }

    static final /* synthetic */ void access$200(BasicFolderChooserUI$3 basicFolderChooserUI$3, boolean bl) {
        basicFolderChooserUI$3.setWaitCursor(bl);
    }
}

