/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonListener$Actions;
import com.jidesoft.plaf.basic.BasicJideButtonUI;
import com.jidesoft.plaf.basic.LazyActionMap;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;

public class BasicJideButtonListener
extends BasicButtonListener {
    private boolean _mouseOver = false;

    public BasicJideButtonListener(AbstractButton abstractButton) {
        super(abstractButton);
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.isRolloverEnabled()) {
            buttonModel.setRollover(true);
        }
        this._mouseOver = true;
        if (buttonModel.isPressed()) {
            buttonModel.setArmed(true);
        }
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if ("buttonStyle".equals(string) || "opaque".equals(string) || "contentAreaFilled".equals(string)) {
            AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
            abstractButton.repaint();
        } else if ("orientation".equals(string) || "hideActionText".equals(string)) {
            AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
            abstractButton.invalidate();
            abstractButton.repaint();
        } else if ("verticalTextPosition".equals(string) || "horizontalTextPosition".equals(string)) {
            AbstractButton abstractButton = (AbstractButton)propertyChangeEvent.getSource();
            abstractButton.updateUI();
        }
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        this.cancelMenuIfNecessary(mouseEvent);
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.contains(mouseEvent.getPoint()) && abstractButton.isRolloverEnabled()) {
            buttonModel.setRollover(true);
        }
        if (!this._mouseOver) {
            buttonModel.setArmed(false);
            buttonModel.setPressed(false);
        }
        super.mouseReleased(mouseEvent);
        this.cancelMenuIfNecessary(mouseEvent);
    }

    private void cancelMenuIfNecessary(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        for (int i2 = menuElementArray.length - 1; i2 >= 0; --i2) {
            MenuElement menuElement = menuElementArray[i2];
            if (!(menuElement instanceof JPopupMenu) || !((JPopupMenu)menuElement).isAncestorOf(abstractButton)) continue;
            abstractButton.getModel().setPressed(false);
            abstractButton.getModel().setArmed(false);
            abstractButton.getModel().setRollover(false);
            if (Boolean.FALSE.equals(abstractButton.getClientProperty("JideButton.hidePopupMenu"))) break;
            menuSelectionManager.clearSelectedPath();
            break;
        }
    }

    public final void mouseExited(MouseEvent mouseEvent) {
        AbstractButton abstractButton = (AbstractButton)mouseEvent.getSource();
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton.isRolloverEnabled()) {
            buttonModel.setRollover(false);
        }
        buttonModel.setArmed(false);
        this._mouseOver = false;
    }

    final void updateMnemonicBinding(AbstractButton abstractButton) {
        int n = abstractButton.getMnemonic();
        if (n != 0) {
            InputMap inputMap = SwingUtilities.getUIInputMap(abstractButton, 2);
            if (inputMap == null) {
                inputMap = new ComponentInputMapUIResource(abstractButton);
                SwingUtilities.replaceUIInputMap(abstractButton, 2, inputMap);
            }
            inputMap.clear();
            inputMap.put(KeyStroke.getKeyStroke(n, 8, false), "pressed");
            inputMap.put(KeyStroke.getKeyStroke(n, 8, true), "released");
            inputMap.put(KeyStroke.getKeyStroke(n, 0, true), "released");
        } else {
            InputMap inputMap = SwingUtilities.getUIInputMap(abstractButton, 2);
            if (inputMap != null) {
                inputMap.clear();
            }
        }
    }

    private static final Object getUIOfType(ComponentUI componentUI, Class clazz) {
        if (clazz.isInstance(componentUI)) {
            return componentUI;
        }
        return null;
    }

    public final InputMap getInputMap(int n, JComponent jComponent) {
        BasicJideButtonUI basicJideButtonUI;
        if (n == 0 && (basicJideButtonUI = (BasicJideButtonUI)BasicJideButtonListener.getUIOfType(((AbstractButton)jComponent).getUI(), BasicJideButtonUI.class)) != null) {
            return (InputMap)UIDefaultsLookup.get(basicJideButtonUI.getPropertyPrefix() + "focusInputMap");
        }
        return null;
    }

    public static final void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new BasicJideButtonListener$Actions("pressed"));
        lazyActionMap.put(new BasicJideButtonListener$Actions("released"));
    }

    public final void installKeyboardActions(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        this.updateMnemonicBinding(abstractButton);
        LazyActionMap.installLazyActionMap(jComponent, BasicJideButtonListener.class, "JideButton.actionMap");
        InputMap inputMap = this.getInputMap(0, jComponent);
        SwingUtilities.replaceUIInputMap(jComponent, 0, inputMap);
    }
}

