/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.ButtonResources;
import com.jidesoft.dialog.JideOptionPane;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideOptionPaneUI$1;
import com.jidesoft.plaf.basic.BasicJideOptionPaneUI$2;
import com.jidesoft.plaf.basic.BasicJideOptionPaneUI$3;
import com.jidesoft.plaf.basic.BasicJideOptionPaneUI$4;
import com.jidesoft.plaf.basic.BasicJideOptionPaneUI$ButtonFactory;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.swing.JideBoxLayout;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.swing.PaintPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class BasicJideOptionPaneUI
extends BasicOptionPaneUI {
    private Container _detailsArea;
    private Container _buttonArea;
    private Container _bannerArea;
    private Component _titleComponent;
    private ThemePainter _painter;
    private PropertyChangeListener _propertyListener;
    private int _detailsPreferredWidth = -1;
    private static boolean _detailsVisible = false;

    public static final ComponentUI createUI(JComponent jComponent) {
        return new BasicJideOptionPaneUI();
    }

    protected final LayoutManager createLayoutManager() {
        return new JideBoxLayout(this.optionPane, 1);
    }

    public static final boolean isDetailsVisible() {
        return _detailsVisible;
    }

    public static final void setDetailsVisible(boolean bl) {
        _detailsVisible = bl;
    }

    protected final void installComponents() {
        boolean bl;
        boolean bl2 = bl = UIDefaultsLookup.get("OptionPane.showBanner") == null || UIDefaultsLookup.getBoolean("OptionPane.showBanner");
        if (bl) {
            this._bannerArea = this.createBannerArea();
            this.optionPane.add((Component)this._bannerArea, "fix");
        }
        Container container = this.createMessageArea();
        if (!bl) {
            this.addIcon(container);
        }
        LookAndFeel.installBorder((JComponent)container, "OptionPane.border");
        this.optionPane.add(container);
        Container container2 = this.createSeparator();
        if (container2 != null) {
            this.optionPane.add(container2);
        }
        this._buttonArea = this.createButtonArea();
        this.optionPane.add((Component)this._buttonArea, "fix");
        this.optionPane.applyComponentOrientation(this.optionPane.getComponentOrientation());
        if (this.shouldDetailsButtonVisible()) {
            this.updateDetailsComponent();
        }
    }

    protected final void installListeners() {
        super.installListeners();
        this._propertyListener = new BasicJideOptionPaneUI$1(this);
        this.optionPane.addPropertyChangeListener(this._propertyListener);
    }

    protected final void uninstallListeners() {
        super.uninstallListeners();
        this.optionPane.removePropertyChangeListener(this._propertyListener);
    }

    protected final void updateDetailsComponent() {
        if (this._detailsArea != null) {
            this.optionPane.remove(this._detailsArea);
            this._detailsArea = null;
        }
        this._detailsArea = this.createDetailsComponent();
        if (this._detailsArea != null) {
            this.optionPane.add((Component)this._detailsArea, "vary");
            this._detailsArea.setVisible(BasicJideOptionPaneUI.isDetailsVisible());
        }
    }

    protected final Container createMessageArea() {
        Serializable serializable;
        JPanel jPanel = new JPanel();
        Border border = (Border)UIDefaultsLookup.get("OptionPane.messageAreaBorder");
        if (border != null) {
            jPanel.setBorder(border);
        }
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.setName("OptionPane.body");
        jPanel3.setName("OptionPane.realBody");
        if (this.getIcon() != null) {
            serializable = new JPanel();
            serializable.setName("OptionPane.separator");
            serializable.setPreferredSize(new Dimension(15, 1));
            jPanel3.add((Component)serializable, "Before");
        }
        jPanel3.add((Component)jPanel2, "Center");
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridy = 0;
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridwidth = 0;
        ((GridBagConstraints)serializable).gridheight = 1;
        int n = UIDefaultsLookup.getInt("OptionPane.messageAnchor");
        ((GridBagConstraints)serializable).anchor = n == 0 ? 10 : n;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 3, 0);
        Object object = this.getMessage();
        this.addMessageComponents(jPanel2, (GridBagConstraints)serializable, object, this.getMaxCharactersPerLineCount(), false);
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    protected final Container createSeparator() {
        return new JSeparator();
    }

    protected final void installDefaults() {
        super.installDefaults();
        this.optionPane.setBorder(BorderFactory.createEmptyBorder());
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
    }

    protected final void uninstallDefaults() {
        super.uninstallDefaults();
        this._painter = null;
    }

    protected final Container createDetailsComponent() {
        if (!(this.optionPane instanceof JideOptionPane)) {
            return null;
        }
        JideOptionPane jideOptionPane = (JideOptionPane)this.optionPane;
        Object object = jideOptionPane.getDetails();
        if (object instanceof Container) {
            this._detailsPreferredWidth = ((Container)object).getPreferredSize().width;
            return (Container)object;
        }
        if (object instanceof Component) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)object);
            this._detailsPreferredWidth = jPanel.getPreferredSize().width;
            return jPanel;
        }
        if (object instanceof String) {
            JTextArea jTextArea = new JTextArea((String)object);
            jTextArea.setEditable(false);
            jTextArea.setRows(20);
            jTextArea.setColumns(60);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add(new JScrollPane(jTextArea));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 6, 10, 6));
            this._detailsPreferredWidth = jPanel.getPreferredSize().width;
            return jPanel;
        }
        return null;
    }

    protected final Container createButtonArea() {
        boolean bl;
        int n = UIDefaultsLookup.getInt("OptionPane.buttonOrientation");
        n = n == 0 ? 0 : n;
        ButtonPanel buttonPanel = new ButtonPanel(n);
        Border border = (Border)UIDefaultsLookup.get("OptionPane.buttonAreaBorder");
        buttonPanel.setName("OptionPane.buttonArea");
        if (border != null) {
            buttonPanel.setBorder(border);
        }
        buttonPanel.setSizeConstraint((bl = UIDefaultsLookup.getBoolean("OptionPane.sameSizeButtons")) ? 0 : 1);
        int n2 = UIDefaultsLookup.getInt("OptionPane.buttonPadding");
        n2 = n2 == 0 ? 6 : n2;
        buttonPanel.setButtonGap(n2);
        this.addButtonComponents(buttonPanel, this.getButtons(), this.getInitialValueIndex());
        return buttonPanel;
    }

    protected final void addButtonComponents(Container container, Object[] objectArray, int n) {
        if (objectArray != null && objectArray.length > 0) {
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                JButton jButton;
                Component component;
                Object object = objectArray[i2];
                if (object instanceof Component) {
                    component = (Component)object;
                    container.add(component, "ALTERNATIVE");
                    this.hasCustomComponents = true;
                } else {
                    jButton = object instanceof BasicJideOptionPaneUI$ButtonFactory ? ((BasicJideOptionPaneUI$ButtonFactory)object).createButton() : (object instanceof Icon ? new JButton((Icon)object) : new JButton(object.toString()));
                    jButton.setMultiClickThreshhold(UIDefaultsLookup.getInt("OptionPane.buttonClickThreshhold"));
                    this.configureButton(jButton);
                    if ("YES".equals(jButton.getName()) || "NO".equals(jButton.getName()) || "OK".equals(jButton.getName()) || "CLOSE".equals(jButton.getName()) || "FINISH".equals(jButton.getName())) {
                        container.add((Component)jButton, "AFFIRMATIVE");
                    } else if ("CANCEL".equals(jButton.getName())) {
                        container.add((Component)jButton, "CANCEL");
                    } else if ("HELP".equals(jButton.getName())) {
                        container.add((Component)jButton, "HELP");
                    } else {
                        container.add((Component)jButton, "ALTERNATIVE");
                    }
                    if ("DETAILS".equals(jButton.getName())) {
                        jButton.addActionListener(new BasicJideOptionPaneUI$2(this));
                        jButton.setVisible(this.shouldDetailsButtonVisible());
                    } else {
                        ActionListener actionListener = this.createButtonActionListener(i2);
                        if (actionListener != null) {
                            jButton.addActionListener(actionListener);
                        }
                    }
                    component = jButton;
                }
                if (i2 != n) continue;
                this.initialFocusComponent = component;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                jButton = (JButton)this.initialFocusComponent;
                jButton.addAncestorListener(new BasicJideOptionPaneUI$3(this));
            }
        }
    }

    protected final Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] objectArray = this.optionPane.getOptions();
            if (objectArray == null) {
                Object[] objectArray2;
                int n = this.optionPane.getOptionType();
                Locale locale = this.optionPane.getLocale();
                if (n == 0) {
                    objectArray2 = new BasicJideOptionPaneUI$ButtonFactory[]{new BasicJideOptionPaneUI$ButtonFactory("YES", UIDefaultsLookup.getString("OptionPane.yesButtonText", locale), this.getMnemonic("OptionPane.yesButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.yesIcon")), new BasicJideOptionPaneUI$ButtonFactory("NO", UIDefaultsLookup.getString("OptionPane.noButtonText", locale), this.getMnemonic("OptionPane.noButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.noIcon"))};
                } else if (n == 1) {
                    objectArray2 = new BasicJideOptionPaneUI$ButtonFactory[]{new BasicJideOptionPaneUI$ButtonFactory("YES", UIDefaultsLookup.getString("OptionPane.yesButtonText", locale), this.getMnemonic("OptionPane.yesButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.yesIcon")), new BasicJideOptionPaneUI$ButtonFactory("NO", UIDefaultsLookup.getString("OptionPane.noButtonText", locale), this.getMnemonic("OptionPane.noButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.noIcon")), new BasicJideOptionPaneUI$ButtonFactory("CANCEL", UIDefaultsLookup.getString("OptionPane.cancelButtonText", locale), this.getMnemonic("OptionPane.cancelButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.cancelIcon"))};
                } else if (n == 2) {
                    objectArray2 = new BasicJideOptionPaneUI$ButtonFactory[]{new BasicJideOptionPaneUI$ButtonFactory("OK", JideSwingUtilities.getOKString(locale), this.getMnemonic("OptionPane.okButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.okIcon")), new BasicJideOptionPaneUI$ButtonFactory("CANCEL", JideSwingUtilities.getCancelString(locale), this.getMnemonic("OptionPane.cancelButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.cancelIcon"))};
                } else if (n == 3) {
                    objectArray2 = new BasicJideOptionPaneUI$ButtonFactory[1];
                    ResourceBundle resourceBundle = ButtonResources.getResourceBundle(this.optionPane.getLocale());
                    objectArray2[0] = new BasicJideOptionPaneUI$ButtonFactory("CLOSE", this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.close") : resourceBundle.getString("Button.close"), this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.close.mnemonic").charAt(0) : resourceBundle.getString("Button.close.mnemonic").charAt(0), null);
                } else {
                    objectArray2 = new BasicJideOptionPaneUI$ButtonFactory[]{new BasicJideOptionPaneUI$ButtonFactory("OK", JideSwingUtilities.getOKString(locale), this.getMnemonic("OptionPane.okButtonMnemonic", locale), (Icon)UIDefaultsLookup.get("OptionPane.okIcon"))};
                }
                return this.addDetailsButton(objectArray2, true);
            }
            return this.addDetailsButton(objectArray, true);
        }
        return null;
    }

    protected final Object[] addDetailsButton(Object[] objectArray, boolean bl) {
        if (bl) {
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            ResourceBundle resourceBundle = ButtonResources.getResourceBundle(this.optionPane.getLocale());
            objectArray2[objectArray2.length - 1] = BasicJideOptionPaneUI.isDetailsVisible() ? new BasicJideOptionPaneUI$ButtonFactory("DETAILS", this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.hideDetails") : resourceBundle.getString("Button.hideDetails"), this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.hideDetails.mnemonic").charAt(0) : resourceBundle.getString("Button.hideDetails.mnemonic").charAt(0), null) : new BasicJideOptionPaneUI$ButtonFactory("DETAILS", this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.showDetails") : resourceBundle.getString("Button.showDetails"), this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getResourceString("Button.showDetails.mnemonic").charAt(0) : resourceBundle.getString("Button.showDetails.mnemonic").charAt(0), null);
            return objectArray2;
        }
        return objectArray;
    }

    private boolean shouldDetailsButtonVisible() {
        return this.optionPane instanceof JideOptionPane && ((JideOptionPane)this.optionPane).getDetails() != null;
    }

    protected final void configureButton(JButton jButton) {
        Font font = (Font)UIDefaultsLookup.get("OptionPane.buttonFont");
        if (font != null) {
            jButton.setFont(font);
        }
    }

    protected final int getMnemonic(String string, Locale locale) {
        String string2 = (String)UIDefaultsLookup.get(string, locale);
        if (string2 == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    protected final void addIcon(Container container) {
        Icon icon = this.getIcon();
        if (icon != null) {
            JLabel jLabel = new JLabel(icon);
            jLabel.setName("OptionPane.iconLabel");
            container.add((Component)jLabel, "Before");
        }
    }

    protected final Container createBannerArea() {
        BasicJideOptionPaneUI$4 basicJideOptionPaneUI$4 = new BasicJideOptionPaneUI$4(this);
        this.customizeBannerArea(basicJideOptionPaneUI$4);
        basicJideOptionPaneUI$4.setLayout(new BorderLayout(10, 10));
        this.addIcon(basicJideOptionPaneUI$4);
        this.updateTitleComponent(basicJideOptionPaneUI$4);
        basicJideOptionPaneUI$4.add((Component)new JLabel(UIDefaultsLookup.getIcon("OptionPane.bannerIcon")), "After");
        return basicJideOptionPaneUI$4;
    }

    protected final void customizeBannerArea(PaintPanel paintPanel) {
        Object object;
        Paint paint = (Paint)UIDefaultsLookup.get("OptionPane.bannerBackgroundPaint");
        if (paint != null) {
            paintPanel.setBackgroundPaint(paint);
        } else {
            boolean bl;
            object = UIDefaultsLookup.getColor("OptionPane.bannerBackgroundDk");
            Object object2 = UIDefaultsLookup.getColor("OptionPane.bannerBackgroundLt");
            boolean bl2 = bl = UIDefaultsLookup.get("OptionPane.bannerBackgroundDirection") == null || UIDefaultsLookup.getBoolean("OptionPane.bannerBackgroundDirection");
            if (object == null && object2 != null) {
                object = object2;
                paintPanel.setGradientPaint((Color)(object != null ? object : this.getPainter().getOptionPaneBannerLt()), (Color)(object2 != null ? object2 : this.getPainter().getOptionPaneBannerDk()), bl);
            } else if (object != null && object2 == null) {
                object2 = object;
                paintPanel.setGradientPaint((Color)(object != null ? object : this.getPainter().getOptionPaneBannerLt()), (Color)(object2 != null ? object2 : this.getPainter().getOptionPaneBannerDk()), bl);
            } else if (object != null && object2 != null) {
                paintPanel.setGradientPaint((Color)(object != null ? object : this.getPainter().getOptionPaneBannerLt()), (Color)(object2 != null ? object2 : this.getPainter().getOptionPaneBannerDk()), bl);
            }
        }
        object = UIDefaultsLookup.getBorder("OptionPane.bannerBorder");
        paintPanel.setBorder((Border)(object != null ? object : BorderFactory.createEmptyBorder(0, 10, 0, 0)));
    }

    private void updateTitleComponent(Container container) {
        Object object;
        if (container == null) {
            return;
        }
        if (this._titleComponent != null) {
            container.remove(this._titleComponent);
            this._titleComponent = null;
        }
        Object object2 = object = this.optionPane instanceof JideOptionPane ? ((JideOptionPane)this.optionPane).getTitle() : null;
        if (object instanceof String) {
            if (((String)object).startsWith("<html>") || ((String)object).startsWith("<HTML>")) {
                this._titleComponent = new JLabel((String)object);
            } else {
                String[] stringArray = BasicJideOptionPaneUI.fitInWidth((String)object, UIDefaultsLookup.getInt("OptionPane.bannerMaxCharsPerLine"));
                NullPanel nullPanel = new NullPanel();
                nullPanel.setLayout(new BoxLayout(nullPanel, 1));
                nullPanel.setOpaque(false);
                nullPanel.add(Box.createGlue());
                for (String string : stringArray) {
                    JLabel jLabel = new JLabel(string);
                    jLabel.setFont(jLabel.getFont().deriveFont(UIDefaultsLookup.getInt("OptionPane.bannerFontStyle"), UIDefaultsLookup.getInt("OptionPane.bannerFontSize")));
                    Color color = UIDefaultsLookup.getColor("OptionPane.bannerForeground");
                    jLabel.setForeground(color != null ? color : this.getPainter().getOptionPaneBannerForeground());
                    nullPanel.add(jLabel);
                }
                nullPanel.add(Box.createGlue());
                this._titleComponent = nullPanel;
            }
        } else if (object instanceof Component) {
            this._titleComponent = (Component)object;
        }
        if (this._titleComponent != null) {
            container.add(this._titleComponent, "Center");
        }
    }

    private static String[] fitInWidth(String string, int n) {
        if (string == null) {
            string = "";
        }
        String string2 = BasicJideOptionPaneUI.blankString(n, (byte)32);
        string = BasicJideOptionPaneUI.replaceOccurrences(string, "\n", string2);
        string = BasicJideOptionPaneUI.replaceOccurrences(string, "\t", "    ");
        ArrayList<String> arrayList = new ArrayList<String>();
        string = string.trim();
        while (string.length() > n) {
            String string3;
            int n2 = n;
            if (Character.isLetterOrDigit(string.charAt(n))) {
                char c2 = string.charAt(--n2);
                while (Character.isLetterOrDigit(c2) && n2 > 0) {
                    c2 = string.charAt(--n2);
                }
                n2 = n2 == 0 && Character.isLetterOrDigit(c2) ? n : ++n2;
            }
            if ((string3 = string.substring(0, n2)).length() < n) {
                string3 = string3 + BasicJideOptionPaneUI.blankString(n - string3.length(), (byte)32);
            }
            arrayList.add(string3);
            string = string.substring(n2).trim();
        }
        if (string.length() < n) {
            string = string + BasicJideOptionPaneUI.blankString(n - string.length(), (byte)32);
        }
        arrayList.add(string);
        if (arrayList.size() == 1) {
            return new String[]{((String)arrayList.get(0)).trim()};
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String blankString(int n, byte by) {
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, by);
        return new String(byArray);
    }

    private static String replaceOccurrences(String string, String string2, String string3) {
        int n;
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = 0;
        while ((n = BasicJideOptionPaneUI.indexOf(stringBuffer, string2, n2)) >= 0) {
            stringBuffer.replace(n, n + string2.length(), string3);
            n2 = n + string3.length();
        }
        return stringBuffer.toString();
    }

    private static int indexOf(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, int n5) {
        if (n5 >= n2) {
            return n4 == 0 ? n2 : -1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 == 0) {
            return n5;
        }
        char c2 = cArray2[n3];
        int n6 = n + n5;
        int n7 = n + (n2 - n4);
        block0: while (true) {
            if (n6 <= n7 && cArray[n6] != c2) {
                ++n6;
                continue;
            }
            if (n6 > n7) {
                return -1;
            }
            int n8 = n6 + 1;
            int n9 = n8 + n4 - 1;
            int n10 = n3 + 1;
            while (n8 < n9) {
                if (cArray[n8++] == cArray2[n10++]) continue;
                ++n6;
                continue block0;
            }
            break;
        }
        return n6 - n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indexOf(StringBuffer stringBuffer, String string, int n) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            int n2 = stringBuffer.length();
            char[] cArray = new char[n2];
            stringBuffer.getChars(0, n2, cArray, 0);
            return BasicJideOptionPaneUI.indexOf(cArray, 0, n2, string.toCharArray(), 0, string.length(), n);
        }
    }

    public final ThemePainter getPainter() {
        return this._painter;
    }

    static final /* synthetic */ Container access$000(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI._buttonArea;
    }

    static final /* synthetic */ Container access$100(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI._bannerArea;
    }

    static final /* synthetic */ void access$200(BasicJideOptionPaneUI basicJideOptionPaneUI, Container container) {
        basicJideOptionPaneUI.updateTitleComponent(container);
    }

    static final /* synthetic */ JOptionPane access$300(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI.optionPane;
    }

    static final /* synthetic */ Container access$400(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI._detailsArea;
    }

    static final /* synthetic */ JOptionPane access$500(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI.optionPane;
    }

    static final /* synthetic */ JOptionPane access$600(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI.optionPane;
    }

    static final /* synthetic */ JOptionPane access$700(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI.optionPane;
    }

    static final /* synthetic */ JOptionPane access$800(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI.optionPane;
    }

    static final /* synthetic */ JOptionPane access$900(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI.optionPane;
    }

    static final /* synthetic */ JOptionPane access$1000(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI.optionPane;
    }

    static final /* synthetic */ JOptionPane access$1100(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI.optionPane;
    }

    static final /* synthetic */ JOptionPane access$1200(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI.optionPane;
    }

    static final /* synthetic */ int access$1300(BasicJideOptionPaneUI basicJideOptionPaneUI) {
        return basicJideOptionPaneUI._detailsPreferredWidth;
    }
}

