/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.eclipse;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.eclipse.EclipseMenuItemUI;
import com.jidesoft.plaf.eclipse.EclipseMenuUI$MenuDragMouseHandler;
import com.jidesoft.plaf.eclipse.EclipseMenuUI$MenuHandler;
import com.jidesoft.plaf.eclipse.EclipseMenuUI$MenuKeyHandler;
import com.jidesoft.plaf.eclipse.EclipseMenuUI$MouseInputHandler;
import com.jidesoft.plaf.eclipse.EclipseMenuUI$PostAction;
import com.jidesoft.plaf.eclipse.EclipseMenuUI$PropertyChangeHandler;
import com.jidesoft.swing.JideSwingUtilities;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

public class EclipseMenuUI
extends EclipseMenuItemUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private int lastMnemonic = 0;
    private static boolean crossMenuMnemonic = true;
    private boolean isMouseOver = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new EclipseMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        ((JMenu)this.menuItem).setDelay(200);
        crossMenuMnemonic = UIDefaultsLookup.getBoolean("Menu.crossMenuMnemonic");
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).isTopLevelMenu()) {
            super.paintBackground(graphics, jMenuItem, color);
            return;
        }
        ButtonModel buttonModel = jMenuItem.getModel();
        Color color2 = graphics.getColor();
        int n = 0;
        int n2 = 0;
        if (JideSwingUtilities.getOrientationOf(jMenuItem) == 0) {
            n = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
        }
        Color color3 = UIDefaultsLookup.getColor("controlDkShadow");
        Color color4 = UIDefaultsLookup.getColor("Menu.mouseHoverBackground");
        Border border = UIDefaultsLookup.getBorder("Menu.mouseHoverBorder");
        Border border2 = UIDefaultsLookup.getBorder("Menu.mouseSelectedBorder");
        if (jMenuItem.isOpaque()) {
            if (jMenuItem.getParent() != null) {
                graphics.setColor(jMenuItem.getParent().getBackground());
            } else {
                graphics.setColor(jMenuItem.getBackground());
            }
            graphics.fillRect(0, 0, n, n2);
        }
        if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
            if (border2 != null) {
                border2.paintBorder(jMenuItem, graphics, 0, 0, n - 1, n2);
            }
            graphics.setColor(color4);
            graphics.fillRect(1, 1, n - 3, n2 - 2);
        } else if (this.isMouseOver() && buttonModel.isEnabled()) {
            if (border != null) {
                border.paintBorder(jMenuItem, graphics, 0, 0, n - 1, n2);
            }
            graphics.setColor(color4);
            graphics.fillRect(1, 1, n - 3, n2 - 2);
        }
        if (this.isDownArrowVisible(jMenuItem.getParent())) {
            int n3 = n - 9;
            if (buttonModel.isSelected() || buttonModel.isArmed() || buttonModel.isPressed() || this.isMouseOver()) {
                JideSwingUtilities.paintArrow(graphics, this.selectionForeground, n3 - 2, n2 / 2 - 1, 5, 0);
            } else {
                JideSwingUtilities.paintArrow(graphics, jMenuItem.getForeground(), n3 - 2, n2 / 2 - 1, 5, 0);
            }
        }
        graphics.setColor(color2);
    }

    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = this.createMenuListener(this.menuItem);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    final void updateMnemonicBinding() {
        int n = this.menuItem.getModel().getMnemonic();
        int[] nArray = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
        if (n == this.lastMnemonic || nArray == null) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            for (int n2 : nArray) {
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, n2, false));
            }
        }
        if (n != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            for (int n2 : nArray) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(n, n2, false), "selectMenu");
            }
        }
        this.lastMnemonic = n;
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    final ActionMap getActionMap() {
        return this.createActionMap();
    }

    final ActionMap createActionMap() {
        ActionMap actionMap = super.createActionMap();
        if (actionMap != null) {
            actionMap.put("selectMenu", new EclipseMenuUI$PostAction((JMenu)this.menuItem, true));
        }
        return actionMap;
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new EclipseMenuUI$MouseInputHandler(this);
    }

    protected final MenuListener createMenuListener(JComponent jComponent) {
        return new EclipseMenuUI$MenuHandler(null);
    }

    protected final ChangeListener createChangeListener(JComponent jComponent) {
        return null;
    }

    protected final PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new EclipseMenuUI$PropertyChangeHandler(this, null);
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    protected final MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new EclipseMenuUI$MenuDragMouseHandler(this, null);
    }

    protected final MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new EclipseMenuUI$MenuKeyHandler(this, null);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension dimension = jComponent.getPreferredSize();
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return null;
    }

    public static final void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new EclipseMenuUI$PostAction(jMenu, false));
        timer.setRepeats(false);
        timer.start();
    }

    protected static final void appendPath(MenuElement[] menuElementArray, MenuElement menuElement) {
        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
        menuElementArray2[menuElementArray.length] = menuElement;
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
    }

    static final JPopupMenu getActivePopupMenu() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        for (int i2 = menuElementArray.length - 1; i2 >= 0; --i2) {
            MenuElement menuElement = menuElementArray[i2];
            if (!(menuElement instanceof JPopupMenu)) continue;
            return (JPopupMenu)menuElement;
        }
        return null;
    }

    protected final void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        int n;
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!(jMenuItem instanceof JMenu && ((JMenu)jMenuItem).isTopLevelMenu() || !jMenuItem.getComponentOrientation().isLeftToRight())) {
            int n2 = UIDefaultsLookup.getInt("MenuItem.textIconGap");
            n = UIDefaultsLookup.getInt("MenuItem.shadowWidth");
            rectangle.x = n + n2;
        }
        if (!buttonModel.isEnabled()) {
            ++rectangle.y;
            WindowsGraphicsUtils.paintText((Graphics)graphics, (AbstractButton)jMenuItem, (Rectangle)rectangle, (String)string, (int)0);
        } else {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            n = jMenuItem.getDisplayedMnemonicIndex();
            if (WindowsLookAndFeel.isMnemonicHidden()) {
                n = -1;
            }
            Color color = graphics.getColor();
            if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected() || this.isMouseOver()) {
                graphics.setColor(this.selectionForeground);
            }
            JideSwingUtilities.drawStringUnderlineCharAt(jMenuItem, graphics, string, n, rectangle.x, rectangle.y + fontMetrics.getAscent() - 1);
            graphics.setColor(color);
        }
    }

    protected final void setMouseOver(boolean bl) {
        this.isMouseOver = bl;
        this.menuItem.getModel().setRollover(this.isMouseOver);
    }

    protected final boolean isMouseOver() {
        return this.isMouseOver;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu() && this.isDownArrowVisible(this.menuItem.getParent())) {
            if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
                dimension.width += 11;
            } else {
                dimension.height += 11;
            }
        }
        return dimension;
    }

    static final /* synthetic */ boolean access$400() {
        return crossMenuMnemonic;
    }
}

