/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.metal;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.metal.MetalMenuItemUI;
import com.jidesoft.plaf.metal.MetalMenuUI$MenuDragMouseHandler;
import com.jidesoft.plaf.metal.MetalMenuUI$MenuKeyHandler;
import com.jidesoft.plaf.metal.MetalMenuUI$MouseInputHandler;
import com.jidesoft.plaf.metal.MetalMenuUI$PostAction;
import com.jidesoft.plaf.metal.MetalMenuUI$PropertyChangeHandler;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class MetalMenuUI
extends MetalMenuItemUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected MenuListener menuListener;
    private int lastMnemonic = 0;
    private InputMap selectedWindowInputMap;
    private static final boolean TRACE = false;
    private static final boolean VERBOSE = false;
    private static final boolean DEBUG = false;
    private static boolean crossMenuMnemonic = true;
    private boolean isMouseOver = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateDefaultBackgroundColor();
        ((JMenu)this.menuItem).setDelay(200);
        crossMenuMnemonic = UIDefaultsLookup.getBoolean("Menu.crossMenuMnemonic");
    }

    protected String getPropertyPrefix() {
        return "Menu";
    }

    protected void installListeners() {
        super.installListeners();
        if (this.changeListener == null) {
            this.changeListener = this.createChangeListener(this.menuItem);
        }
        if (this.changeListener != null) {
            this.menuItem.addChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener(this.menuItem);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener == null) {
            this.menuListener = this.createMenuListener(this.menuItem);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).addMenuListener(this.menuListener);
        }
    }

    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.updateMnemonicBinding();
    }

    final void updateMnemonicBinding() {
        int n = this.menuItem.getModel().getMnemonic();
        int[] nArray = (int[])UIDefaultsLookup.get("Menu.shortcutKeys");
        if (n == this.lastMnemonic || nArray == null) {
            return;
        }
        if (this.lastMnemonic != 0 && this.windowInputMap != null) {
            for (int n2 : nArray) {
                this.windowInputMap.remove(KeyStroke.getKeyStroke(this.lastMnemonic, n2, false));
            }
        }
        if (n != 0) {
            if (this.windowInputMap == null) {
                this.windowInputMap = this.createInputMap(2);
                SwingUtilities.replaceUIInputMap(this.menuItem, 2, this.windowInputMap);
            }
            for (int n2 : nArray) {
                this.windowInputMap.put(KeyStroke.getKeyStroke(n, n2, false), "selectMenu");
            }
        }
        this.lastMnemonic = n;
    }

    protected void uninstallKeyboardActions() {
        super.uninstallKeyboardActions();
    }

    final ActionMap getActionMap() {
        return this.createActionMap();
    }

    final ActionMap createActionMap() {
        ActionMap actionMap = super.createActionMap();
        if (actionMap != null) {
            actionMap.put("selectMenu", new MetalMenuUI$PostAction((JMenu)this.menuItem, true));
        }
        return actionMap;
    }

    protected MouseInputListener createMouseInputListener(JComponent jComponent) {
        return new MetalMenuUI$MouseInputHandler(this);
    }

    protected final MenuListener createMenuListener(JComponent jComponent) {
        return null;
    }

    protected final ChangeListener createChangeListener(JComponent jComponent) {
        return null;
    }

    protected final PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new MetalMenuUI$PropertyChangeHandler(this, null);
    }

    protected void uninstallDefaults() {
        this.menuItem.setArmed(false);
        this.menuItem.setSelected(false);
        this.menuItem.resetKeyboardActions();
        super.uninstallDefaults();
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.changeListener != null) {
            this.menuItem.removeChangeListener(this.changeListener);
        }
        if (this.propertyChangeListener != null) {
            this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.menuListener != null) {
            ((JMenu)this.menuItem).removeMenuListener(this.menuListener);
        }
        this.changeListener = null;
        this.propertyChangeListener = null;
        this.menuListener = null;
    }

    protected final MenuDragMouseListener createMenuDragMouseListener(JComponent jComponent) {
        return new MetalMenuUI$MenuDragMouseHandler(this, null);
    }

    protected final MenuKeyListener createMenuKeyListener(JComponent jComponent) {
        return new MetalMenuUI$MenuKeyHandler(this, null);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (((JMenu)this.menuItem).isTopLevelMenu()) {
            Dimension dimension = jComponent.getPreferredSize();
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return null;
    }

    protected static final void setupPostTimer(JMenu jMenu) {
        Timer timer = new Timer(jMenu.getDelay(), new MetalMenuUI$PostAction(jMenu, false));
        timer.setRepeats(false);
        timer.start();
    }

    protected static final void appendPath(MenuElement[] menuElementArray, MenuElement menuElement) {
        MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
        System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
        menuElementArray2[menuElementArray.length] = menuElement;
        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
    }

    private void updateDefaultBackgroundColor() {
        if (!UIDefaultsLookup.getBoolean("Menu.useMenuBarBackgroundForTopLevel")) {
            return;
        }
        JMenu jMenu = (JMenu)this.menuItem;
        if (jMenu.getBackground() instanceof UIResource) {
            if (jMenu.isTopLevelMenu()) {
                jMenu.setBackground(UIDefaultsLookup.getColor("MenuBar.background"));
            } else {
                jMenu.setBackground(UIDefaultsLookup.getColor(this.getPropertyPrefix() + ".background"));
            }
        }
    }

    static final JPopupMenu getActivePopupMenu() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        for (int i2 = menuElementArray.length - 1; i2 >= 0; --i2) {
            MenuElement menuElement = menuElementArray[i2];
            if (!(menuElement instanceof JPopupMenu)) continue;
            return (JPopupMenu)menuElement;
        }
        return null;
    }

    protected final void setMouseOver(boolean bl) {
        this.isMouseOver = bl;
        this.menuItem.getModel().setRollover(this.isMouseOver);
    }

    protected final boolean isMouseOver() {
        return this.isMouseOver;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this.menuItem instanceof JMenu && ((JMenu)this.menuItem).isTopLevelMenu() && this.isDownArrowVisible(this.menuItem.getParent())) {
            if (JideSwingUtilities.getOrientationOf(this.menuItem) == 0) {
                dimension.width += 11;
            } else {
                dimension.height += 11;
            }
        }
        return dimension;
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        if (!(jMenuItem instanceof JMenu) || !((JMenu)jMenuItem).isTopLevelMenu()) {
            super.paintBackground(graphics, jMenuItem, color);
            return;
        }
        Color color2 = graphics.getColor();
        int n = 0;
        int n2 = 0;
        if (JideSwingUtilities.getOrientationOf(jMenuItem) == 0) {
            n = jMenuItem.getWidth();
            n2 = jMenuItem.getHeight();
        } else {
            n = jMenuItem.getHeight();
            n2 = jMenuItem.getWidth();
        }
        if (jMenuItem.isOpaque()) {
            if (jMenuItem.getModel().isArmed() || jMenuItem instanceof JMenu && jMenuItem.getModel().isSelected()) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n, n2);
            } else {
                graphics.setColor(jMenuItem.getBackground());
                graphics.fillRect(0, 0, n, n2);
            }
            graphics.setColor(color2);
        }
        if (this.isDownArrowVisible(jMenuItem.getParent())) {
            graphics.setColor(Color.BLACK);
            int n3 = n - 9;
            graphics.drawLine(n3 - 2, n2 / 2 - 1, n3 + 2, n2 / 2 - 1);
            graphics.drawLine(n3 - 1, n2 / 2, n3 + 1, n2 / 2);
            graphics.drawLine(n3, n2 / 2 + 1, n3, n2 / 2 + 1);
        }
    }

    static final /* synthetic */ boolean access$300() {
        return crossMenuMnemonic;
    }

    static final /* synthetic */ void access$400(MetalMenuUI metalMenuUI) {
        metalMenuUI.updateDefaultBackgroundColor();
    }
}

