/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.GradientCache;
import com.jidesoft.swing.GradientInfo;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;

class FastGradientPainter {
    private static GradientCache gradientCache = new GradientCache();

    private FastGradientPainter() {
    }

    public static final void clearGradientCache() {
        gradientCache.clear();
    }

    public static final void drawGradient(Graphics2D graphics2D, Shape shape, Color color, Color color2, boolean bl) {
        Rectangle rectangle = shape.getBounds();
        if (rectangle.height <= 0 || rectangle.width <= 0) {
            return;
        }
        int n = bl ? rectangle.height : rectangle.width;
        GradientInfo gradientInfo = new GradientInfo(graphics2D.getDeviceConfiguration(), n, color, color2, bl);
        BufferedImage bufferedImage = gradientCache.retrieve(gradientInfo);
        if (bufferedImage == null) {
            bufferedImage = FastGradientPainter.createGradientTile(gradientInfo);
            gradientCache.store(gradientInfo, bufferedImage);
        }
        Shape shape2 = null;
        boolean bl2 = false;
        if (!rectangle.equals(shape)) {
            bl2 = true;
            shape2 = graphics2D.getClip();
            graphics2D.clip(shape);
        }
        if (bl) {
            int n2;
            int n3 = bufferedImage.getWidth();
            int n4 = rectangle.width / n3;
            for (n2 = 0; n2 < n4; ++n2) {
                graphics2D.drawImage((Image)bufferedImage, rectangle.x + n2 * n3, rectangle.y, null);
            }
            n2 = rectangle.width % n3;
            if (n2 > 0) {
                graphics2D.drawImage(bufferedImage, rectangle.x + n4 * n3, rectangle.y, rectangle.x + n4 * n3 + n2, rectangle.y + n, 0, 0, n2, n, null);
            }
        } else {
            int n5;
            int n6 = bufferedImage.getHeight();
            int n7 = rectangle.height / n6;
            for (n5 = 0; n5 < n7; ++n5) {
                graphics2D.drawImage((Image)bufferedImage, rectangle.x, rectangle.y + n5 * n6, null);
            }
            n5 = rectangle.height % n6;
            if (n5 > 0) {
                graphics2D.drawImage(bufferedImage, rectangle.x, rectangle.y + n7 * n6, rectangle.x + n, rectangle.y + n7 * n6 + n5, 0, 0, n, n5, null);
            }
        }
        if (bl2) {
            graphics2D.setClip(shape2);
        }
    }

    private static BufferedImage createGradientTile(GradientInfo gradientInfo) {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        boolean bl2 = bl = gradientInfo.startColor.getTransparency() > 1 || gradientInfo.endColor.getTransparency() > 1;
        if (gradientInfo.isVertical) {
            n4 = 0;
            n2 = n3 = gradientInfo.length;
            n = 32;
        } else {
            n = n4 = gradientInfo.length;
            n3 = 0;
            n2 = 32;
        }
        BufferedImage bufferedImage = gradientInfo.gfxConfig.createCompatibleImage(n, n2, bl ? 3 : 1);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, gradientInfo.startColor, n4, n3, gradientInfo.endColor);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.dispose();
        return bufferedImage;
    }
}

