/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.GripperUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.DraggableHandle;
import java.awt.Cursor;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class Gripper
extends JComponent
implements SwingConstants,
Alignable,
DraggableHandle,
UIResource {
    private static final String uiClassID = "GripperUI";
    public static final String ROLLOVER_ENABLED_CHANGED_PROPERTY = "rolloverEnabled";
    private boolean _rolloverEnabled = false;
    private boolean _rollover;
    public static final String ROLLOVER_PROPERTY = "ROLLOVER";
    public static final String SELECTED_PROPERTY = "SELECTED";
    private int _orientation;
    private boolean _selected;

    public Gripper() {
        this(0);
    }

    public Gripper(int n) {
        this.setOrientation(n);
        this.setFocusable(false);
        this.updateUI();
    }

    public final GripperUI getUI() {
        return (GripperUI)this.ui;
    }

    public final void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    public final String getUIClassID() {
        return uiClassID;
    }

    public final boolean supportVerticalOrientation() {
        return true;
    }

    public final boolean supportHorizontalOrientation() {
        return true;
    }

    public final void setOrientation(int n) {
        int n2 = this._orientation;
        if (n2 != n) {
            this._orientation = n;
            this.firePropertyChange("orientation", n2, n);
        }
    }

    public final int getOrientation() {
        return this._orientation;
    }

    public final Cursor getCursor() {
        if (this.isEnabled()) {
            return Cursor.getPredefinedCursor(13);
        }
        return super.getCursor();
    }

    public final boolean isRolloverEnabled() {
        return this._rolloverEnabled;
    }

    public final void setRolloverEnabled(boolean bl) {
        boolean bl2 = this._rolloverEnabled;
        if (bl != bl2) {
            this._rolloverEnabled = bl;
            this.firePropertyChange(ROLLOVER_ENABLED_CHANGED_PROPERTY, bl2, this._rolloverEnabled);
            this.repaint();
        }
    }

    public final boolean isRollover() {
        return this._rollover;
    }

    public final void setRollover(boolean bl) {
        boolean bl2 = this._rollover;
        if (bl != bl2) {
            this._rollover = bl;
            this.firePropertyChange(ROLLOVER_PROPERTY, bl2, bl);
            this.repaint();
        }
    }

    public final boolean isSelected() {
        return this._selected;
    }

    public final void setSelected(boolean bl) {
        boolean bl2 = this._selected;
        if (bl != bl2) {
            this._selected = bl;
            this.firePropertyChange(SELECTED_PROPERTY, bl2, this._selected);
            this.repaint();
        }
    }
}

