/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.swing.JideCursors;
import com.jidesoft.swing.JideSplitPane;
import com.jidesoft.swing.JideSplitPaneDivider$1;
import com.jidesoft.swing.JideSplitPaneDivider$2;
import com.jidesoft.swing.JideSplitPaneDivider$DragController;
import com.jidesoft.swing.JideSplitPaneDivider$MouseHandler;
import com.jidesoft.swing.JideSplitPaneDivider$OneTouchActionHandler;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class JideSplitPaneDivider
extends JPanel
implements PropertyChangeListener {
    protected JideSplitPaneDivider$DragController _dragger;
    protected int _dividerSize = UIDefaultsLookup.getInt("JideSplitPane.dividerSize");
    protected JideSplitPane _jideSplitPane;
    protected JideSplitPaneDivider$MouseHandler _mouseHandler;
    protected int _orientation;
    static final Cursor HORIZONTAL_CURSOR = JideCursors.getPredefinedCursor(20);
    static final Cursor VERTICAL_CURSOR = JideCursors.getPredefinedCursor(21);
    static final Cursor DEFAULT_CURSOR = Cursor.getDefaultCursor();
    private Painter _gripperPainter;
    public static final int COLLAPSED_STATE = 0;
    public static final int DEFAULT_STATE = 1;
    public static final int EXPANDED_STATE = 2;
    private int _currentState = 1;
    protected JButton _leftButton = null;
    protected JButton _rightButton = null;
    private int _triangleSize = 5;
    private int _buttonWidth = 5;
    private int _buttonHeight = 10;
    private int _lastPosition;

    public JideSplitPaneDivider(JideSplitPane jideSplitPane) {
        this.setJideSplitPane(jideSplitPane);
        this._orientation = this._jideSplitPane.getOrientation();
        this.setDividerSize(jideSplitPane.getDividerSize());
        this.setDefaultResizeCursor();
        this.setBackground(UIDefaultsLookup.getColor("JideSplitPaneDivider.background"));
        this.setBorder(UIDefaultsLookup.getBorder("JideSplitPaneDivider.border"));
        if (this._jideSplitPane.isOneTouchExpandable()) {
            this.oneTouchExpandableChanged();
        }
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideSplitPaneDivider.gripperPainter");
        this.setOpaque(false);
        this.setLayout(null);
    }

    public final void setDefaultResizeCursor() {
        this.setCursor(this._orientation == 1 ? HORIZONTAL_CURSOR : VERTICAL_CURSOR);
    }

    public final JideSplitPane getJideSplitPane() {
        return this._jideSplitPane;
    }

    public final void setJideSplitPane(JideSplitPane jideSplitPane) {
        this.uninstallListeners();
        this._jideSplitPane = jideSplitPane;
        this.installListeners();
    }

    private void installListeners() {
        if (this._jideSplitPane != null) {
            if (this._mouseHandler == null) {
                this._mouseHandler = this.createMouseHandler();
            }
            this._jideSplitPane.addMouseListener(this._mouseHandler);
            this._jideSplitPane.addMouseMotionListener(this._mouseHandler);
            this.addMouseListener(this._mouseHandler);
            this.addMouseMotionListener(this._mouseHandler);
            this._jideSplitPane.addPropertyChangeListener(this);
        }
    }

    private void uninstallListeners() {
        if (this._jideSplitPane != null) {
            this._jideSplitPane.removePropertyChangeListener(this);
            if (this._mouseHandler != null) {
                this._jideSplitPane.removeMouseListener(this._mouseHandler);
                this._jideSplitPane.removeMouseMotionListener(this._mouseHandler);
                this.removeMouseListener(this._mouseHandler);
                this.removeMouseMotionListener(this._mouseHandler);
                this._mouseHandler = null;
            }
        }
    }

    protected JideSplitPaneDivider$MouseHandler createMouseHandler() {
        return new JideSplitPaneDivider$MouseHandler(this);
    }

    public final void setDividerSize(int n) {
        this._dividerSize = n;
    }

    public final int getDividerSize() {
        return this._dividerSize;
    }

    public final Dimension getPreferredSize() {
        return new Dimension(this.getDividerSize(), this.getDividerSize());
    }

    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this._jideSplitPane) {
            if ("orientation".equals(propertyChangeEvent.getPropertyName())) {
                this._orientation = this._jideSplitPane.getOrientation();
                this.setCursor(this._orientation == 1 ? HORIZONTAL_CURSOR : VERTICAL_CURSOR);
                this.invalidate();
                this.validate();
            } else if ("oneTouchExpandable".equals(propertyChangeEvent.getPropertyName())) {
                this.setDividerSize(this._jideSplitPane.getDividerSize());
                this.oneTouchExpandableChanged();
            } else if ("dividerSize".equals(propertyChangeEvent.getPropertyName())) {
                this.setDividerSize(this._jideSplitPane.getDividerSize());
            } else if ("gripper".equals(propertyChangeEvent.getPropertyName())) {
                this.repaint();
            }
        }
    }

    public final void updateUI() {
        super.updateUI();
        this.setBackground(UIDefaultsLookup.getColor("JideSplitPaneDivider.background"));
        this.setBorder(UIDefaultsLookup.getBorder("JideSplitPaneDivider.border"));
        this._gripperPainter = (Painter)UIDefaultsLookup.get("JideSplitPaneDivider.gripperPainter");
    }

    public final void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Border border = this.getBorder();
        Dimension dimension = this.getSize();
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
        }
        if (this._jideSplitPane.isShowGripper()) {
            Rectangle rectangle = new Rectangle(dimension);
            if (this._gripperPainter != null) {
                if (rectangle.width > rectangle.height) {
                    this._gripperPainter.paint(this, graphics, rectangle, 1, 0);
                } else {
                    this._gripperPainter.paint(this, graphics, rectangle, 0, 0);
                }
            } else {
                ++rectangle.x;
                ++rectangle.y;
                JideSwingUtilities.drawGrip(graphics, rectangle, 9, UIDefaultsLookup.getInt("JideSplitPane.dividerSize") / 3);
            }
        }
    }

    protected final void prepareForDragging() {
        this._jideSplitPane.startDragging(this);
    }

    protected final void dragDividerTo(int n) {
        this._jideSplitPane.dragDividerTo(this, n);
        this._currentState = 1;
        int n2 = this._jideSplitPane.indexOfDivider(this);
        this._lastPosition = this._jideSplitPane.getDividerLocation(n2);
    }

    protected final void finishDraggingTo(int n) {
        this._jideSplitPane.finishDraggingTo(this, n);
    }

    protected final int getPreviousDividerLocation(boolean bl, boolean bl2) {
        return this._jideSplitPane.getPreviousDividerLocation(this, bl, bl2);
    }

    protected final int getNextDividerLocation(boolean bl, boolean bl2) {
        return this._jideSplitPane.getNextDividerLocation(this, bl, bl2);
    }

    public final Component getFirstComponent(boolean bl) {
        int n = this._jideSplitPane.indexOf(this);
        if (n - 1 >= 0) {
            for (int i2 = n - 1; i2 >= 0; --i2) {
                if (!bl && !this._jideSplitPane.getComponent(i2).isVisible()) continue;
                return this._jideSplitPane.getComponent(i2);
            }
            return this._jideSplitPane.getComponent(n - 1);
        }
        throw new IndexOutOfBoundsException("There is no component before divider " + n);
    }

    public final Component getSecondComponent(boolean bl) {
        int n = this._jideSplitPane.indexOf(this);
        if (n + 1 < this._jideSplitPane.getComponentCount()) {
            for (int i2 = n + 1; i2 >= 0; ++i2) {
                if (!bl && !this._jideSplitPane.getComponent(i2).isVisible()) continue;
                return this._jideSplitPane.getComponent(i2);
            }
            return this._jideSplitPane.getComponent(n + 1);
        }
        throw new IndexOutOfBoundsException("There is no component before divider " + n);
    }

    protected final void oneTouchExpandableChanged() {
        if (this._jideSplitPane.isOneTouchExpandable() && this._leftButton == null) {
            this._leftButton = this.createLeftOneTouchButton();
            if (this._leftButton != null) {
                this._leftButton.addActionListener(new JideSplitPaneDivider$OneTouchActionHandler(this, true));
                if (this._orientation == 1) {
                    this._leftButton.setBounds(1, 10, this._buttonWidth, this._buttonHeight);
                } else if (this._orientation == 0) {
                    this._leftButton.setBounds(10, 1, this._buttonHeight, this._buttonWidth);
                }
                this.add(this._leftButton);
            }
        }
        if (this._jideSplitPane.isOneTouchExpandable() && this._rightButton == null) {
            this._rightButton = this.createRightOneTouchButton();
            if (this._rightButton != null) {
                this._rightButton.addActionListener(new JideSplitPaneDivider$OneTouchActionHandler(this, false));
                if (this._orientation == 1) {
                    this._rightButton.setBounds(1, 25, this._buttonWidth, this._buttonHeight);
                } else if (this._orientation == 0) {
                    this._rightButton.setBounds(25, 1, this._buttonHeight, this._buttonWidth);
                }
                this.add(this._rightButton);
            }
        }
        if (!this._jideSplitPane.isOneTouchExpandable() && this._leftButton != null) {
            this.remove(this._leftButton);
            this._leftButton = null;
        }
        if (!this._jideSplitPane.isOneTouchExpandable() && this._rightButton != null) {
            this.remove(this._rightButton);
            this._rightButton = null;
        }
        int n = this._jideSplitPane.getPaneCount();
        if (this._jideSplitPane.isOneTouchExpandable()) {
            for (int i2 = 0; i2 < n; ++i2) {
                Component component = this._jideSplitPane.getPaneAt(i2);
                PortingUtils.setMinimumSize(component, new Dimension(0, 0));
            }
        } else {
            for (int i3 = 0; i3 < n; ++i3) {
                Component component = this._jideSplitPane.getPaneAt(i3);
                PortingUtils.setMinimumSize(component, null);
            }
        }
    }

    protected final JButton createLeftOneTouchButton() {
        JideSplitPaneDivider$1 jideSplitPaneDivider$1 = new JideSplitPaneDivider$1(this);
        jideSplitPaneDivider$1.setMinimumSize(new Dimension(this._buttonWidth, this._buttonHeight));
        jideSplitPaneDivider$1.setCursor(Cursor.getPredefinedCursor(0));
        jideSplitPaneDivider$1.setFocusPainted(false);
        jideSplitPaneDivider$1.setBorderPainted(false);
        jideSplitPaneDivider$1.setRequestFocusEnabled(false);
        return jideSplitPaneDivider$1;
    }

    public final int getCurrentState() {
        return this._currentState;
    }

    protected final JButton createRightOneTouchButton() {
        JideSplitPaneDivider$2 jideSplitPaneDivider$2 = new JideSplitPaneDivider$2(this);
        jideSplitPaneDivider$2.setMinimumSize(new Dimension(this._buttonWidth, this._buttonHeight));
        jideSplitPaneDivider$2.setCursor(Cursor.getPredefinedCursor(0));
        jideSplitPaneDivider$2.setFocusPainted(false);
        jideSplitPaneDivider$2.setBorderPainted(false);
        jideSplitPaneDivider$2.setRequestFocusEnabled(false);
        return jideSplitPaneDivider$2;
    }

    protected final Color getDarkShadowColor() {
        return UIManager.getColor("controlDkShadow");
    }

    public final void collapse() {
        if (this._leftButton != null) {
            this._leftButton.doClick();
        } else {
            new JideSplitPaneDivider$OneTouchActionHandler(this, true).actionPerformed(null);
        }
    }

    public final void expand() {
        if (this._rightButton != null) {
            this._rightButton.doClick();
        } else {
            new JideSplitPaneDivider$OneTouchActionHandler(this, false).actionPerformed(null);
        }
    }

    static final /* synthetic */ int access$000(JideSplitPaneDivider jideSplitPaneDivider) {
        return jideSplitPaneDivider._triangleSize;
    }

    static final /* synthetic */ int access$100(JideSplitPaneDivider jideSplitPaneDivider) {
        return jideSplitPaneDivider._currentState;
    }

    static final /* synthetic */ int access$102(JideSplitPaneDivider jideSplitPaneDivider, int n) {
        jideSplitPaneDivider._currentState = n;
        return jideSplitPaneDivider._currentState;
    }

    static final /* synthetic */ int access$200(JideSplitPaneDivider jideSplitPaneDivider) {
        return jideSplitPaneDivider._lastPosition;
    }

    static final /* synthetic */ int access$202(JideSplitPaneDivider jideSplitPaneDivider, int n) {
        jideSplitPaneDivider._lastPosition = n;
        return jideSplitPaneDivider._lastPosition;
    }
}

