/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.Overlayable;
import com.jidesoft.swing.OverlayableIconsFactory;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;

public class OverlayableUtils {
    public static final Overlayable getOverlayable(JComponent jComponent) {
        Container container = jComponent;
        do {
            Object object;
            if (!((object = container.getClientProperty("Overlayable.overlayable")) instanceof Overlayable)) continue;
            return (Overlayable)object;
        } while ((container = container.getParent()) instanceof JComponent);
        return null;
    }

    public static final Overlayable[] getAllOverlayables(JComponent jComponent) {
        ArrayList<Overlayable> arrayList = new ArrayList<Overlayable>();
        Container container = jComponent;
        do {
            Object object;
            if (!((object = container.getClientProperty("Overlayable.overlayable")) instanceof Overlayable) || arrayList.contains(object)) continue;
            arrayList.add((Overlayable)object);
        } while ((container = container.getParent()) != null);
        return arrayList.toArray(new Overlayable[arrayList.size()]);
    }

    public static final void repaintOverlayable(JComponent jComponent) {
        Overlayable overlayable = OverlayableUtils.getOverlayable(jComponent);
        if (overlayable != null && overlayable instanceof Component) {
            ((Component)((Object)overlayable)).repaint();
        }
    }

    public static final void repaintAllOverlayables(JComponent jComponent) {
        Overlayable[] overlayableArray;
        for (Overlayable overlayable : overlayableArray = OverlayableUtils.getAllOverlayables(jComponent)) {
            if (overlayable == null || !(overlayable instanceof Component)) continue;
            ((Component)((Object)overlayable)).repaint();
        }
    }

    public static final Icon getPredefinedOverlayIcon(String string) {
        return OverlayableIconsFactory.getImageIcon(string);
    }
}

