/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CachedVector
extends Vector {
    private Map _indexCache;
    private boolean _lazyCaching = false;

    public CachedVector() {
    }

    public CachedVector(Collection collection) {
        super(collection);
        if (!this.isLazyCaching()) {
            this.cacheAll();
        }
    }

    public CachedVector(int n) {
        super(n);
    }

    public final int indexOf(Object object) {
        this.initializeCache();
        Integer n = (Integer)this._indexCache.get(object);
        if (n != null) {
            return n;
        }
        if (this.isLazyCaching()) {
            int n2 = super.indexOf(object);
            if (n2 == -1) {
                this.uncacheIt(object);
            } else {
                this.cacheIt(object, n2);
            }
            return n2;
        }
        return -1;
    }

    protected final synchronized void adjustCache(int n, int n2) {
        if (this._indexCache != null) {
            Map map = this.createCache();
            Set set = this._indexCache.keySet();
            for (Object k2 : set) {
                int n3 = (Integer)this._indexCache.get(k2);
                if (n3 >= n) {
                    map.put(k2, n3 + n2);
                    continue;
                }
                map.put(k2, n3);
            }
            this._indexCache = map;
        }
    }

    protected final Map createCache() {
        return new IdentityHashMap();
    }

    public final synchronized void cacheIt(Object object, int n) {
        if (this._indexCache != null && (this._indexCache.get(object) == null || n < (Integer)this._indexCache.get(object))) {
            this._indexCache.put(object, n);
        }
    }

    public final synchronized void uncacheIt(Object object) {
        if (this._indexCache != null) {
            this._indexCache.remove(object);
        }
    }

    public final boolean add(Object object) {
        boolean bl = super.add(object);
        if (!this.isLazyCaching() && bl) {
            this.initializeCache();
            this.cacheIt(object, this.size() - 1);
        }
        return bl;
    }

    public final void add(int n, Object object) {
        super.add(n, object);
        if (!this.isLazyCaching()) {
            this.initializeCache();
            this.adjustCache(n, 1);
            this.cacheIt(object, n);
        } else if (this._indexCache != null) {
            this.adjustCache(n, 1);
            this.cacheIt(object, n);
        }
    }

    private void initializeCache() {
        if (this._indexCache == null) {
            this._indexCache = this.createCache();
        }
    }

    public final Object remove(int n) {
        Object e2 = super.remove(n);
        if (e2 != null) {
            this.uncacheIt(e2);
            this.adjustCache(n, -1);
        }
        return e2;
    }

    public final boolean remove(Object object) {
        int n = this.indexOf(object);
        boolean bl = super.remove(object);
        if (bl) {
            this.uncacheIt(object);
            this.adjustCache(n, -1);
        }
        return bl;
    }

    public final boolean removeAll(Collection collection) {
        this.uncacheAll();
        return super.removeAll(collection);
    }

    public final void clear() {
        this.uncacheAll();
        super.clear();
    }

    public final boolean addAll(Collection collection) {
        boolean bl = super.addAll(collection);
        if (bl) {
            this.cacheAll();
        }
        return bl;
    }

    public final boolean addAll(int n, Collection collection) {
        boolean bl = super.addAll(n, collection);
        this.initializeCache();
        this.adjustCache(n, collection.size());
        for (Object e2 : collection) {
            this.cacheIt(e2, n++);
        }
        return bl;
    }

    public final Object set(int n, Object object) {
        if (!this.isLazyCaching()) {
            this.initializeCache();
            Object object2 = super.set(n, object);
            this.uncacheIt(object2);
            this.cacheIt(object, n);
            return object2;
        }
        return super.set(n, object);
    }

    public final void invalidateCache() {
        this.uncacheAll();
    }

    public final synchronized void uncacheAll() {
        if (this._indexCache != null) {
            this._indexCache.clear();
            this._indexCache = null;
        }
    }

    public final synchronized void cacheAll() {
        this._indexCache = this.createCache();
        Integer n = 0;
        for (Object e2 : this) {
            if (this._indexCache.get(e2) == null) {
                this._indexCache.put(e2, n);
            }
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
    }

    public final boolean isLazyCaching() {
        return this._lazyCaching;
    }

    public final void setLazyCaching(boolean bl) {
        this._lazyCaching = bl;
    }

    protected final void removeRange(int n, int n2) {
        if (n == n2) {
            this.remove(n);
        } else {
            super.removeRange(n, n2);
            this.uncacheAll();
            if (!this.isLazyCaching()) {
                this.cacheAll();
            }
        }
    }
}

