/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo$JavaVersion;
import java.util.Locale;

public final class SystemInfo {
    private static boolean _isWindows = false;
    private static boolean _isWindowsNTor2000 = false;
    private static boolean _isWindowsXP = false;
    private static boolean _isWindowsVista = false;
    private static boolean _isWindows7 = false;
    private static boolean _isWindows2003 = false;
    private static boolean _isClassicWindows = false;
    private static boolean _isWindows95 = false;
    private static boolean _isWindows98 = false;
    private static boolean _supportsTray = false;
    private static boolean _isMacClassic = false;
    private static boolean _isMacOSX = false;
    private static boolean _isLinux = false;
    private static boolean _isSolaris = false;
    private static SystemInfo$JavaVersion _currentVersion;

    private SystemInfo() {
    }

    public static final String getJavaVersion() {
        return SecurityUtils.getProperty("java.version", "1.4.2");
    }

    public static final String getJavaVendor() {
        return SecurityUtils.getProperty("java.vendor", "");
    }

    public static final String getJavaClassVersion() {
        return SecurityUtils.getProperty("java.class.version", "");
    }

    public static final String getOS() {
        return SecurityUtils.getProperty("os.name", "Windows XP");
    }

    public static final String getOSVersion() {
        return SecurityUtils.getProperty("os.version", "");
    }

    public static final String getOSArchitecture() {
        return SecurityUtils.getProperty("os.arch", "");
    }

    public static final String getCurrentDirectory() {
        return SecurityUtils.getProperty("user.dir", "");
    }

    public static final boolean supportsTray() {
        return _supportsTray;
    }

    public static final void setSupportsTray(boolean bl) {
        _supportsTray = bl;
    }

    public static final boolean isWindows() {
        return _isWindows;
    }

    public static final boolean isClassicWindows() {
        return _isClassicWindows;
    }

    public static final boolean isWindowsNTor2000() {
        return _isWindowsNTor2000;
    }

    public static final boolean isWindowsXP() {
        return _isWindowsXP;
    }

    public static final boolean isWindowsVista() {
        return _isWindowsVista;
    }

    public static final boolean isWindows7() {
        return _isWindows7;
    }

    public static final boolean isWindowsVistaAbove() {
        return _isWindowsVista || _isWindows7;
    }

    public static final boolean isWindows95() {
        return _isWindows95;
    }

    public static final boolean isWindows98() {
        return _isWindows98;
    }

    public static final boolean isWindows2003() {
        return _isWindows2003;
    }

    public static final boolean isMacClassic() {
        return _isMacClassic;
    }

    public static final boolean isMacOSX() {
        return _isMacOSX;
    }

    public static final boolean isAnyMac() {
        return _isMacClassic || _isMacOSX;
    }

    public static final boolean isSolaris() {
        return _isSolaris;
    }

    public static final boolean isLinux() {
        return _isLinux;
    }

    public static final boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    private static void checkJdkVersion() {
        if (_currentVersion == null) {
            _currentVersion = new SystemInfo$JavaVersion(SystemInfo.getJavaVersion());
        }
    }

    public static final boolean isJdk13Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.3, 0, 0) >= 0;
    }

    public static final boolean isJdk142Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.4, 2, 0) >= 0;
    }

    public static final boolean isJdk14Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.4, 0, 0) >= 0;
    }

    public static final boolean isJdk15Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.5, 0, 0) >= 0;
    }

    public static final boolean isJdk6Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 0) >= 0;
    }

    public static final boolean isJdk6u10Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 10) >= 0;
    }

    public static final boolean isJdk6u14Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 14) >= 0;
    }

    public static final boolean isJdk6u25Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.6, 0, 25) >= 0;
    }

    public static final boolean isJdk7Above() {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(1.7, 0, 0) >= 0;
    }

    public static final boolean isJdkVersion(double d2, int n, int n2) {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(d2, n, n2) == 0;
    }

    public static final boolean isJdkVersionAbove(double d2, int n, int n2) {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(d2, n, n2) >= 0;
    }

    public static final boolean isJdkVersionBelow(double d2, int n, int n2) {
        SystemInfo.checkJdkVersion();
        return _currentVersion.compareVersion(d2, n, n2) <= 0;
    }

    public static final boolean isCJKLocale() {
        return SystemInfo.isCJKLocale(Locale.getDefault());
    }

    public static final boolean isCJKLocale(Locale locale) {
        return locale.equals(Locale.CHINA) || locale.equals(Locale.CHINESE) || locale.equals(new Locale("zh", "HK")) || locale.equals(Locale.TAIWAN) || locale.equals(Locale.JAPAN) || locale.equals(Locale.JAPANESE) || locale.equals(Locale.KOREA) || locale.equals(Locale.KOREAN);
    }

    static {
        String string = SecurityUtils.getProperty("os.name", "Windows XP");
        _isWindows = string.indexOf("Windows") != -1;
        try {
            String string2 = SecurityUtils.getProperty("os.version", "5.0");
            Float f2 = Float.valueOf(string2);
            _isClassicWindows = (double)f2.floatValue() <= 4.0;
        }
        catch (NumberFormatException numberFormatException) {
            _isClassicWindows = false;
        }
        if (string.indexOf("Windows XP") != -1 || string.indexOf("Windows NT") != -1 || string.indexOf("Windows 2000") != -1) {
            _isWindowsNTor2000 = true;
        }
        if (string.indexOf("Windows XP") != -1) {
            _isWindowsXP = true;
        }
        if (string.indexOf("Windows Vista") != -1) {
            _isWindowsVista = true;
        }
        if (string.indexOf("Windows 7") != -1) {
            _isWindows7 = true;
        }
        if (string.indexOf("Windows 2003") != -1) {
            _isWindows2003 = true;
            _isWindowsXP = true;
        }
        if (string.indexOf("Windows 95") != -1) {
            _isWindows95 = true;
        }
        if (string.indexOf("Windows 98") != -1) {
            _isWindows98 = true;
        }
        if (_isWindows) {
            _supportsTray = true;
        }
        _isSolaris = string.indexOf("Solaris") != -1 || string.indexOf("SunOS") != -1;
        boolean bl = _isLinux = string.indexOf("Linux") != -1;
        if (string.startsWith("Mac OS")) {
            if (string.endsWith("X")) {
                _isMacOSX = true;
            } else {
                _isMacClassic = true;
            }
        }
    }
}

