/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.SeekableStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class FileCacheSeekableStream
extends SeekableStream {
    private InputStream stream;
    private File cacheFile;
    private RandomAccessFile cache;
    private int bufLen = 1024;
    private byte[] buf = new byte[this.bufLen];
    private long length = 0L;
    private long pointer = 0L;
    private boolean foundEOF = false;

    public FileCacheSeekableStream(InputStream inputStream) {
        this.stream = inputStream;
        this.cacheFile = File.createTempFile("jai-FCSS-", ".tmp");
        this.cacheFile.deleteOnExit();
        this.cache = new RandomAccessFile(this.cacheFile, "rw");
    }

    public final boolean canSeekBackwards() {
        return true;
    }

    public final void close() {
        super.close();
        this.cache.close();
        this.cacheFile.delete();
    }

    public final long getFilePointer() {
        return this.pointer;
    }

    public final int read() {
        long l2 = this.pointer + 1L;
        long l3 = this.readUntil(l2);
        if (l3 >= l2) {
            this.cache.seek(this.pointer++);
            return this.cache.read();
        }
        return -1;
    }

    public final int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        long l2 = this.readUntil(this.pointer + (long)n2);
        if ((n2 = (int)Math.min((long)n2, l2 - this.pointer)) > 0) {
            this.cache.seek(this.pointer);
            this.cache.readFully(byArray, n, n2);
            this.pointer += (long)n2;
            return n2;
        }
        return -1;
    }

    private long readUntil(long l2) {
        if (l2 < this.length) {
            return l2;
        }
        if (this.foundEOF) {
            return this.length;
        }
        long l3 = l2 - this.length;
        this.cache.seek(this.length);
        while (l3 > 0L) {
            int n = this.stream.read(this.buf, 0, (int)Math.min(l3, (long)this.bufLen));
            if (n == -1) {
                this.foundEOF = true;
                return this.length;
            }
            this.cache.setLength(this.cache.length() + (long)n);
            this.cache.write(this.buf, 0, n);
            l3 -= (long)n;
            this.length += (long)n;
        }
        return l2;
    }

    public final void seek(long l2) {
        if (l2 < 0L) {
            throw new IOException(JaiI18N.getString("FileCacheSeekableStream0"));
        }
        this.pointer = l2;
    }
}

