/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codec;

import com.sun.media.jai.codec.JaiI18N;
import com.sun.media.jai.codec.PNGEncodeParam;

public class PNGEncodeParam$Palette
extends PNGEncodeParam {
    private boolean backgroundSet = false;
    private int[] palette = null;
    private boolean paletteSet = false;
    private int backgroundPaletteIndex;
    private int[] transparency;

    public final int getBackgroundPaletteIndex() {
        if (!this.backgroundSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam4"));
        }
        return this.backgroundPaletteIndex;
    }

    public final int[] getPalette() {
        if (!this.paletteSet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam3"));
        }
        return (int[])this.palette.clone();
    }

    public final byte[] getPaletteTransparency() {
        if (!this.transparencySet) {
            throw new IllegalStateException(JaiI18N.getString("PNGEncodeParam5"));
        }
        byte[] byArray = new byte[this.transparency.length];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)this.transparency[n];
            ++n;
        }
        return byArray;
    }

    public final boolean isBackgroundSet() {
        return this.backgroundSet;
    }

    public final boolean isPaletteSet() {
        return this.paletteSet;
    }

    public final void setBackgroundPaletteIndex(int n) {
        this.backgroundPaletteIndex = n;
        this.backgroundSet = true;
    }

    public final void setBitDepth(int n) {
        if (n != 1 && n != 2 && n != 4 && n != 8) {
            throw new IllegalArgumentException(JaiI18N.getString("PNGEncodeParam2"));
        }
        this.bitDepth = n;
        this.bitDepthSet = true;
    }

    public final void setPalette(int[] nArray) {
        if (nArray.length < 3 || nArray.length > 768) {
            throw new IllegalArgumentException(JaiI18N.getString("PNGEncodeParam0"));
        }
        if (nArray.length % 3 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("PNGEncodeParam1"));
        }
        this.palette = (int[])nArray.clone();
        this.paletteSet = true;
    }

    public final void setPaletteTransparency(byte[] byArray) {
        this.transparency = new int[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            this.transparency[n] = byArray[n] & 0xFF;
            ++n;
        }
        this.transparencySet = true;
    }

    public final void unsetBackground() {
        this.backgroundSet = false;
    }

    public final void unsetPalette() {
        this.palette = null;
        this.paletteSet = false;
    }
}

