/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.util.PackedPixelData;
import com.sun.media.jai.util.PixelAccessor;
import com.sun.media.jai.util.UnpackedPixelData;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class PNMImage
extends SimpleRenderedImage {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private SeekableStream input;
    private byte[] lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator")).getBytes();
    private int variant;
    private int maxValue;
    private WritableRaster tile = null;
    private int pixelType;
    private int numBands;

    public PNMImage(SeekableStream seekableStream) {
        try {
            if (seekableStream.read() != 80) {
                throw new RuntimeException(JaiI18N.getString("PNMImageDecoder0"));
            }
            this.variant = seekableStream.read();
            if (this.variant < 49 || this.variant > 54) {
                throw new RuntimeException(JaiI18N.getString("PNMImageDecoder0"));
            }
            this.width = this.readInteger(seekableStream);
            this.height = this.readInteger(seekableStream);
            this.maxValue = this.variant == 49 || this.variant == 52 ? 1 : this.readInteger(seekableStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(JaiI18N.getString("PNMImageDecoder1"));
        }
        this.input = seekableStream;
        this.minX = 0;
        this.minY = 0;
        this.tileGridXOffset = 0;
        this.tileGridYOffset = 0;
        this.tileWidth = this.width;
        this.tileHeight = this.height;
        if (this.isRaw(this.variant) && this.maxValue >= 256) {
            this.maxValue = 255;
        }
        this.numBands = this.variant == 51 || this.variant == 54 ? 3 : 1;
        this.pixelType = this.maxValue == 1 ? -1 : (this.maxValue < 256 ? 0 : (this.maxValue < 65536 ? 1 : 3));
        if (this.variant == 49 || this.variant == 52) {
            this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 1);
            byte[] byArray = new byte[]{-1, 0};
            this.colorModel = new IndexColorModel(1, 2, byArray, byArray, byArray);
        } else {
            int[] nArray = new int[this.numBands];
            int n = 0;
            while (n < this.numBands) {
                nArray[n] = this.numBands - 1 - n;
                ++n;
            }
            this.sampleModel = new PixelInterleavedSampleModel(this.pixelType, this.tileWidth, this.tileHeight, this.numBands, this.numBands * this.tileWidth, nArray);
            this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
        }
    }

    private void computeTile() {
        PixelAccessor pixelAccessor = new PixelAccessor(this);
        this.tile = Raster.createWritableRaster(this.sampleModel, new Point(0, 0));
        Rectangle rectangle = this.tile.getBounds();
        try {
            block30: {
                switch (this.variant) {
                    case 49: 
                    case 52: {
                        PackedPixelData packedPixelData = pixelAccessor.getPackedData(this.tile, rectangle, true);
                        byte[] byArray = packedPixelData.getData();
                        int n = packedPixelData.lineStride;
                        int n2 = packedPixelData.getOffset(0);
                        if (this.variant == 52) {
                            this.input.read(byArray, n2, byArray.length);
                            break;
                        }
                        int n3 = n2 + this.height * n;
                        int n4 = n2;
                        while (n4 < n3) {
                            int n5;
                            int n6;
                            int n7 = this.width;
                            int n8 = n4;
                            while (n7 >= 8) {
                                n6 = this.readInteger(this.input);
                                n5 = this.readInteger(this.input);
                                int n9 = this.readInteger(this.input);
                                int n10 = this.readInteger(this.input);
                                int n11 = this.readInteger(this.input);
                                int n12 = this.readInteger(this.input);
                                int n13 = this.readInteger(this.input);
                                int n14 = this.readInteger(this.input);
                                byArray[n8] = (byte)(n6 << 7 | n5 << 6 | n9 << 5 | n10 << 4 | n11 << 3 | n12 << 2 | n13 << 1 | n14);
                                n7 -= 8;
                                ++n8;
                            }
                            if (n7 > 0) {
                                n6 = byArray[n8];
                                n5 = 7;
                                while (n7 > 0) {
                                    n6 = (byte)(n6 | this.readInteger(this.input) << n5);
                                    --n7;
                                    --n5;
                                }
                                byArray[n8] = n6;
                            }
                            n4 += n;
                        }
                        break;
                    }
                    case 50: 
                    case 51: 
                    case 53: 
                    case 54: {
                        UnpackedPixelData unpackedPixelData = pixelAccessor.getData(this.tile, rectangle, this.pixelType, true);
                        int n = unpackedPixelData.getMinOffset();
                        int n15 = n + this.height * unpackedPixelData.lineStride;
                        if (this.isRaw(this.variant)) {
                            byte[] byArray = unpackedPixelData.getByteData(0);
                            this.input.read(byArray, n, byArray.length);
                            if (this.variant != 54) break;
                            int n16 = n;
                            while (n16 < n15) {
                                byte by = byArray[n16];
                                byArray[n16] = byArray[n16 + 2];
                                byArray[n16 + 2] = by;
                                n16 += 3;
                            }
                            break;
                        }
                        switch (this.pixelType) {
                            case 0: {
                                byte[] byArray = unpackedPixelData.getByteData(0);
                                if (this.numBands == 1) {
                                    int n17 = n;
                                    while (n17 < n15) {
                                        byArray[n17] = (byte)this.readInteger(this.input);
                                        ++n17;
                                    }
                                } else {
                                    int n18 = n;
                                    while (n18 < n15) {
                                        byArray[n18 + 2] = (byte)this.readInteger(this.input);
                                        byArray[n18 + 1] = (byte)this.readInteger(this.input);
                                        byArray[n18] = (byte)this.readInteger(this.input);
                                        n18 += 3;
                                    }
                                }
                                break block30;
                            }
                            case 1: {
                                short[] sArray = unpackedPixelData.getShortData(0);
                                if (this.numBands == 1) {
                                    int n19 = n;
                                    while (n19 < n15) {
                                        sArray[n19] = (short)this.readInteger(this.input);
                                        ++n19;
                                    }
                                } else {
                                    int n20 = n;
                                    while (n20 < n15) {
                                        sArray[n20 + 2] = (short)this.readInteger(this.input);
                                        sArray[n20 + 1] = (short)this.readInteger(this.input);
                                        sArray[n20] = (short)this.readInteger(this.input);
                                        n20 += 3;
                                    }
                                }
                                break block30;
                            }
                            case 3: {
                                int[] nArray = unpackedPixelData.getIntData(0);
                                if (this.numBands == 1) {
                                    int n21 = n;
                                    while (n21 < n15) {
                                        nArray[n21] = this.readInteger(this.input);
                                        ++n21;
                                    }
                                } else {
                                    int n22 = n;
                                    while (n22 < n15) {
                                        nArray[n22 + 2] = this.readInteger(this.input);
                                        nArray[n22 + 1] = this.readInteger(this.input);
                                        nArray[n22] = this.readInteger(this.input);
                                        n22 += 3;
                                    }
                                    break block1;
                                }
                            }
                        }
                    }
                }
            }
            this.input.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(JaiI18N.getString("PNMImageDecoder1"));
        }
    }

    public final synchronized Raster getTile(int n, int n2) {
        if (n == 0 && n2 == 0) {
            if (this.tile == null) {
                this.computeTile();
            }
            return this.tile;
        }
        return null;
    }

    private boolean isRaw(int n) {
        return n >= 52;
    }

    private int readInteger(SeekableStream seekableStream) {
        int n;
        int n2 = 0;
        boolean bl = false;
        while ((n = seekableStream.read()) != -1) {
            char c2 = (char)n;
            if (Character.isDigit(c2)) {
                n2 = n2 * 10 + Character.digit(c2, 10);
                bl = true;
                continue;
            }
            if (c2 == '#') {
                int n3 = this.lineSeparator.length;
                while ((n = seekableStream.read()) != -1) {
                    boolean bl2 = false;
                    int n4 = 0;
                    while (n4 < n3) {
                        if (n == this.lineSeparator[n4]) {
                            bl2 = true;
                            break;
                        }
                        ++n4;
                    }
                    if (bl2) break;
                }
                if (n == -1) break;
            }
            if (bl) break;
        }
        return n2;
    }
}

