/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.fpx;

import com.sun.media.jai.codec.ByteArraySeekableStream;
import com.sun.media.jai.codec.FileSeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.SegmentedSeekableStream;
import com.sun.media.jai.codecimpl.fpx.FPXUtils;
import com.sun.media.jai.codecimpl.fpx.PropertySet;
import com.sun.media.jai.codecimpl.fpx.SSDirectoryEntry;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public class StructuredStorage {
    SeekableStream file;
    private int sectorShift;
    private int miniSectorShift;
    private long csectFat;
    private long sectDirStart;
    private long miniSectorCutoff;
    private long sectMiniFatStart;
    private long csectMiniFat;
    private long sectDifStart;
    private long csectDif;
    private long[] sectFat;
    private long[] MINIFAT;
    private SSDirectoryEntry[] DIR;
    private SeekableStream miniStream;
    private SeekableStream FATStream;
    long cwdIndex = -1L;

    public StructuredStorage(SeekableStream seekableStream) {
        this.file = seekableStream;
        this.getHeader();
        this.getFat();
        this.getMiniFat();
        this.getDirectory();
        this.getMiniStream();
    }

    public final boolean changeDirectory(String string) {
        long l2 = this.searchDirectory(string, this.cwdIndex);
        if (l2 != -1L) {
            this.cwdIndex = this.getDirectoryEntry(l2).getSIDChild();
            return true;
        }
        return false;
    }

    public final void changeDirectoryToRoot() {
        this.cwdIndex = this.getDirectoryEntry(0L).getSIDChild();
    }

    private int getCurrentIndex() {
        return -1;
    }

    private void getDirectory() {
        int n = this.getSectorSize();
        long l2 = this.sectDirStart;
        int n2 = 0;
        while (l2 != 0xFFFFFFFEL) {
            l2 = this.getFATSector(l2);
            ++n2;
        }
        int n3 = 4 * n2;
        this.DIR = new SSDirectoryEntry[n3];
        l2 = this.sectDirStart;
        byte[] byArray = new byte[n];
        int n4 = 0;
        while (l2 != 0xFFFFFFFEL) {
            this.readSector(l2, byArray, 0);
            int n5 = 0;
            int n6 = 0;
            while (n6 < 4) {
                short s = FPXUtils.getShortLE(byArray, n5 + 64);
                String string = FPXUtils.getString(byArray, n5, s);
                long l3 = FPXUtils.getUnsignedIntLE(byArray, n5 + 68);
                long l4 = FPXUtils.getUnsignedIntLE(byArray, n5 + 72);
                long l5 = FPXUtils.getUnsignedIntLE(byArray, n5 + 76);
                long l6 = FPXUtils.getUnsignedIntLE(byArray, n5 + 116);
                long l7 = FPXUtils.getUnsignedIntLE(byArray, n5 + 120);
                this.DIR[n4] = new SSDirectoryEntry(n4, string, l7, l6, l3, l4, l5);
                ++n4;
                n5 += 128;
                ++n6;
            }
            l2 = this.getFATSector(l2);
        }
    }

    private SSDirectoryEntry getDirectoryEntry(long l2) {
        return this.DIR[(int)l2];
    }

    private long getFATSector(long l2) {
        this.FATStream.seek(4L * l2);
        return this.FATStream.readUnsignedIntLE();
    }

    private void getFat() {
        long l2;
        int n = this.getSectorSize();
        int n2 = n / 4;
        int n3 = n / 4 - 1;
        int n4 = (int)(this.csectFat + this.csectDif * (long)n3);
        long[] lArray = new long[n4];
        int n5 = 0;
        int n6 = 0;
        while (n6 < 109) {
            l2 = this.sectFat[n6];
            if (l2 == 0xFFFFFFFFL) break;
            lArray[n5++] = this.getOffsetOfSector(this.sectFat[n6]);
            ++n6;
        }
        if (this.csectDif > 0L) {
            l2 = this.sectDifStart;
            byte[] byArray = new byte[n];
            int n7 = 0;
            while ((long)n7 < this.csectDif) {
                this.readSector(l2, byArray, 0);
                int n8 = 0;
                while (n8 < n3) {
                    int n9 = FPXUtils.getIntLE(byArray, 4 * n8);
                    lArray[n5++] = this.getOffsetOfSector(n9);
                    ++n8;
                }
                l2 = FPXUtils.getIntLE(byArray, n - 4);
                ++n7;
            }
        }
        this.FATStream = new SegmentedSeekableStream(this.file, lArray, n, n4 * n, true);
    }

    private void getHeader() {
        this.file.seek(30L);
        this.sectorShift = this.file.readUnsignedShortLE();
        this.file.seek(32L);
        this.miniSectorShift = this.file.readUnsignedShortLE();
        this.file.seek(44L);
        this.csectFat = this.file.readUnsignedIntLE();
        this.file.seek(48L);
        this.sectDirStart = this.file.readUnsignedIntLE();
        this.file.seek(56L);
        this.miniSectorCutoff = this.file.readUnsignedIntLE();
        this.file.seek(60L);
        this.sectMiniFatStart = this.file.readUnsignedIntLE();
        this.file.seek(64L);
        this.csectMiniFat = this.file.readUnsignedIntLE();
        this.file.seek(68L);
        this.sectDifStart = this.file.readUnsignedIntLE();
        this.file.seek(72L);
        this.csectDif = this.file.readUnsignedIntLE();
        this.sectFat = new long[109];
        this.file.seek(76L);
        int n = 0;
        while (n < 109) {
            this.sectFat[n] = this.file.readUnsignedIntLE();
            ++n;
        }
    }

    private int getIndex(String string, int n) {
        return -1;
    }

    private int getLength(long l2) {
        return (int)this.DIR[(int)l2].getSize();
    }

    private long getMiniFATSector(long l2) {
        return this.MINIFAT[(int)l2];
    }

    private void getMiniFat() {
        int n = this.getSectorSize();
        int n2 = n / 4;
        int n3 = 0;
        this.MINIFAT = new long[(int)(this.csectMiniFat * (long)n2)];
        long l2 = this.sectMiniFatStart;
        byte[] byArray = new byte[n];
        while (l2 != 0xFFFFFFFEL) {
            this.readSector(l2, byArray, 0);
            int n4 = 0;
            while (n4 < n2) {
                this.MINIFAT[n3++] = FPXUtils.getIntLE(byArray, 4 * n4);
                ++n4;
            }
            l2 = this.getFATSector(l2);
        }
    }

    private int getMiniSectorSize() {
        return 1 << this.miniSectorShift;
    }

    private void getMiniStream() {
        int n = this.getLength(0L);
        int n2 = this.getSectorSize();
        int n3 = (n + n2 - 1) / n2;
        long[] lArray = new long[n3];
        long l2 = this.getStartSector(0L);
        int n4 = 0;
        while (n4 < n3 - 1) {
            lArray[n4] = this.getOffsetOfSector(l2);
            l2 = this.getFATSector(l2);
            ++n4;
        }
        lArray[n3 - 1] = this.getOffsetOfSector(l2);
        this.miniStream = new SegmentedSeekableStream(this.file, lArray, n2, n, true);
    }

    private long getOffsetOfMiniSector(long l2) {
        return l2 * (long)this.getMiniSectorSize();
    }

    private long getOffsetOfSector(long l2) {
        return l2 * (long)this.getSectorSize() + 512L;
    }

    private int getSectorSize() {
        return 1 << this.sectorShift;
    }

    private long getStartSector(long l2) {
        return this.DIR[(int)l2].getStartSector();
    }

    public final SeekableStream getStream(String string) {
        long l2 = this.getStreamIndex(string);
        if (l2 == -1L) {
            return null;
        }
        int n = this.getLength(l2);
        if ((long)n > this.miniSectorCutoff) {
            int n2 = this.getSectorSize();
            int n3 = (n + n2 - 1) / n2;
            long[] lArray = new long[n3];
            long l3 = this.getStartSector(l2);
            int n4 = 0;
            while (n4 < n3 - 1) {
                lArray[n4] = this.getOffsetOfSector(l3);
                l3 = this.getFATSector(l3);
                ++n4;
            }
            lArray[n3 - 1] = this.getOffsetOfSector(l3);
            return new SegmentedSeekableStream(this.file, lArray, n2, n, true);
        }
        int n5 = this.getMiniSectorSize();
        int n6 = (n + n5 - 1) / n5;
        long[] lArray = new long[n6];
        long l4 = this.getStartSector(l2);
        int n7 = 0;
        while (n7 < n6 - 1) {
            lArray[n7] = this.getOffsetOfMiniSector(l4);
            l4 = this.getMiniFATSector(l4);
            ++n7;
        }
        lArray[n6 - 1] = this.getOffsetOfMiniSector(l4);
        return new SegmentedSeekableStream(this.miniStream, lArray, n5, n, true);
    }

    public final byte[] getStreamAsBytes(String string) {
        long l2 = this.getStreamIndex(string);
        if (l2 == -1L) {
            return null;
        }
        int n = this.getLength(l2);
        byte[] byArray = new byte[n];
        if ((long)n > this.miniSectorCutoff) {
            int n2 = this.getSectorSize();
            int n3 = (n + n2 - 1) / n2;
            long l3 = this.getStartSector(l2);
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3 - 1) {
                this.readSector(l3, byArray, n4, n2);
                n4 += n2;
                l3 = this.getFATSector(l3);
                ++n5;
            }
            this.readSector(l3, byArray, n4, n - n4);
        } else {
            int n6 = this.getMiniSectorSize();
            int n7 = (n + n6 - 1) / n6;
            long l4 = this.getStartSector(l2);
            int n8 = 0;
            int n9 = 0;
            while (n9 < n7 - 1) {
                long l5 = this.getOffsetOfMiniSector(l4);
                this.readMiniSector(l4, byArray, n8, n6);
                n8 += n6;
                l4 = this.getMiniFATSector(l4);
                ++n9;
            }
            this.readMiniSector(l4, byArray, n8, n - n8);
        }
        return byArray;
    }

    private long getStreamIndex(String string) {
        long l2 = this.cwdIndex;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!bl) {
                l2 = this.getDirectoryEntry(l2).getSIDChild();
            } else {
                bl = false;
            }
            l2 = this.searchDirectory(string2, l2);
        }
        return l2;
    }

    public static final void main(String[] stringArray) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(stringArray[0], "r");
            FileSeekableStream fileSeekableStream = new FileSeekableStream(randomAccessFile);
            StructuredStorage structuredStorage = new StructuredStorage(fileSeekableStream);
            structuredStorage.changeDirectoryToRoot();
            byte[] byArray = structuredStorage.getStreamAsBytes("\u0005SummaryInformation");
            PropertySet propertySet = new PropertySet(new ByteArraySeekableStream(byArray));
            byte[] byArray2 = propertySet.getBlob(17);
            System.out.print("BM");
            int n = byArray2.length - 8 + 14 + 40;
            System.out.print((char)(n & 0xFF));
            System.out.print((char)(n >> 8 & 0xFF));
            System.out.print((char)(n >> 16 & 0xFF));
            System.out.print((char)(n >> 24 & 0xFF));
            System.out.print('\u0000');
            System.out.print('\u0000');
            System.out.print('\u0000');
            System.out.print('\u0000');
            System.out.print('6');
            System.out.print('\u0000');
            System.out.print('\u0000');
            System.out.print('\u0000');
            int n2 = 8;
            while (n2 < byArray2.length) {
                System.out.print((char)(byArray2[n2] & 0xFF));
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void readMiniSector(long l2, byte[] byArray, int n) {
        this.readMiniSector(l2, byArray, n, this.getMiniSectorSize());
    }

    private void readMiniSector(long l2, byte[] byArray, int n, int n2) {
        this.miniStream.seek(this.getOffsetOfMiniSector(l2));
        this.miniStream.read(byArray, n, n2);
    }

    private void readSector(long l2, byte[] byArray, int n) {
        this.readSector(l2, byArray, n, this.getSectorSize());
    }

    private void readSector(long l2, byte[] byArray, int n, int n2) {
        this.file.seek(this.getOffsetOfSector(l2));
        this.file.read(byArray, n, n2);
    }

    private long searchDirectory(String string, long l2) {
        if (l2 == 0xFFFFFFFFL) {
            return -1L;
        }
        SSDirectoryEntry sSDirectoryEntry = this.getDirectoryEntry(l2);
        if (string.equals(sSDirectoryEntry.getName())) {
            return l2;
        }
        long l3 = this.searchDirectory(string, sSDirectoryEntry.getSIDLeftSibling());
        if (l3 != -1L) {
            return l3;
        }
        long l4 = this.searchDirectory(string, sSDirectoryEntry.getSIDRightSibling());
        if (l4 != -1L) {
            return l4;
        }
        return -1L;
    }
}

